/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.elasticsearch.index.mapper.FieldMapper;

public final class TimeSeriesParams {
    public static final String TIME_SERIES_METRIC_PARAM = "time_series_metric";
    public static final String TIME_SERIES_DIMENSION_PARAM = "time_series_dimension";

    private TimeSeriesParams() {
    }

    public static FieldMapper.Parameter<MetricType> metricParam(Function<FieldMapper, MetricType> initializer, MetricType ... values) {
        assert (values.length > 0);
        EnumSet<MetricType> acceptedValues = EnumSet.noneOf(MetricType.class);
        acceptedValues.addAll(Arrays.asList(values));
        return FieldMapper.Parameter.restrictedEnumParam(TIME_SERIES_METRIC_PARAM, false, initializer, (MetricType)null, MetricType.class, acceptedValues).acceptsNull();
    }

    public static FieldMapper.Parameter<Boolean> dimensionParam(Function<FieldMapper, Boolean> initializer, BooleanSupplier hasDocValues) {
        return FieldMapper.Parameter.boolParam(TIME_SERIES_DIMENSION_PARAM, false, initializer, false).addValidator(v -> {
            if (v.booleanValue() && !hasDocValues.getAsBoolean()) {
                throw new IllegalArgumentException("Field [time_series_dimension] requires that [doc_values] is true");
            }
        });
    }

    public static enum MetricType {
        GAUGE(new String[]{"max", "min", "value_count", "sum"}),
        COUNTER(new String[]{"last_value"}),
        HISTOGRAM(new String[0], false),
        POSITION(new String[0], false);

        private final String[] supportedAggs;
        private final boolean scalar;

        private MetricType(String[] supportedAggs) {
            this(supportedAggs, true);
        }

        private MetricType(String[] supportedAggs, boolean scalar) {
            this.supportedAggs = supportedAggs;
            this.scalar = scalar;
        }

        public String[] supportedAggs() {
            return this.supportedAggs;
        }

        public static MetricType[] scalar() {
            return (MetricType[])Arrays.stream(MetricType.values()).filter(m -> m.scalar).toArray(MetricType[]::new);
        }

        public final String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static MetricType fromString(String value) {
            for (MetricType metricType : MetricType.values()) {
                if (!metricType.toString().equals(value)) continue;
                return metricType;
            }
            throw new IllegalArgumentException("No enum constant MetricType." + value);
        }
    }
}

