/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;
import org.elasticsearch.index.mapper.VersionFieldMapper;
import org.elasticsearch.xcontent.XContentType;

public class ParsedDocument {
    private final Field version;
    private final String id;
    private final SeqNoFieldMapper.SequenceIDFields seqID;
    private final String routing;
    private final List<LuceneDocument> documents;
    private final long normalizedSize;
    private BytesReference source;
    private XContentType xContentType;
    private Mapping dynamicMappingsUpdate;

    public static ParsedDocument noopTombstone(SeqNoFieldMapper.SeqNoIndexOptions seqNoIndexOptions, String reason) {
        LuceneDocument document = new LuceneDocument();
        SeqNoFieldMapper.SequenceIDFields seqIdFields = SeqNoFieldMapper.SequenceIDFields.tombstone(seqNoIndexOptions);
        seqIdFields.addFields(document);
        Field versionField = VersionFieldMapper.versionField();
        document.add(versionField);
        BytesRef byteRef = new BytesRef(reason);
        document.add(new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
        return new ParsedDocument(versionField, seqIdFields, "", null, Collections.singletonList(document), new BytesArray("{}"), XContentType.JSON, null, -1L);
    }

    public static ParsedDocument deleteTombstone(SeqNoFieldMapper.SeqNoIndexOptions seqNoIndexOptions, String id) {
        return ParsedDocument.deleteTombstone(seqNoIndexOptions, false, false, id, null);
    }

    public static ParsedDocument deleteTombstone(SeqNoFieldMapper.SeqNoIndexOptions seqNoIndexOptions, boolean useDocValuesSkipper, boolean useSyntheticId, String id, BytesRef uid) {
        LuceneDocument document = new LuceneDocument();
        SeqNoFieldMapper.SequenceIDFields seqIdFields = SeqNoFieldMapper.SequenceIDFields.tombstone(seqNoIndexOptions);
        seqIdFields.addFields(document);
        Field versionField = VersionFieldMapper.versionField();
        document.add(versionField);
        if (useSyntheticId) {
            document.add(IdFieldMapper.syntheticIdField(id));
            BytesRef timeSeriesId = TsidExtractingIdFieldMapper.extractTimeSeriesIdFromSyntheticId(uid);
            long timestamp = TsidExtractingIdFieldMapper.extractTimestampFromSyntheticId(uid);
            BytesRef routingHash = TsidExtractingIdFieldMapper.extractRoutingHashBytesFromSyntheticId(uid);
            if (useDocValuesSkipper) {
                document.add(SortedDocValuesField.indexedField("_tsid", timeSeriesId));
                document.add(SortedNumericDocValuesField.indexedField("@timestamp", timestamp));
            } else {
                document.add(new SortedDocValuesField("_tsid", timeSeriesId));
                document.add(new LongField("@timestamp", timestamp, Field.Store.NO));
            }
            SortedDocValuesField field = new SortedDocValuesField("_ts_routing_hash", routingHash);
            document.add(field);
        } else {
            document.add(IdFieldMapper.standardIdField(id));
        }
        return new ParsedDocument(versionField, seqIdFields, id, null, Collections.singletonList(document), new BytesArray("{}"), XContentType.JSON, null, -1L);
    }

    public ParsedDocument(Field version, SeqNoFieldMapper.SequenceIDFields seqID, String id, String routing, List<LuceneDocument> documents, BytesReference source, XContentType xContentType, Mapping dynamicMappingsUpdate, long normalizedSize) {
        this.version = version;
        this.seqID = seqID;
        this.id = id;
        this.routing = routing;
        this.documents = documents;
        this.source = source;
        this.dynamicMappingsUpdate = dynamicMappingsUpdate;
        this.xContentType = xContentType;
        this.normalizedSize = normalizedSize;
    }

    public String id() {
        return this.id;
    }

    public Field version() {
        return this.version;
    }

    public void updateSeqID(long seqNo, long primaryTerm) {
        this.seqID.set(seqNo, primaryTerm);
    }

    public String routing() {
        return this.routing;
    }

    public LuceneDocument rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<LuceneDocument> docs() {
        return this.documents;
    }

    public BytesReference source() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
    }

    public Mapping dynamicMappingsUpdate() {
        return this.dynamicMappingsUpdate;
    }

    public void addDynamicMappingsUpdate(Mapping update) {
        this.dynamicMappingsUpdate = this.dynamicMappingsUpdate == null ? update : this.dynamicMappingsUpdate.merge(update, MapperService.MergeReason.MAPPING_AUTO_UPDATE, Long.MAX_VALUE);
    }

    public String toString() {
        return "Document id[" + this.id + "] doc [" + String.valueOf(this.documents) + "]";
    }

    public String documentDescription() {
        return "id";
    }

    public long getNormalizedSize() {
        return this.normalizedSize;
    }
}

