/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.function.Consumer;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.LuceneGeometriesUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;

public interface GeoShapeQueryable {
    public Query geoShapeQuery(SearchExecutionContext var1, String var2, ShapeRelation var3, LatLonGeometry ... var4);

    default public Query geoShapeQuery(SearchExecutionContext context, String fieldName, ShapeRelation relation, Geometry geometry) {
        LatLonGeometry[] luceneGeometries;
        Consumer<ShapeType> checker = relation == ShapeRelation.WITHIN ? t -> {
            if (t == ShapeType.LINESTRING) {
                throw new IllegalArgumentException("found an unsupported shape Line");
            }
        } : t -> {};
        try {
            luceneGeometries = LuceneGeometriesUtils.toLatLonGeometry(geometry, true, checker);
        }
        catch (IllegalArgumentException e) {
            throw new QueryShardException((QueryRewriteContext)context, "Exception creating query on Field [" + fieldName + "] " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        if (luceneGeometries.length == 0) {
            return Queries.NO_DOCS_INSTANCE;
        }
        return this.geoShapeQuery(context, fieldName, relation, luceneGeometries);
    }

    @Deprecated
    default public Query geoShapeQuery(SearchExecutionContext context, String fieldName, SpatialStrategy strategy, ShapeRelation relation, Geometry shape) {
        return this.geoShapeQuery(context, fieldName, relation, shape);
    }
}

