/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedNumericIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.docvalues.LongsBlockLoader;
import org.elasticsearch.index.query.DateRangeIncludingNowQuery;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.DateFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.SortedNumericDocValuesLongFieldScript;
import org.elasticsearch.script.field.DateMillisDocValuesField;
import org.elasticsearch.script.field.DateNanosDocValuesField;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.runtime.LongScriptFieldDistanceFeatureQuery;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class DateFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(DateFieldMapper.class);
    private static final Logger logger = LogManager.getLogger(DateFieldMapper.class);
    public static final String CONTENT_TYPE = "date";
    public static final String DATE_NANOS_CONTENT_TYPE = "date_nanos";
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time||epoch_millis").withLocale(DEFAULT_LOCALE);
    public static final DateFormatter DEFAULT_DATE_TIME_NANOS_FORMATTER = DateFormatter.forPattern("strict_date_optional_time_nanos||epoch_millis").withLocale(DEFAULT_LOCALE);
    private static final DateMathParser EPOCH_MILLIS_PARSER = DateFormatter.forPattern("epoch_millis").withLocale(DEFAULT_LOCALE).toDateMathParser();
    public static final NodeFeature INVALID_DATE_FIX = new NodeFeature("mapper.range.invalid_date_fix");
    public static final FieldMapper.TypeParser MILLIS_PARSER = DateFieldMapper.createTypeParserWithLegacySupport((n, c) -> new Builder((String)n, Resolution.MILLISECONDS, c.getDateFormatter(), c.scriptCompiler(), c.getIndexSettings()));
    public static final FieldMapper.TypeParser NANOS_PARSER = DateFieldMapper.createTypeParserWithLegacySupport((n, c) -> new Builder((String)n, Resolution.NANOSECONDS, c.getDateFormatter(), c.scriptCompiler(), c.getIndexSettings()));
    private final boolean store;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final Locale locale;
    private final String format;
    private final boolean ignoreMalformed;
    private final Long nullValue;
    private final String nullValueAsString;
    private final Resolution resolution;
    private final boolean isSourceSynthetic;
    private final Script script;
    private final ScriptCompiler scriptCompiler;
    private final FieldValues<Long> scriptValues;
    private final boolean isDataStreamTimestampField;
    private final IndexSettings indexSettings;

    private static DateFieldMapper toType(FieldMapper in) {
        return (DateFieldMapper)in;
    }

    private DateFieldMapper(String leafName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Long nullValue, Resolution resolution, boolean isSourceSynthetic, Builder builder) {
        super(leafName, mappedFieldType, builderParams);
        this.store = builder.store.getValue();
        this.indexed = builder.index.getValue();
        this.hasDocValues = builder.docValues.getValue();
        this.locale = builder.locale.getValue();
        this.format = builder.format.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.nullValueAsString = builder.nullValue.getValue();
        this.nullValue = nullValue;
        this.resolution = resolution;
        this.isSourceSynthetic = isSourceSynthetic;
        this.script = builder.script.get();
        this.scriptCompiler = builder.scriptCompiler;
        this.scriptValues = builder.scriptValues();
        this.isDataStreamTimestampField = mappedFieldType.name().equals("@timestamp");
        this.indexSettings = builder.indexSettings;
    }

    private static boolean shouldUseDocValuesSkipper(IndexSettings indexSettings, boolean hasDocValues, String fullFieldName) {
        return indexSettings.useDocValuesSkipper() && hasDocValues && (IndexMode.LOGSDB.equals((Object)indexSettings.getMode()) || IndexMode.TIME_SERIES.equals((Object)indexSettings.getMode())) && indexSettings.getIndexSortConfig() != null && indexSettings.getIndexSortConfig().hasSortOnField(fullFieldName) && "@timestamp".equals(fullFieldName);
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.resolution, null, this.scriptCompiler, this.indexSettings).init(this);
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().resolution.type();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        long timestamp;
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return;
            }
            timestamp = this.nullValue;
        } else if (this.isEpochMillis(context)) {
            timestamp = this.resolution.convert(context.parser().longValue());
        } else {
            try {
                timestamp = this.fieldType().parse(context.parser().text());
            }
            catch (ArithmeticException | IllegalArgumentException | DateTimeException | ElasticsearchParseException e) {
                if (this.ignoreMalformed) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    if (this.isSourceSynthetic) {
                        context.doc().add(IgnoreMalformedStoredValues.storedField(this.fullPath(), context.parser()));
                    }
                    return;
                }
                throw e;
            }
        }
        this.indexValue(context, timestamp);
    }

    private boolean isEpochMillis(DocumentParserContext context) throws IOException {
        DateFormatter dateFormatter = this.fieldType().dateTimeFormatter();
        return context.parser().currentToken() == XContentParser.Token.VALUE_NUMBER && context.parser().numberType() == XContentParser.NumberType.LONG && (dateFormatter.equals(DEFAULT_DATE_TIME_FORMATTER) || dateFormatter.equals(DEFAULT_DATE_TIME_NANOS_FORMATTER) || dateFormatter.equals(EPOCH_MILLIS_PARSER));
    }

    private void indexValue(DocumentParserContext context, long timestamp) {
        if (this.isDataStreamTimestampField && context.mappingLookup().isDataStreamTimestampFieldEnabled()) {
            DataStreamTimestampFieldMapper.storeTimestampValueForReuse(context.doc(), timestamp);
        }
        if (this.fieldType().hasDocValuesSkipper()) {
            context.doc().add(SortedNumericDocValuesField.indexedField(this.fieldType().name(), timestamp));
        } else if (this.indexed && this.hasDocValues) {
            context.doc().add(new LongField(this.fieldType().name(), timestamp, Field.Store.NO));
        } else if (this.hasDocValues) {
            context.doc().add(new SortedNumericDocValuesField(this.fieldType().name(), timestamp));
        } else if (this.indexed) {
            context.doc().add(new LongPoint(this.fieldType().name(), timestamp));
        }
        if (this.store) {
            context.doc().add(new StoredField(this.fieldType().name(), timestamp));
        }
        if (!this.hasDocValues && (this.indexed || this.store)) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, v -> this.indexValue(documentParserContext, (long)v));
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public Long getNullValue() {
        return this.nullValue;
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasDocValues) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new SortedNumericDocValuesSyntheticFieldLoader(this.fullPath(), this.leafName(), this.ignoreMalformed){

                @Override
                protected void writeValue(XContentBuilder b, long value) throws IOException {
                    b.value(DateFieldMapper.this.fieldType().format(value, DateFieldMapper.this.fieldType().dateTimeFormatter()));
                }
            });
        }
        return super.syntheticSourceSupport();
    }

    public static final class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> DateFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> DateFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> DateFieldMapper.toType((FieldMapper)m).store, false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<String> format;
        private final FieldMapper.Parameter<Locale> locale = new FieldMapper.Parameter<Locale>("locale", false, () -> DEFAULT_LOCALE, (n, c, o) -> LocaleUtils.parse(o.toString()), m -> DateFieldMapper.toType((FieldMapper)m).locale, (xContentBuilder, n, v) -> xContentBuilder.field(n, v.toString()), Objects::toString);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> DateFieldMapper.toType((FieldMapper)m).nullValueAsString, null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> ignoreMalformed;
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> DateFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptErrorParam = FieldMapper.Parameter.onScriptErrorParam(m -> DateFieldMapper.toType((FieldMapper)m).builderParams.onScriptError(), this.script);
        private final Resolution resolution;
        private final IndexVersion indexCreatedVersion;
        private final ScriptCompiler scriptCompiler;
        private final IndexSettings indexSettings;

        public Builder(String name, Resolution resolution, DateFormatter dateFormatter, ScriptCompiler scriptCompiler, IndexSettings indexSettings) {
            super(name);
            this.resolution = resolution;
            this.indexCreatedVersion = indexSettings.getIndexVersionCreated();
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.ignoreMalformed = FieldMapper.Parameter.boolParam("ignore_malformed", true, m -> DateFieldMapper.toType((FieldMapper)m).ignoreMalformed, FieldMapper.IGNORE_MALFORMED_SETTING.get(indexSettings.getSettings()));
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed);
            this.addScriptValidation(this.script, this.index, this.docValues);
            DateFormatter defaultFormat = resolution == Resolution.MILLISECONDS ? DEFAULT_DATE_TIME_FORMATTER : DEFAULT_DATE_TIME_NANOS_FORMATTER;
            this.format = FieldMapper.Parameter.stringParam("format", this.indexCreatedVersion.isLegacyIndexVersion(), m -> DateFieldMapper.toType((FieldMapper)m).format, defaultFormat.pattern());
            if (dateFormatter != null) {
                this.format.setValue(dateFormatter.pattern());
                this.locale.setValue(dateFormatter.locale());
            }
            this.indexSettings = indexSettings;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed.setValue(ignoreMalformed);
            return this;
        }

        DateFormatter buildFormatter() {
            try {
                return DateFormatter.forPattern(this.format.getValue(), this.indexCreatedVersion).withLocale(this.locale.getValue());
            }
            catch (IllegalArgumentException e) {
                if (this.indexCreatedVersion.isLegacyIndexVersion()) {
                    logger.warn(() -> "Error parsing format [" + this.format.getValue() + "] of legacy index, falling back to default", (Throwable)e);
                    return DateFormatter.forPattern(this.format.getDefaultValue()).withLocale(this.locale.getValue());
                }
                throw new IllegalArgumentException("Error parsing [format] on field [" + this.leafName() + "]: " + e.getMessage(), e);
            }
        }

        private FieldValues<Long> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            DateFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), DateFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.leafName(), this.script.get().getParams(), lookup, this.buildFormatter(), OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer::accept);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.index, this.docValues, this.store, this.format, this.locale, this.nullValue, this.ignoreMalformed, this.script, this.onScriptErrorParam, this.meta};
        }

        private Long parseNullValue(DateFieldType fieldType) {
            if (this.nullValue.getValue() == null) {
                return null;
            }
            try {
                return fieldType.parse(this.nullValue.getValue());
            }
            catch (Exception e) {
                if (this.indexCreatedVersion.onOrAfter(IndexVersions.V_8_0_0)) {
                    throw new MapperParsingException("Error parsing [null_value] on field [" + this.leafName() + "]: " + e.getMessage(), e);
                }
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "date_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as date in [null_value] on field [" + this.leafName() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        private IndexType indexType(String fullFieldName) {
            if (DateFieldMapper.shouldUseDocValuesSkipper(this.indexSettings, this.docValues.getValue(), fullFieldName)) {
                return IndexType.skippers();
            }
            if (!this.index.get().booleanValue() && this.docValues.get().booleanValue() && this.indexSettings.useDocValuesSkipper() && this.indexSettings.getIndexVersionCreated().onOrAfter(IndexVersions.STANDARD_INDEXES_USE_SKIPPERS)) {
                return IndexType.skippers();
            }
            if (this.indexCreatedVersion.isLegacyIndexVersion()) {
                return IndexType.archivedPoints();
            }
            return IndexType.points(this.index.get(), this.docValues.get());
        }

        @Override
        public DateFieldMapper build(MapperBuilderContext context) {
            String fullFieldName = context.buildFullName(this.leafName());
            IndexType indexType = this.indexType(fullFieldName);
            DateFieldType ft = new DateFieldType(fullFieldName, indexType, this.store.getValue(), context.isSourceSynthetic(), this.buildFormatter(), this.resolution, this.nullValue.getValue(), this.scriptValues(), this.meta.getValue());
            Long nullTimestamp = this.parseNullValue(ft);
            if (ft.name().equals("@timestamp") && context.isDataStream() && !this.ignoreMalformed.isConfigured()) {
                this.ignoreMalformed.setValue(false);
            }
            this.hasScript = this.script.get() != null;
            this.onScriptError = this.onScriptErrorParam.get();
            return new DateFieldMapper(this.leafName(), ft, this.builderParams(this, context), nullTimestamp, this.resolution, context.isSourceSynthetic(), this);
        }
    }

    public static enum Resolution {
        MILLISECONDS("date", IndexNumericFieldData.NumericType.DATE, DateMillisDocValuesField::new){

            @Override
            public long convert(Instant instant) {
                return DateUtils.toLongMillis(instant);
            }

            @Override
            public long convert(TimeValue timeValue) {
                return timeValue.millis();
            }

            @Override
            public long convert(long epochMillis) {
                return epochMillis;
            }

            @Override
            public Instant toInstant(long value) {
                return Instant.ofEpochMilli(value);
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return LongPoint.decodeDimension(value, 0);
            }

            @Override
            public long roundDownToMillis(long value) {
                return value;
            }

            @Override
            public long roundUpToMillis(long value) {
                return value;
            }
        }
        ,
        NANOSECONDS("date_nanos", IndexNumericFieldData.NumericType.DATE_NANOSECONDS, DateNanosDocValuesField::new){

            @Override
            public long convert(Instant instant) {
                return DateUtils.toLong(instant);
            }

            @Override
            public long convert(TimeValue timeValue) {
                return timeValue.nanos();
            }

            @Override
            public long convert(long epochMillis) {
                return TimeUnit.MILLISECONDS.toNanos(epochMillis);
            }

            @Override
            public Instant toInstant(long value) {
                return DateUtils.toInstant(value);
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return this.roundDownToMillis(LongPoint.decodeDimension(value, 0));
            }

            @Override
            public long roundDownToMillis(long value) {
                return DateUtils.toMilliSeconds(value);
            }

            @Override
            public long roundUpToMillis(long value) {
                if (value <= 0L) {
                    return DateUtils.toMilliSeconds(value);
                }
                return DateUtils.toMilliSeconds(value - 1L) + 1L;
            }
        };

        private final String type;
        private final IndexNumericFieldData.NumericType numericType;
        private final ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory;

        private Resolution(String type, IndexNumericFieldData.NumericType numericType, ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory) {
            this.type = type;
            this.numericType = numericType;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public String type() {
            return this.type;
        }

        IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        ToScriptFieldFactory<SortedNumericLongValues> getDefaultToScriptFieldFactory() {
            return this.toScriptFieldFactory;
        }

        public abstract long convert(Instant var1);

        public abstract Instant toInstant(long var1);

        public abstract long convert(TimeValue var1);

        public abstract long convert(long var1);

        public abstract long parsePointAsMillis(byte[] var1);

        public abstract long roundDownToMillis(long var1);

        public abstract long roundUpToMillis(long var1);

        public static Resolution ofOrdinal(int ord) {
            for (Resolution resolution : Resolution.values()) {
                if (ord != resolution.ordinal()) continue;
                return resolution;
            }
            throw new IllegalArgumentException("unknown resolution ordinal [" + ord + "]");
        }
    }

    public static final class DateFieldType
    extends MappedFieldType {
        final DateFormatter dateTimeFormatter;
        final DateMathParser dateMathParser;
        private final Resolution resolution;
        private final String nullValue;
        private final FieldValues<Long> scriptValues;
        private final boolean isSyntheticSource;
        private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.ROOT);

        public DateFieldType(String name, IndexType indexType, boolean isStored, boolean isSyntheticSource, DateFormatter dateTimeFormatter, Resolution resolution, String nullValue, FieldValues<Long> scriptValues, Map<String, String> meta) {
            super(name, indexType, isStored, meta);
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = dateTimeFormatter.toDateMathParser();
            this.resolution = resolution;
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
            this.isSyntheticSource = isSyntheticSource;
        }

        public DateFieldType(String name, IndexType indexType, boolean isStored, DateFormatter dateTimeFormatter, Resolution resolution, String nullValue, FieldValues<Long> scriptValues, Map<String, String> meta) {
            this(name, indexType, isStored, false, dateTimeFormatter, resolution, nullValue, scriptValues, meta);
        }

        public DateFieldType(String name) {
            this(name, IndexType.points(true, true), false, DEFAULT_DATE_TIME_FORMATTER, Resolution.MILLISECONDS, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, boolean isIndexed, Resolution resolution) {
            this(name, IndexType.points(isIndexed, true), false, DEFAULT_DATE_TIME_FORMATTER, resolution, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, boolean isIndexed) {
            this(name, isIndexed, Resolution.MILLISECONDS);
        }

        public DateFieldType(String name, DateFormatter dateFormatter) {
            this(name, IndexType.points(true, true), false, dateFormatter, Resolution.MILLISECONDS, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, Resolution resolution) {
            this(name, IndexType.points(true, true), false, DEFAULT_DATE_TIME_FORMATTER, resolution, null, null, Collections.emptyMap());
        }

        public DateFieldType(String name, Resolution resolution, DateFormatter dateFormatter) {
            this(name, IndexType.points(true, true), false, dateFormatter, resolution, null, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.resolution.type();
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public Resolution resolution() {
            return this.resolution;
        }

        public DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        public long parse(String value) {
            return this.resolution.convert(DateFormatters.from(this.dateTimeFormatter().parse(value), this.dateTimeFormatter().locale()).toInstant());
        }

        public boolean hasDocValuesSkipper() {
            return this.indexType.hasDocValuesSkipper();
        }

        @Override
        public TextSearchInfo getTextSearchInfo() {
            return TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS;
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            DateFormatter formatter;
            DateFormatter defaultFormatter = this.dateTimeFormatter();
            DateFormatter dateFormatter = formatter = format != null ? DateFormatter.forPattern(format).withLocale(defaultFormatter.locale()) : defaultFormatter;
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, v -> this.format((Long)v, formatter), context);
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                public String parseSourceValue(Object value) {
                    String date = value instanceof Number ? NUMBER_FORMAT.format(value) : value.toString();
                    return this.format(this.parse(date), formatter);
                }
            };
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths, IndexSettings indexSettings) {
            return new SourceValueFetcher(sourcePaths, this.nullValue, indexSettings.getIgnoredSourceFormat()){

                @Override
                public Long parseSourceValue(Object value) {
                    String date = value instanceof Number ? NUMBER_FORMAT.format(value) : value.toString();
                    return this.parse(date);
                }
            };
        }

        private String format(long timestamp, DateFormatter formatter) {
            ZonedDateTime dateTime = this.resolution().toInstant(timestamp).atZone(ZoneOffset.UTC);
            return formatter.format(dateTime);
        }

        @Override
        public boolean isSearchable() {
            return this.indexType.hasPoints() || this.hasDocValues();
        }

        @Override
        public Query termQuery(Object value, @Nullable SearchExecutionContext context) {
            return this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser forcedDateParser, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (relation == ShapeRelation.DISJOINT) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support DISJOINT ranges");
            }
            DateMathParser parser = this.resolveDateMathParser(forcedDateParser, lowerTerm, upperTerm);
            return DateFieldType.dateRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context, this.resolution, this.name(), (l, u) -> {
                Query query;
                if (this.indexType.hasPoints()) {
                    query = LongPoint.newRangeQuery(this.name(), l, u);
                    if (this.hasDocValues()) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(this.name(), l, u);
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                } else {
                    query = SortedNumericDocValuesField.newSlowRangeQuery(this.name(), l, u);
                }
                if (this.hasDocValues() && context.indexSortedOnField(this.name())) {
                    query = new IndexSortSortedNumericDocValuesRangeQuery(this.name(), (long)l, (long)u, query);
                }
                return query;
            });
        }

        public static Query dateRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable ZoneId timeZone, DateMathParser parser, SearchExecutionContext context, Resolution resolution, String fieldName, BiFunction<Long, Long, Query> builder) {
            return DateFieldType.handleNow(context, nowSupplier -> {
                long u;
                long l;
                if (lowerTerm == null) {
                    l = Long.MIN_VALUE;
                } else {
                    l = DateFieldType.parseToLong(lowerTerm, !includeLower, timeZone, parser, nowSupplier, resolution);
                    if (!includeLower) {
                        ++l;
                    }
                    context.setTimeRangeFilterFromMillis(fieldName, l, resolution);
                }
                if (upperTerm == null) {
                    u = Long.MAX_VALUE;
                } else {
                    u = DateFieldType.parseToLong(upperTerm, includeUpper, timeZone, parser, nowSupplier, resolution);
                    if (!includeUpper) {
                        --u;
                    }
                }
                return (Query)builder.apply(l, u);
            });
        }

        public static Query handleNow(SearchExecutionContext context, Function<LongSupplier, Query> builder) {
            boolean[] nowUsed = new boolean[1];
            LongSupplier nowSupplier = () -> {
                nowUsed[0] = true;
                return context.nowInMillis();
            };
            Query query = builder.apply(nowSupplier);
            return nowUsed[0] ? new DateRangeIncludingNowQuery(query) : query;
        }

        public long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now) {
            dateParser = dateParser == null ? this.dateMathParser() : dateParser;
            return DateFieldType.parseToLong(value, roundUp, zone, dateParser, now, this.resolution);
        }

        public static long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now, Resolution resolution) {
            return resolution.convert(dateParser.parse(BytesRefs.toString(value), now, roundUp, zone));
        }

        public Query equalityQuery(Long value, @Nullable SearchExecutionContext context) {
            return this.rangeQuery(value, value, true, true, context);
        }

        public Query rangeQuery(Long lowerTerm, Long upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            Query query;
            long u;
            long l;
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (lowerTerm == null) {
                l = Long.MIN_VALUE;
            } else {
                long l2 = l = !includeLower ? lowerTerm + 1L : lowerTerm;
            }
            if (upperTerm == null) {
                u = Long.MAX_VALUE;
            } else {
                long l3 = u = !includeUpper ? upperTerm - 1L : upperTerm;
            }
            if (this.indexType.hasPoints()) {
                query = LongPoint.newRangeQuery(this.name(), l, u);
                if (this.hasDocValues()) {
                    Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(this.name(), l, u);
                    query = new IndexOrDocValuesQuery(query, dvQuery);
                }
            } else {
                query = SortedNumericDocValuesField.newSlowRangeQuery(this.name(), l, u);
            }
            if (this.hasDocValues() && context.indexSortedOnField(this.name())) {
                query = new IndexSortSortedNumericDocValuesRangeQuery(this.name(), l, u, query);
            }
            return query;
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            long originLong = this.parseToLong(origin, true, null, null, context::nowInMillis);
            TimeValue pivotTime = TimeValue.parseTimeValue(pivot, "distance_feature.pivot");
            long pivotLong = this.resolution.convert(pivotTime);
            if (this.indexType.hasPoints()) {
                return LongField.newDistanceFeatureQuery(this.name(), 1.0f, originLong, pivotLong);
            }
            return new LongScriptFieldDistanceFeatureQuery(new Script(""), ctx -> new SortedNumericDocValuesLongFieldScript(this.name(), context.lookup(), (LeafReaderContext)ctx), this.name(), originLong, pivotLong);
        }

        @Override
        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (!this.indexType.hasPointsMetadata() && this.hasDocValues()) {
                if (!this.indexType.hasDocValuesSkipper()) {
                    return MappedFieldType.Relation.INTERSECTS;
                }
                long minValue = Long.MAX_VALUE;
                long maxValue = Long.MIN_VALUE;
                List<LeafReaderContext> leaves = reader.leaves();
                if (leaves.size() == 0) {
                    return MappedFieldType.Relation.DISJOINT;
                }
                for (LeafReaderContext ctx : leaves) {
                    DocValuesSkipper skipper = ctx.reader().getDocValuesSkipper(this.name());
                    if (skipper == null) continue;
                    minValue = Long.min(minValue, skipper.minValue());
                    maxValue = Long.max(maxValue, skipper.maxValue());
                }
                return this.isFieldWithinQuery(minValue, maxValue, from, to, includeLower, includeUpper, timeZone, dateParser, context, this.name());
            }
            byte[] minPackedValue = PointValues.getMinPackedValue(reader, this.name());
            if (minPackedValue == null) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minValue = LongPoint.decodeDimension(minPackedValue, 0);
            long maxValue = LongPoint.decodeDimension(PointValues.getMaxPackedValue(reader, this.name()), 0);
            return this.isFieldWithinQuery(minValue, maxValue, from, to, includeLower, includeUpper, timeZone, dateParser, context, this.name());
        }

        public DateMathParser resolveDateMathParser(DateMathParser dateParser, Object from, Object to) {
            if (dateParser == null) {
                if (from instanceof Number || to instanceof Number) {
                    return EPOCH_MILLIS_PARSER;
                }
                return this.dateMathParser;
            }
            return dateParser;
        }

        public MappedFieldType.Relation isFieldWithinQuery(long minValue, long maxValue, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context, String fieldName) {
            dateParser = this.resolveDateMathParser(dateParser, from, to);
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = DateFieldType.parseToLong(from, !includeLower, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
                context.setTimeRangeFilterFromMillis(fieldName, fromInclusive, this.resolution);
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = DateFieldType.parseToLong(to, includeUpper, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return MappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return MappedFieldType.Relation.DISJOINT;
            }
            return MappedFieldType.Relation.INTERSECTS;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.indexType.hasPoints()) {
                return this.resolution()::parsePointAsMillis;
            }
            return null;
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues()) {
                return new LongsBlockLoader(this.name());
            }
            if (this.isSyntheticSource && blContext.parentField(this.name()) == null) {
                return new FallbackSyntheticSourceBlockLoader(this, this.fallbackSyntheticSourceBlockLoaderReader(), this.name(), IgnoredSourceFieldMapper.ignoredSourceFormat(blContext.indexSettings().getIndexVersionCreated())){

                    @Override
                    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                        return factory.longs(expectedCount);
                    }
                };
            }
            BlockSourceReader.LeafIteratorLookup lookup = this.isStored() || this.indexType.hasPoints() ? BlockSourceReader.lookupFromFieldNames(blContext.fieldNames(), this.name()) : BlockSourceReader.lookupMatchingAll();
            return new BlockSourceReader.LongsBlockLoader(this.sourceValueFetcher(blContext.sourcePaths(this.name()), blContext.indexSettings()), lookup);
        }

        private FallbackSyntheticSourceBlockLoader.Reader<?> fallbackSyntheticSourceBlockLoaderReader() {
            final Function<String, Long> dateParser = this::parse;
            return new FallbackSyntheticSourceBlockLoader.SingleValueReader<Long>((Object)this.nullValue){

                @Override
                public void convertValue(Object value, List<Long> accumulator) {
                    try {
                        String date = value instanceof Number ? NUMBER_FORMAT.format(value) : value.toString();
                        accumulator.add((Long)dateParser.apply(date));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                protected void parseNonNullValue(XContentParser parser, List<Long> accumulator) throws IOException {
                    try {
                        String dateAsString = parser.textOrNull();
                        if (dateAsString == null) {
                            accumulator.add((Long)dateParser.apply(nullValue));
                        } else {
                            accumulator.add((Long)dateParser.apply(dateAsString));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void writeToBlock(List<Long> values, BlockLoader.Builder blockBuilder) {
                    BlockLoader.LongBuilder longBuilder = (BlockLoader.LongBuilder)blockBuilder;
                    for (Long value : values) {
                        longBuilder.appendLong(value);
                    }
                }
            };
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
            }
            if ((operation == MappedFieldType.FielddataOperation.SEARCH || operation == MappedFieldType.FielddataOperation.SCRIPT) && this.hasDocValues()) {
                return new SortedNumericIndexFieldData.Builder(this.name(), this.resolution.numericType(), this.resolution.getDefaultToScriptFieldFactory(), this.indexType);
            }
            if (operation == MappedFieldType.FielddataOperation.SCRIPT) {
                SearchLookup searchLookup = fieldDataContext.lookupSupplier().get();
                Set<String> sourcePaths = fieldDataContext.sourcePathsLookup().apply(this.name());
                return new SourceValueFetcherSortedNumericIndexFieldData.Builder(this.name(), this.resolution.numericType().getValuesSourceType(), (ValueFetcher)this.sourceValueFetcher(sourcePaths, fieldDataContext.indexSettings()), (SourceProvider)searchLookup, this.resolution.getDefaultToScriptFieldFactory());
            }
            throw new IllegalStateException("unknown field data operation [" + operation.name() + "]");
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().format(this.resolution.toInstant(val).atZone(ZoneOffset.UTC));
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            DateFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
            }
            if (timeZone == null) {
                timeZone = ZoneOffset.UTC;
            }
            return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, Resolution.MILLISECONDS);
        }

        static {
            NUMBER_FORMAT.setGroupingUsed(false);
            NUMBER_FORMAT.setMaximumFractionDigits(6);
        }
    }
}

