/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.fieldvisitor.FieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Uid;

public class FieldsVisitor
extends FieldNamesProvidingStoredFieldsVisitor {
    static final Set<String> BASE_REQUIRED_FIELDS = Set.of("_id", "_routing");
    private final boolean loadSource;
    final String sourceFieldName;
    private final Set<String> requiredFields;
    private BytesReference source;
    private String id;
    private final Map<String, List<Object>> fieldsValues = new HashMap<String, List<Object>>();

    public FieldsVisitor(boolean loadSource) {
        this(loadSource, "_source");
    }

    public FieldsVisitor(boolean loadSource, String sourceFieldName) {
        this.loadSource = loadSource;
        this.sourceFieldName = sourceFieldName;
        this.requiredFields = new HashSet<String>();
        this.reset();
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        Set<String> requiredFields = this.requiredFields;
        String name = fieldInfo.name;
        if (requiredFields.remove(name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if ("_ignored".equals(name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if (requiredFields.isEmpty()) {
            return StoredFieldVisitor.Status.STOP;
        }
        if ("_uid".equals(name) && (requiredFields.remove("_id") || requiredFields.remove("_type"))) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    @Override
    public Set<String> getFieldNames() {
        return this.requiredFields;
    }

    public final void postProcess(Function<String, MappedFieldType> fieldTypeLookup) {
        for (Map.Entry<String, List<Object>> entry : this.fields().entrySet()) {
            MappedFieldType fieldType = fieldTypeLookup.apply(entry.getKey());
            if (fieldType == null) continue;
            List<Object> fieldValues = entry.getValue();
            for (int i = 0; i < fieldValues.size(); ++i) {
                fieldValues.set(i, fieldType.valueForDisplay(fieldValues.get(i)));
            }
        }
    }

    @Override
    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        String name = fieldInfo.name;
        if (this.sourceFieldName.equals(name)) {
            this.source = new BytesArray(value);
        } else if ("_id".equals(name)) {
            this.id = Uid.decodeId(value, 0, value.length);
        } else {
            this.addValue(name, new BytesRef(value));
        }
    }

    @Override
    public void stringField(FieldInfo fieldInfo, String value) {
        String name = fieldInfo.name;
        assert (!this.sourceFieldName.equals(name)) : "source field must go through binaryField";
        if ("_uid".equals(name)) {
            int delimiterIndex = value.indexOf(35);
            String type = value.substring(0, delimiterIndex);
            this.id = value.substring(delimiterIndex + 1);
            this.addValue("_type", type);
        } else if ("_id".equals(name)) {
            this.id = value;
        } else {
            this.addValue(name, value);
        }
    }

    @Override
    public void intField(FieldInfo fieldInfo, int value) {
        this.addValue(fieldInfo.name, value);
    }

    @Override
    public void longField(FieldInfo fieldInfo, long value) {
        this.addValue(fieldInfo.name, value);
    }

    @Override
    public void floatField(FieldInfo fieldInfo, float value) {
        this.addValue(fieldInfo.name, Float.valueOf(value));
    }

    @Override
    public void doubleField(FieldInfo fieldInfo, double value) {
        this.addValue(fieldInfo.name, value);
    }

    public BytesReference source() {
        return this.source;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        List<Object> values = this.fieldsValues.get("_routing");
        if (values == null || values.isEmpty()) {
            return null;
        }
        assert (values.size() == 1);
        return values.getFirst().toString();
    }

    public Map<String, List<Object>> fields() {
        return this.fieldsValues;
    }

    public void reset() {
        this.fieldsValues.clear();
        this.source = null;
        this.id = null;
        this.requiredFields.addAll(BASE_REQUIRED_FIELDS);
        if (this.loadSource) {
            this.requiredFields.add(this.sourceFieldName);
        }
    }

    void addValue(String name, Object value) {
        this.fieldsValues.computeIfAbsent(name, k -> new ArrayList(2)).add(value);
    }
}

