/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.script.field.ToScriptFieldFactory;

public final class GlobalOrdinalsBuilder
extends Enum<GlobalOrdinalsBuilder> {
    private static final /* synthetic */ GlobalOrdinalsBuilder[] $VALUES;

    public static GlobalOrdinalsBuilder[] values() {
        return (GlobalOrdinalsBuilder[])$VALUES.clone();
    }

    public static GlobalOrdinalsBuilder valueOf(String name) {
        return Enum.valueOf(GlobalOrdinalsBuilder.class, name);
    }

    public static IndexOrdinalsFieldData build(IndexReader indexReader, IndexOrdinalsFieldData indexFieldData, final CircuitBreaker breaker, Logger logger, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTimeNS = System.nanoTime();
        LeafOrdinalsFieldData[] atomicFD = new LeafOrdinalsFieldData[indexReader.leaves().size()];
        SortedSetDocValues[] subs = new SortedSetDocValues[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = (LeafOrdinalsFieldData)indexFieldData.load(indexReader.leaves().get(i));
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        TermsEnum[] termsEnums = new TermsEnum[subs.length];
        long[] weights = new long[subs.length];
        final long[] counter = new long[1];
        for (int i = 0; i < subs.length; ++i) {
            termsEnums[i] = new FilterLeafReader.FilterTermsEnum(subs[i].termsEnum()){

                @Override
                public BytesRef next() throws IOException {
                    long l = counter[0];
                    counter[0] = l + 1L;
                    if ((l & 0xFFFFL) == 0L) {
                        breaker.addEstimateBytesAndMaybeBreak(0L, "Global Ordinals");
                    }
                    return this.in.next();
                }
            };
            weights[i] = subs[i].getValueCount();
        }
        OrdinalMap ordinalMap = OrdinalMap.build(null, termsEnums, weights, 0.25f);
        long memorySizeInBytes = ordinalMap.ramBytesUsed();
        breaker.addEstimateBytesAndMaybeBreak(memorySizeInBytes, "Global Ordinals");
        TimeValue took = new TimeValue(System.nanoTime() - startTimeNS, TimeUnit.NANOSECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug("global-ordinals [{}][{}] took [{}]", (Object)indexFieldData.getFieldName(), (Object)ordinalMap.getValueCount(), (Object)took);
        }
        return new GlobalOrdinalsIndexFieldData(indexFieldData.getFieldName(), indexFieldData.getValuesSourceType(), atomicFD, ordinalMap, memorySizeInBytes, toScriptFieldFactory, took);
    }

    public static IndexOrdinalsFieldData buildEmpty(IndexReader indexReader, IndexOrdinalsFieldData indexFieldData, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory) throws IOException {
        assert (indexReader.leaves().size() > 1);
        long startTimeNS = System.nanoTime();
        LeafOrdinalsFieldData[] atomicFD = new LeafOrdinalsFieldData[indexReader.leaves().size()];
        SortedSetDocValues[] subs = new SortedSetDocValues[indexReader.leaves().size()];
        for (int i = 0; i < indexReader.leaves().size(); ++i) {
            atomicFD[i] = new AbstractLeafOrdinalsFieldData((ToScriptFieldFactory)toScriptFieldFactory){

                @Override
                public SortedSetDocValues getOrdinalsValues() {
                    return DocValues.emptySortedSet();
                }

                @Override
                public long ramBytesUsed() {
                    return 0L;
                }
            };
            subs[i] = atomicFD[i].getOrdinalsValues();
        }
        OrdinalMap ordinalMap = OrdinalMap.build(null, subs, 0.25f);
        TimeValue took = new TimeValue(System.nanoTime() - startTimeNS, TimeUnit.NANOSECONDS);
        return new GlobalOrdinalsIndexFieldData(indexFieldData.getFieldName(), indexFieldData.getValuesSourceType(), atomicFD, ordinalMap, 0L, toScriptFieldFactory, took);
    }

    private static /* synthetic */ GlobalOrdinalsBuilder[] $values() {
        return new GlobalOrdinalsBuilder[0];
    }

    static {
        $VALUES = GlobalOrdinalsBuilder.$values();
    }
}

