/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;

final class SortableLongBitsToSortedNumericDoubleValues
extends SortedNumericDoubleValues {
    private final SortedNumericLongValues values;

    SortableLongBitsToSortedNumericDoubleValues(SortedNumericLongValues values) {
        this.values = values;
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        return this.values.advanceExact(target);
    }

    @Override
    public double nextValue() throws IOException {
        return NumericUtils.sortableLongToDouble(this.values.nextValue());
    }

    @Override
    public int docValueCount() {
        return this.values.docValueCount();
    }

    public SortedNumericLongValues getLongValues() {
        return this.values;
    }
}

