/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.HalfFloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.IntValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public abstract class IndexNumericFieldData
implements IndexFieldData<LeafNumericFieldData> {
    public abstract NumericType getNumericType();

    public final SortField sortField(boolean indexSort, NumericType targetNumericType, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        boolean requiresCustomComparator;
        IndexFieldData.XFieldComparatorSource source = this.comparatorSource(targetNumericType, missingValue, sortMode, nested);
        boolean bl = requiresCustomComparator = nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || targetNumericType != this.getNumericType();
        if (!indexSort || this.sortRequiresCustomComparator()) {
            SortField sortField = new SortField(this.getFieldName(), source, reverse);
            sortField.setOptimizeSortWithPoints(!requiresCustomComparator && IndexNumericFieldData.canUseOptimizedSort(this.indexType()));
            return sortField;
        }
        SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
        SortedNumericSortField sortField = new SortedNumericSortField(this.getFieldName(), this.getNumericType().sortFieldType, reverse, selectorType);
        ((SortField)sortField).setMissingValue(source.missingObject(missingValue, reverse));
        sortField.setOptimizeSortWithPoints(IndexNumericFieldData.canUseOptimizedSort(this.indexType()));
        return sortField;
    }

    private static boolean canUseOptimizedSort(IndexType indexType) {
        return indexType.hasPoints() || indexType.hasDocValuesSkipper();
    }

    protected abstract boolean sortRequiresCustomComparator();

    protected abstract IndexType indexType();

    @Override
    public final SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        return this.sortField(false, this.getNumericType(), missingValue, sortMode, nested, reverse);
    }

    @Override
    public SortField indexSort(IndexVersion indexCreatedVersion, Object missingValue, MultiValueMode sortMode, boolean reverse) {
        return this.sortField(true, indexCreatedVersion, missingValue, sortMode, null, reverse);
    }

    @Override
    public SortField sortField(boolean indexSort, IndexVersion indexCreatedVersion, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        SortField sortField = this.sortField(indexSort, this.getNumericType(), missingValue, sortMode, nested, reverse);
        if (this.getNumericType() == NumericType.DATE_NANOSECONDS && indexCreatedVersion.before(IndexVersions.V_7_14_0) && missingValue.equals("_last") && Long.valueOf(0L).equals(sortField.getMissingValue())) {
            sortField.setMissingValue(Long.MIN_VALUE);
            return sortField;
        }
        if (this.getNumericType().sortFieldType != SortField.Type.INT || indexCreatedVersion.onOrAfter(IndexVersions.INDEX_INT_SORT_INT_TYPE) || indexCreatedVersion.between(IndexVersions.INDEX_INT_SORT_INT_TYPE_8_19, IndexVersions.UPGRADE_TO_LUCENE_10_0_0)) {
            return sortField;
        }
        IndexFieldData.XFieldComparatorSource longSource = this.comparatorSource(NumericType.LONG, missingValue, sortMode, nested);
        if (sortField instanceof SortedNumericSortField) {
            SortedNumericSortField snsf = (SortedNumericSortField)sortField;
            SortedNumericSortField rewrittenSortField = new SortedNumericSortField(snsf.getField(), SortField.Type.LONG, snsf.getReverse(), snsf.getSelector());
            rewrittenSortField.setMissingValue(longSource.missingObject(missingValue, reverse));
            rewrittenSortField.setOptimizeSortWithPoints(false);
            return rewrittenSortField;
        }
        SortedNumericSortField rewrittenSortField = new SortedNumericSortField(sortField.getField(), SortField.Type.LONG, reverse);
        ((SortField)rewrittenSortField).setMissingValue(longSource.missingObject(missingValue, reverse));
        rewrittenSortField.setOptimizeSortWithPoints(false);
        return rewrittenSortField;
    }

    public final BucketedSort newBucketedSort(NumericType targetNumericType, BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.comparatorSource(targetNumericType, missingValue, sortMode, nested).newBucketedSort(bigArrays, sortOrder, format, bucketSize, extra);
    }

    @Override
    public final BucketedSort newBucketedSort(BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.newBucketedSort(this.getNumericType(), bigArrays, missingValue, sortMode, nested, sortOrder, format, bucketSize, extra);
    }

    private IndexFieldData.XFieldComparatorSource comparatorSource(NumericType targetNumericType, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return switch (targetNumericType.ordinal()) {
            case 8 -> new FloatValuesComparatorSource(this, missingValue, sortMode, nested);
            case 7 -> new HalfFloatValuesComparatorSource(this, missingValue, sortMode, nested);
            case 9 -> new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
            case 1, 2, 3 -> new IntValuesComparatorSource(this, missingValue, sortMode, nested, targetNumericType);
            case 5 -> this.dateComparatorSource(missingValue, sortMode, nested);
            case 6 -> this.dateNanosComparatorSource(missingValue, sortMode, nested);
            default -> {
                if (!$assertionsDisabled && targetNumericType.isFloatingPoint()) {
                    throw new AssertionError();
                }
                yield new LongValuesComparatorSource(this, missingValue, sortMode, nested, targetNumericType);
            }
        };
    }

    protected IndexFieldData.XFieldComparatorSource dateComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, NumericType.DATE);
    }

    protected IndexFieldData.XFieldComparatorSource dateNanosComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> IndexNumericFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds), NumericType.DATE_NANOSECONDS);
    }

    protected static SortedNumericLongValues convertNumeric(final SortedNumericLongValues values, final LongUnaryOperator converter) {
        return new SortedNumericLongValues(){

            @Override
            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            @Override
            public long nextValue() throws IOException {
                return converter.applyAsLong(values.nextValue());
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }
        };
    }

    public static enum NumericType {
        BOOLEAN(false, SortField.Type.LONG, CoreValuesSourceType.BOOLEAN),
        BYTE(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        SHORT(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        INT(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        LONG(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        DATE(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        DATE_NANOSECONDS(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        HALF_FLOAT(true, SortField.Type.FLOAT, CoreValuesSourceType.NUMERIC),
        FLOAT(true, SortField.Type.FLOAT, CoreValuesSourceType.NUMERIC),
        DOUBLE(true, SortField.Type.DOUBLE, CoreValuesSourceType.NUMERIC);

        private final boolean floatingPoint;
        private final ValuesSourceType valuesSourceType;
        private final SortField.Type sortFieldType;

        private NumericType(boolean floatingPoint, SortField.Type sortFieldType, ValuesSourceType valuesSourceType) {
            this.floatingPoint = floatingPoint;
            this.sortFieldType = sortFieldType;
            this.valuesSourceType = valuesSourceType;
        }

        public final boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public final ValuesSourceType getValuesSourceType() {
            return this.valuesSourceType;
        }
    }
}

