/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.script.GeoPointFieldScript;

public final class GeoPointScriptDocValues
extends SortedNumericLongValues {
    private final GeoPointFieldScript script;
    private int cursor;

    GeoPointScriptDocValues(GeoPointFieldScript script) {
        this.script = script;
    }

    @Override
    public boolean advanceExact(int docId) {
        this.script.runForDoc(docId);
        if (this.script.count() == 0) {
            return false;
        }
        new IntroSorter(){
            private int pivot;

            @Override
            protected void setPivot(int i) {
                this.pivot = i;
            }

            @Override
            protected void swap(int i, int j) {
                double tmp = GeoPointScriptDocValues.this.script.lats()[i];
                GeoPointScriptDocValues.this.script.lats()[i] = GeoPointScriptDocValues.this.script.lats()[j];
                GeoPointScriptDocValues.this.script.lats()[j] = tmp;
                tmp = GeoPointScriptDocValues.this.script.lons()[i];
                GeoPointScriptDocValues.this.script.lons()[i] = GeoPointScriptDocValues.this.script.lons()[j];
                GeoPointScriptDocValues.this.script.lons()[j] = tmp;
            }

            @Override
            protected int comparePivot(int j) {
                int cmp = Double.compare(GeoPointScriptDocValues.this.script.lats()[this.pivot], GeoPointScriptDocValues.this.script.lats()[j]);
                if (cmp != 0) {
                    return cmp;
                }
                return Double.compare(GeoPointScriptDocValues.this.script.lons()[this.pivot], GeoPointScriptDocValues.this.script.lons()[j]);
            }
        }.sort(0, this.script.count());
        this.cursor = 0;
        return true;
    }

    @Override
    public int docValueCount() {
        return this.script.count();
    }

    @Override
    public long nextValue() {
        int lat = GeoEncodingUtils.encodeLatitude(this.script.lats()[this.cursor]);
        int lon = GeoEncodingUtils.encodeLongitude(this.script.lons()[this.cursor++]);
        return (long)lat << 32 | (long)lon & 0xFFFFFFFFL;
    }
}

