/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.index.fielddata.AbstractBinaryDocValues;
import org.elasticsearch.index.fielddata.DenseDoubleValues;
import org.elasticsearch.index.fielddata.DenseLongValues;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.MultiPointValues;
import org.elasticsearch.index.fielddata.SingletonSortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SingletonSortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortableLongBitsNumericDocValues;
import org.elasticsearch.index.fielddata.SortableLongBitsSortedNumericDocValues;
import org.elasticsearch.index.fielddata.SortableLongBitsToNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortableLongBitsToSortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;

public final class FieldData
extends Enum<FieldData> {
    public static LongValues EMPTY;
    private static final /* synthetic */ FieldData[] $VALUES;

    public static FieldData[] values() {
        return (FieldData[])$VALUES.clone();
    }

    public static FieldData valueOf(String name) {
        return Enum.valueOf(FieldData.class, name);
    }

    public static SortedBinaryDocValues emptySortedBinary() {
        return FieldData.singleton(DocValues.emptyBinary());
    }

    public static SortedNumericDoubleValues emptySortedNumericDoubles() {
        return FieldData.singleton(DoubleValues.EMPTY);
    }

    public static DocValueBits docsWithValue(final SortedBinaryDocValues values) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedSetDocValues docValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final MultiPointValues<? extends SpatialPoint> pointValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return pointValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedNumericDoubleValues doubleValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doubleValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedNumericLongValues docValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    public static SortedNumericLongValues toSortableLongBits(SortedNumericDoubleValues values) {
        DoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            LongValues longBits = singleton instanceof SortableLongBitsToNumericDoubleValues ? ((SortableLongBitsToNumericDoubleValues)singleton).getLongValues() : new SortableLongBitsNumericDocValues(singleton);
            return SortedNumericLongValues.singleton(longBits);
        }
        if (values instanceof SortableLongBitsToSortedNumericDoubleValues) {
            return ((SortableLongBitsToSortedNumericDoubleValues)values).getLongValues();
        }
        return new SortableLongBitsSortedNumericDocValues(values);
    }

    public static SortedNumericDoubleValues sortableLongBitsToDoubles(SortedNumericLongValues values) {
        LongValues singleton = SortedNumericLongValues.unwrapSingleton(values);
        if (singleton != null) {
            DoubleValues doubles = singleton instanceof SortableLongBitsNumericDocValues ? ((SortableLongBitsNumericDocValues)singleton).getDoubleValues() : new SortableLongBitsToNumericDoubleValues(singleton);
            return FieldData.singleton(doubles);
        }
        if (values instanceof SortableLongBitsSortedNumericDocValues) {
            return ((SortableLongBitsSortedNumericDocValues)values).getDoubleValues();
        }
        return new SortableLongBitsToSortedNumericDoubleValues(values);
    }

    public static SortedNumericDoubleValues castToDouble(SortedNumericLongValues values) {
        LongValues singleton = SortedNumericLongValues.unwrapSingleton(values);
        if (singleton != null) {
            return FieldData.singleton(new DoubleCastedValues(singleton));
        }
        return new SortedDoubleCastedValues(values);
    }

    public static SortedNumericLongValues castToLong(SortedNumericDoubleValues values) {
        DoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return SortedNumericLongValues.singleton(new LongCastedValues(singleton));
        }
        return new SortedLongCastedValues(values);
    }

    public static SortedNumericDoubleValues singleton(DoubleValues values) {
        return new SingletonSortedNumericDoubleValues(values);
    }

    public static DoubleValues unwrapSingleton(SortedNumericDoubleValues values) {
        if (values instanceof SingletonSortedNumericDoubleValues) {
            return ((SingletonSortedNumericDoubleValues)values).getNumericDoubleValues();
        }
        return null;
    }

    public static GeoPointValues unwrapSingleton(MultiGeoPointValues values) {
        return values.getPointValues();
    }

    public static SortedBinaryDocValues singleton(BinaryDocValues values) {
        return new SingletonSortedBinaryDocValues(values);
    }

    public static BinaryDocValues unwrapSingleton(SortedBinaryDocValues values) {
        if (values instanceof SingletonSortedBinaryDocValues) {
            return ((SingletonSortedBinaryDocValues)values).getBinaryDocValues();
        }
        return null;
    }

    public static SortedBinaryDocValues toString(final SortedNumericLongValues values) {
        LongValues singleton = SortedNumericLongValues.unwrapSingleton(values);
        if (singleton != null) {
            return FieldData.singleton(FieldData.toString(singleton));
        }
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Long.toString(values.nextValue()));
                }
            }
        });
    }

    public static BinaryDocValues toString(final LongValues values) {
        return FieldData.toString(new ToStringValue(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public CharSequence get() throws IOException {
                return Long.toString(values.longValue());
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedNumericDoubleValues values) {
        DoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return FieldData.singleton(FieldData.toString(singleton));
        }
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Double.toString(values.nextValue()));
                }
            }
        });
    }

    public static BinaryDocValues toString(final DoubleValues values) {
        return FieldData.toString(new ToStringValue(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public CharSequence get() throws IOException {
                return Double.toString(values.doubleValue());
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedSetDocValues values) {
        SortedDocValues singleton = DocValues.unwrapSingleton(values);
        if (singleton != null) {
            return FieldData.singleton(FieldData.toString(singleton));
        }
        return new SortedBinaryDocValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public BytesRef nextValue() throws IOException {
                return values.lookupOrd(values.nextOrd());
            }
        };
    }

    public static BinaryDocValues toString(final SortedDocValues values) {
        return new AbstractBinaryDocValues(){

            @Override
            public BytesRef binaryValue() throws IOException {
                return values.lookupOrd(values.ordValue());
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }
        };
    }

    public static SortedBinaryDocValues toString(final MultiGeoPointValues values) {
        GeoPointValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return FieldData.singleton(FieldData.toString(singleton));
        }
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(values.nextValue().toString());
                }
            }
        });
    }

    public static BinaryDocValues toString(final GeoPointValues values) {
        return FieldData.toString(new ToStringValue(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public CharSequence get() throws IOException {
                return values.pointValue().toString();
            }
        });
    }

    private static SortedBinaryDocValues toString(final ToStringValues toStringValues) {
        return new SortingBinaryDocValues(){
            final List<CharSequence> list = new ArrayList<CharSequence>();

            @Override
            public boolean advanceExact(int docID) throws IOException {
                if (!toStringValues.advanceExact(docID)) {
                    return false;
                }
                this.list.clear();
                toStringValues.get(this.list);
                this.count = this.list.size();
                this.grow();
                for (int i = 0; i < this.count; ++i) {
                    CharSequence s = this.list.get(i);
                    this.values[i].copyChars(s);
                }
                this.sort();
                return true;
            }
        };
    }

    private static BinaryDocValues toString(final ToStringValue toStringValue) {
        return new AbstractBinaryDocValues(){
            private final BytesRefBuilder builder = new BytesRefBuilder();

            @Override
            public BytesRef binaryValue() {
                return this.builder.toBytesRef();
            }

            @Override
            public boolean advanceExact(int docID) throws IOException {
                if (toStringValue.advanceExact(docID)) {
                    this.builder.clear();
                    this.builder.copyChars(toStringValue.get());
                    return true;
                }
                return false;
            }
        };
    }

    public static DenseLongValues replaceMissing(final LongValues values, final long missing) {
        return new DenseLongValues(){
            private long value;

            @Override
            public void doAdvanceExact(int target) throws IOException {
                this.value = values.advanceExact(target) ? values.longValue() : missing;
            }

            @Override
            public long longValue() {
                return this.value;
            }
        };
    }

    public static DenseDoubleValues replaceMissing(final DoubleValues values, final double missing) {
        return new DenseDoubleValues(){
            private double value;

            @Override
            public void doAdvanceExact(int target) throws IOException {
                this.value = values.advanceExact(target) ? values.doubleValue() : missing;
            }

            @Override
            public double doubleValue() {
                return this.value;
            }
        };
    }

    private static /* synthetic */ FieldData[] $values() {
        return new FieldData[0];
    }

    static {
        $VALUES = FieldData.$values();
        EMPTY = new LongValues(){

            @Override
            public long longValue() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return false;
            }
        };
    }

    private static class DoubleCastedValues
    extends DoubleValues {
        private final LongValues values;

        DoubleCastedValues(LongValues values) {
            this.values = values;
        }

        @Override
        public double doubleValue() throws IOException {
            return this.values.longValue();
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }
    }

    private static class SortedDoubleCastedValues
    extends SortedNumericDoubleValues {
        private final SortedNumericLongValues values;

        SortedDoubleCastedValues(SortedNumericLongValues in) {
            this.values = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.values.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return this.values.nextValue();
        }

        @Override
        public int docValueCount() {
            return this.values.docValueCount();
        }
    }

    private static class LongCastedValues
    extends LongValues {
        private final DoubleValues values;

        LongCastedValues(DoubleValues values) {
            this.values = values;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.values.advanceExact(target);
        }

        @Override
        public long longValue() throws IOException {
            return (long)this.values.doubleValue();
        }
    }

    private static class SortedLongCastedValues
    extends SortedNumericLongValues {
        private final SortedNumericDoubleValues values;

        SortedLongCastedValues(SortedNumericDoubleValues in) {
            this.values = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.values.advanceExact(target);
        }

        @Override
        public int docValueCount() {
            return this.values.docValueCount();
        }

        @Override
        public long nextValue() throws IOException {
            return (long)this.values.nextValue();
        }
    }

    private static interface ToStringValues {
        public boolean advanceExact(int var1) throws IOException;

        public void get(List<CharSequence> var1) throws IOException;
    }

    private static interface ToStringValue {
        public boolean advanceExact(int var1) throws IOException;

        public CharSequence get() throws IOException;
    }
}

