/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.VectorEncoding;
import org.elasticsearch.common.lucene.Lucene;

public class MergeMemoryEstimator {
    public static final long HNSW_PER_DOC_ESTIMATION = 348L;

    public static long estimateMergeMemory(MergePolicy.OneMerge merge, IndexReader indexReader) {
        assert (!merge.segments.isEmpty());
        long memoryNeeded = 0L;
        Map<String, SegmentCommitInfo> segments = merge.segments.stream().collect(Collectors.toMap(s -> s.info.name, s -> s));
        List<LeafReaderContext> leaves = indexReader.leaves();
        SegmentReader segmentReader = null;
        for (LeafReaderContext leafReaderContext : leaves) {
            segmentReader = Lucene.segmentReader(leafReaderContext.reader());
            String segmentName = segmentReader.getSegmentName();
            SegmentCommitInfo segmentCommitInfo = segments.get(segmentName);
            if (segmentCommitInfo == null) continue;
            memoryNeeded += MergeMemoryEstimator.estimateMergeMemory(segmentCommitInfo, segmentReader);
            segments.remove(segmentName);
            if (!segments.isEmpty()) continue;
            break;
        }
        if (segmentReader != null) {
            for (SegmentCommitInfo segmentCommitInfo : segments.values()) {
                memoryNeeded += MergeMemoryEstimator.estimateMergeMemory(segmentCommitInfo, segmentReader);
            }
        }
        return memoryNeeded;
    }

    private static long estimateMergeMemory(SegmentCommitInfo segmentCommitInfo, SegmentReader reader) {
        long maxMem = 0L;
        for (FieldInfo fieldInfo : reader.getFieldInfos()) {
            maxMem = Math.max(maxMem, MergeMemoryEstimator.estimateFieldMemory(fieldInfo, segmentCommitInfo, reader));
        }
        return maxMem;
    }

    private static long estimateFieldMemory(FieldInfo fieldInfo, SegmentCommitInfo segmentCommitInfo, SegmentReader segmentReader) {
        long maxMem = 0L;
        if (fieldInfo.hasVectorValues()) {
            maxMem = Math.max(maxMem, MergeMemoryEstimator.estimateVectorFieldMemory(fieldInfo, segmentCommitInfo, segmentReader));
        }
        return maxMem;
    }

    private static long estimateVectorFieldMemory(FieldInfo fieldInfo, SegmentCommitInfo segmentCommitInfo, SegmentReader segmentReader) {
        KnnVectorsReader vectorsReader = segmentReader.getVectorReader();
        if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            PerFieldKnnVectorsFormat.FieldsReader perFieldKnnVectorsFormat = (PerFieldKnnVectorsFormat.FieldsReader)vectorsReader;
            vectorsReader = perFieldKnnVectorsFormat.getFieldReader(fieldInfo.getName());
        }
        return MergeMemoryEstimator.getVectorFieldEstimation(fieldInfo, segmentCommitInfo, vectorsReader);
    }

    private static long getVectorFieldEstimation(FieldInfo fieldInfo, SegmentCommitInfo segmentCommitInfo, KnnVectorsReader vectorsReader) {
        int numDocs = segmentCommitInfo.info.maxDoc() - segmentCommitInfo.getDelCount();
        if (vectorsReader instanceof Lucene99HnswVectorsReader) {
            return (long)numDocs * 348L;
        }
        if (fieldInfo.getVectorEncoding() == VectorEncoding.FLOAT32) {
            return fieldInfo.getVectorDimension() * VectorEncoding.FLOAT32.byteSize;
        }
        return 0L;
    }
}

