/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.index.engine.VersionValue;
import org.elasticsearch.index.translog.Translog;

final class IndexVersionValue
extends VersionValue {
    private static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IndexVersionValue.class);
    private final Translog.Location translogLocation;

    IndexVersionValue(Translog.Location translogLocation, long version, long seqNo, long term) {
        super(version, seqNo, term);
        this.translogLocation = translogLocation;
    }

    @Override
    public long ramBytesUsed() {
        return RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf(this.translogLocation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexVersionValue that = (IndexVersionValue)o;
        return Objects.equals(this.translogLocation, that.translogLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.translogLocation);
    }

    @Override
    public String toString() {
        return "IndexVersionValue{version=" + this.version + ", seqNo=" + this.seqNo + ", term=" + this.term + ", location=" + String.valueOf(this.translogLocation) + "}";
    }

    @Override
    public Translog.Location getLocation() {
        return this.translogLocation;
    }
}

