/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.UnsafePlainActionFuture;
import org.elasticsearch.common.FieldMemoryStats;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.search.suggest.completion.CompletionStats;

public class CompletionStatsCache
implements ReferenceManager.RefreshListener {
    private final Supplier<Engine.Searcher> searcherSupplier;
    private final AtomicReference<PlainActionFuture<CompletionStats>> completionStatsFutureRef = new AtomicReference();

    public CompletionStatsCache(Supplier<Engine.Searcher> searcherSupplier) {
        this.searcherSupplier = searcherSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStats get(String ... fieldNamePatterns) {
        CompletionStats completionStats;
        UnsafePlainActionFuture newFuture = new UnsafePlainActionFuture("management");
        PlainActionFuture oldFuture = this.completionStatsFutureRef.compareAndExchange(null, newFuture);
        if (oldFuture != null) {
            return CompletionStatsCache.filterCompletionStatsByFieldName(fieldNamePatterns, (CompletionStats)oldFuture.actionGet());
        }
        ActionListener.completeWith(newFuture, () -> {
            long sizeInBytes = 0L;
            HashMap<String, Long> completionFields = new HashMap<String, Long>();
            try (Engine.Searcher currentSearcher = this.searcherSupplier.get();){
                for (LeafReaderContext atomicReaderContext : currentSearcher.getIndexReader().leaves()) {
                    LeafReader atomicReader = atomicReaderContext.reader();
                    for (FieldInfo info : atomicReader.getFieldInfos()) {
                        Terms terms = atomicReader.terms(info.name);
                        if (!(terms instanceof CompletionTerms)) continue;
                        long fstSize = ((CompletionTerms)terms).suggester().ramBytesUsed();
                        completionFields.merge(info.name, fstSize, Long::sum);
                        sizeInBytes += fstSize;
                    }
                }
            }
            return new CompletionStats(sizeInBytes, new FieldMemoryStats(completionFields));
        });
        boolean success = false;
        try {
            completionStats = (CompletionStats)newFuture.actionGet();
            success = true;
        }
        finally {
            if (!success) {
                this.completionStatsFutureRef.compareAndSet(newFuture, null);
            }
        }
        return CompletionStatsCache.filterCompletionStatsByFieldName(fieldNamePatterns, completionStats);
    }

    private static CompletionStats filterCompletionStatsByFieldName(String[] fieldNamePatterns, CompletionStats fullCompletionStats) {
        FieldMemoryStats fieldMemoryStats;
        if (!CollectionUtils.isEmpty(fieldNamePatterns)) {
            HashMap<String, Long> completionFields = new HashMap<String, Long>(fieldNamePatterns.length);
            for (Map.Entry<String, Long> field : fullCompletionStats.getFields()) {
                if (!Regex.simpleMatch(fieldNamePatterns, field.getKey())) continue;
                completionFields.merge(field.getKey(), field.getValue(), Long::sum);
            }
            fieldMemoryStats = new FieldMemoryStats(completionFields);
        } else {
            fieldMemoryStats = null;
        }
        return new CompletionStats(fullCompletionStats.getSizeInBytes(), fieldMemoryStats);
    }

    @Override
    public void beforeRefresh() {
    }

    @Override
    public void afterRefresh(boolean didRefresh) {
        if (didRefresh) {
            this.completionStatsFutureRef.set(null);
        }
    }
}

