/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.zstd;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.elasticsearch.index.codec.zstd.ZstdCompressionMode;

public final class Zstd814StoredFieldsFormat
extends Lucene90CompressingStoredFieldsFormat {
    private static final int BEST_SPEED_BLOCK_SIZE = 14336;
    private static final int BEST_COMPRESSION_BLOCK_SIZE = 245760;
    public static final String MODE_KEY = Zstd814StoredFieldsFormat.class.getSimpleName() + ".mode";
    private final Mode mode;

    private Zstd814StoredFieldsFormat(Mode mode) {
        super("ZstdStoredFields814", new ZstdCompressionMode(mode.level), mode.blockSizeInBytes, mode.blockDocCount, 10);
        this.mode = mode;
    }

    @Override
    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        String previous = si.putAttribute(MODE_KEY, this.mode.name());
        if (previous != null && !previous.equals(this.mode.name())) {
            throw new IllegalStateException("found existing value for " + MODE_KEY + " for segment: " + si.name + "old=" + previous + ", new=" + this.mode.name());
        }
        return super.fieldsWriter(directory, si, context);
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        BEST_SPEED(1, 14336, 128),
        BEST_COMPRESSION(3, 245760, 2048);

        final int level;
        final int blockSizeInBytes;
        final int blockDocCount;
        final Zstd814StoredFieldsFormat format;

        private Mode(int level, int blockSizeInBytes, int blockDocCount) {
            this.level = level;
            this.blockSizeInBytes = blockSizeInBytes;
            this.blockDocCount = blockDocCount;
            this.format = new Zstd814StoredFieldsFormat(this);
        }

        public Zstd814StoredFieldsFormat getFormat() {
            return this.format;
        }
    }
}

