/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.vectors.AbstractHnswVectorsFormat;
import org.elasticsearch.index.codec.vectors.es93.ES93GenericFlatVectorsFormat;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class ES93HnswVectorsFormat
extends AbstractHnswVectorsFormat {
    static final String NAME = "ES93HnswVectorsFormat";
    private final FlatVectorsFormat flatVectorsFormat;

    public ES93HnswVectorsFormat() {
        super(NAME);
        this.flatVectorsFormat = new ES93GenericFlatVectorsFormat();
    }

    public ES93HnswVectorsFormat(DenseVectorFieldMapper.ElementType elementType) {
        super(NAME);
        this.flatVectorsFormat = new ES93GenericFlatVectorsFormat(elementType, false);
    }

    public ES93HnswVectorsFormat(int maxConn, int beamWidth, DenseVectorFieldMapper.ElementType elementType) {
        super(NAME, maxConn, beamWidth);
        this.flatVectorsFormat = new ES93GenericFlatVectorsFormat(elementType, false);
    }

    public ES93HnswVectorsFormat(int maxConn, int beamWidth, DenseVectorFieldMapper.ElementType elementType, int numMergeWorkers, ExecutorService mergeExec) {
        super(NAME, maxConn, beamWidth, numMergeWorkers, mergeExec);
        this.flatVectorsFormat = new ES93GenericFlatVectorsFormat(elementType, false);
    }

    @Override
    protected FlatVectorsFormat flatVectorsFormat() {
        return this.flatVectorsFormat;
    }

    @Override
    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99HnswVectorsWriter(state, this.maxConn, this.beamWidth, this.flatVectorsFormat.fieldsWriter(state), this.numMergeWorkers, this.mergeExec);
    }

    @Override
    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, this.flatVectorsFormat.fieldsReader(state));
    }
}

