/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.DataAccessHint;
import org.apache.lucene.store.FileDataHint;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.vectors.BFloat16;
import org.elasticsearch.index.codec.vectors.es93.OffHeapBFloat16VectorValues;

public final class ES93BFloat16FlatVectorsWriter
extends FlatVectorsWriter {
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ES93BFloat16FlatVectorsWriter.class);
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final List<FieldWriter<?>> fields = new ArrayList();
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ES93BFloat16FlatVectorsWriter(SegmentWriteState state, FlatVectorsScorer scorer) throws IOException {
        super(scorer);
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemf");
        String vectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vec");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "ES93BFloat16FlatVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorData, "ES93BFloat16FlatVectorsFormatData", 0, state.segmentInfo.getId(), state.segmentSuffix);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this);
            }
        }
    }

    @Override
    public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        FieldWriter<?> newField = FieldWriter.create(fieldInfo);
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        for (FieldWriter<?> field : this.fields) {
            if (sortMap == null) {
                this.writeField(field, maxDoc);
            } else {
                this.writeSortingField(field, maxDoc, sortMap);
            }
            field.finish();
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.writeFooter(this.vectorData);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void writeField(FieldWriter<?> fieldData, int maxDoc) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(2);
        switch (fieldData.fieldInfo.getVectorEncoding()) {
            case FLOAT32: {
                this.writeBFloat16Vectors(fieldData);
                break;
            }
            case BYTE: {
                throw new IllegalStateException("Incorrect encoding for field " + fieldData.fieldInfo.name + ": " + String.valueOf((Object)VectorEncoding.BYTE));
            }
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, fieldData.docsWithField);
    }

    private void writeBFloat16Vectors(FieldWriter<?> fieldData) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(fieldData.dim * 2).order(ByteOrder.LITTLE_ENDIAN);
        for (Object v : fieldData.vectors) {
            BFloat16.floatToBFloat16((float[])v, buffer.asShortBuffer());
            this.vectorData.writeBytes(buffer.array(), buffer.array().length);
        }
    }

    private void writeSortingField(FieldWriter<?> fieldData, int maxDoc, Sorter.DocMap sortMap) throws IOException {
        int[] ordMap = new int[fieldData.docsWithField.cardinality()];
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        ES93BFloat16FlatVectorsWriter.mapOldOrdToNewOrd(fieldData.docsWithField, sortMap, null, ordMap, newDocsWithField);
        switch (fieldData.fieldInfo.getVectorEncoding()) {
            default: {
                throw new MatchException(null, null);
            }
            case FLOAT32: {
                break;
            }
            case BYTE: {
                throw new IllegalStateException("Incorrect encoding for field " + fieldData.fieldInfo.name + ": " + String.valueOf((Object)VectorEncoding.BYTE));
            }
        }
        long vectorDataOffset = this.writeSortedBFloat16Vectors(fieldData, ordMap);
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, newDocsWithField);
    }

    private long writeSortedBFloat16Vectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(2);
        ByteBuffer buffer = ByteBuffer.allocate(fieldData.dim * 2).order(ByteOrder.LITTLE_ENDIAN);
        for (int ordinal : ordMap) {
            float[] vector = (float[])fieldData.vectors.get(ordinal);
            BFloat16.floatToBFloat16(vector, buffer.asShortBuffer());
            this.vectorData.writeBytes(buffer.array(), buffer.array().length);
        }
        return vectorDataOffset;
    }

    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(2);
        switch (fieldInfo.getVectorEncoding()) {
            default: {
                throw new MatchException(null, null);
            }
            case FLOAT32: {
                break;
            }
            case BYTE: {
                throw new IllegalStateException("Incorrect encoding for field " + fieldInfo.name + ": " + String.valueOf((Object)VectorEncoding.BYTE));
            }
        }
        DocsWithFieldSet docsWithField = ES93BFloat16FlatVectorsWriter.writeVectorData(this.vectorData, KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState));
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, docsWithField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        FlatCloseableRandomVectorScorerSupplier flatCloseableRandomVectorScorerSupplier;
        block11: {
            long vectorDataOffset = this.vectorData.alignFilePointer(2);
            IndexOutput tempVectorData = this.segmentWriteState.directory.createTempOutput(this.vectorData.getName(), "temp", this.segmentWriteState.context);
            IndexInput vectorDataInput = null;
            boolean success = false;
            try {
                switch (fieldInfo.getVectorEncoding()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOAT32: {
                        break;
                    }
                    case BYTE: {
                        throw new UnsupportedOperationException("ES92BFloat16FlatVectorsWriter only supports float vectors");
                    }
                }
                DocsWithFieldSet docsWithField = ES93BFloat16FlatVectorsWriter.writeVectorData(tempVectorData, KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState));
                CodecUtil.writeFooter(tempVectorData);
                IOUtils.close((Closeable)tempVectorData);
                vectorDataInput = this.segmentWriteState.directory.openInput(tempVectorData.getName(), IOContext.DEFAULT.withHints(FileTypeHint.DATA, FileDataHint.KNN_VECTORS, DataAccessHint.RANDOM));
                this.vectorData.copyBytes(vectorDataInput, vectorDataInput.length() - (long)CodecUtil.footerLength());
                CodecUtil.retrieveChecksum(vectorDataInput);
                long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
                this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, docsWithField);
                success = true;
                IndexInput finalVectorDataInput = vectorDataInput;
                RandomVectorScorerSupplier randomVectorScorerSupplier = this.vectorsScorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), new OffHeapBFloat16VectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), finalVectorDataInput, fieldInfo.getVectorDimension() * 2, this.vectorsScorer, fieldInfo.getVectorSimilarityFunction()));
                flatCloseableRandomVectorScorerSupplier = new FlatCloseableRandomVectorScorerSupplier(() -> {
                    IOUtils.close((Closeable)finalVectorDataInput);
                    this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
                }, docsWithField.cardinality(), randomVectorScorerSupplier);
                if (success) break block11;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(vectorDataInput, tempVectorData);
                    try {
                        this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(vectorDataInput, tempVectorData);
            try {
                this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flatCloseableRandomVectorScorerSupplier;
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, DocsWithFieldSet docsWithField) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        OrdToDocDISIReaderConfiguration.writeStoredMeta(16, this.meta, this.vectorData, count, maxDoc, docsWithField);
    }

    private static DocsWithFieldSet writeVectorData(IndexOutput output, FloatVectorValues floatVectorValues) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        ByteBuffer buffer = ByteBuffer.allocate(floatVectorValues.dimension() * 2).order(ByteOrder.LITTLE_ENDIAN);
        KnnVectorValues.DocIndexIterator iter = floatVectorValues.iterator();
        int docV = iter.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            float[] value = floatVectorValues.vectorValue(iter.index());
            BFloat16.floatToBFloat16(value, buffer.asShortBuffer());
            output.writeBytes(buffer.array(), buffer.limit());
            docsWithField.add(docV);
            docV = iter.nextDoc();
        }
        return docsWithField;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorData);
    }

    private static abstract class FieldWriter<T>
    extends FlatFieldVectorsWriter<T> {
        private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private final int dim;
        private final DocsWithFieldSet docsWithField;
        private final List<T> vectors;
        private boolean finished;
        private int lastDocID = -1;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static FieldWriter<?> create(FieldInfo fieldInfo) {
            final int dim = fieldInfo.getVectorDimension();
            switch (fieldInfo.getVectorEncoding()) {
                default: {
                    throw new MatchException(null, null);
                }
                case FLOAT32: {
                    return new FieldWriter<float[]>(fieldInfo){

                        @Override
                        public float[] copyValue(float[] value) {
                            return ArrayUtil.copyOfSubArray(value, 0, dim);
                        }
                    };
                }
                case BYTE: {
                    throw new IllegalStateException("Incorrect encoding for field " + fieldInfo.name + ": " + String.valueOf((Object)VectorEncoding.BYTE));
                }
            }
        }

        FieldWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.dim = fieldInfo.getVectorDimension();
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList<T>();
        }

        @Override
        public void addValue(int docID, T vectorValue) throws IOException {
            if (this.finished) {
                throw new IllegalStateException("already finished, cannot add more values");
            }
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            assert (docID > this.lastDocID);
            T copy = this.copyValue(vectorValue);
            this.docsWithField.add(docID);
            this.vectors.add(copy);
            this.lastDocID = docID;
        }

        @Override
        public long ramBytesUsed() {
            long size = SHALLOW_RAM_BYTES_USED;
            if (this.vectors.size() == 0) {
                return size;
            }
            int byteSize = this.fieldInfo.getVectorEncoding() == VectorEncoding.FLOAT32 ? 2 : this.fieldInfo.getVectorEncoding().byteSize;
            return size + this.docsWithField.ramBytesUsed() + (long)this.vectors.size() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)this.vectors.size() * (long)this.fieldInfo.getVectorDimension() * (long)byteSize;
        }

        @Override
        public List<T> getVectors() {
            return this.vectors;
        }

        @Override
        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.docsWithField;
        }

        @Override
        public void finish() throws IOException {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    static final class FlatCloseableRandomVectorScorerSupplier
    implements CloseableRandomVectorScorerSupplier {
        private final RandomVectorScorerSupplier supplier;
        private final Closeable onClose;
        private final int numVectors;

        FlatCloseableRandomVectorScorerSupplier(Closeable onClose, int numVectors, RandomVectorScorerSupplier supplier) {
            this.onClose = onClose;
            this.supplier = supplier;
            this.numVectors = numVectors;
        }

        @Override
        public UpdateableRandomVectorScorer scorer() throws IOException {
            return this.supplier.scorer();
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return this.supplier.copy();
        }

        @Override
        public void close() throws IOException {
            this.onClose.close();
        }

        @Override
        public int totalVectorCount() {
            return this.numVectors;
        }
    }
}

