/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es816;

import java.io.IOException;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.es816.BinaryQuantizer;

public abstract class BinarizedByteVectorValues
extends ByteVectorValues {
    public abstract float[] getCorrectiveTerms(int var1) throws IOException;

    @Override
    public abstract int dimension();

    public abstract float getCentroidDistance(int var1) throws IOException;

    public abstract float getVectorMagnitude(int var1) throws IOException;

    public abstract float getOOQ(int var1) throws IOException;

    public abstract float getNormOC(int var1) throws IOException;

    public abstract float getODotC(int var1) throws IOException;

    public abstract BinaryQuantizer getQuantizer();

    public abstract float[] getCentroid() throws IOException;

    @Override
    public abstract int size();

    int discretizedDimensions() {
        return BQVectorUtils.discretize(this.dimension(), 64);
    }

    float sqrtDimensions() {
        return (float)BQVectorUtils.constSqrt(this.dimension());
    }

    float maxX1() {
        return (float)(1.9 / BQVectorUtils.constSqrt((double)this.discretizedDimensions() - 1.0));
    }

    public abstract VectorScorer scorer(float[] var1) throws IOException;

    @Override
    public abstract BinarizedByteVectorValues copy() throws IOException;

    float getCentroidDP() throws IOException {
        float[] centroid = this.getCentroid();
        return VectorUtil.dotProduct(centroid, centroid);
    }
}

