/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq.next;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.packed.DirectReader;
import org.apache.lucene.util.packed.DirectWriter;
import org.elasticsearch.index.codec.vectors.GenericFlatVectorReaders;
import org.elasticsearch.index.codec.vectors.OptimizedScalarQuantizer;
import org.elasticsearch.index.codec.vectors.cluster.NeighborQueue;
import org.elasticsearch.index.codec.vectors.diskbbq.DocIdsWriter;
import org.elasticsearch.index.codec.vectors.diskbbq.IVFVectorsReader;
import org.elasticsearch.index.codec.vectors.diskbbq.next.ESNextDiskBBQVectorsFormat;
import org.elasticsearch.simdvec.ES92Int7VectorsScorer;
import org.elasticsearch.simdvec.ESNextOSQVectorsScorer;
import org.elasticsearch.simdvec.ESVectorUtil;

public class ESNextDiskBBQVectorsReader
extends IVFVectorsReader {
    public ESNextDiskBBQVectorsReader(SegmentReadState state, GenericFlatVectorReaders.LoadFlatVectorsReader getFormatReader) throws IOException {
        super(state, getFormatReader);
    }

    IVFVectorsReader.CentroidIterator getPostingListPrefetchIterator(final IVFVectorsReader.CentroidIterator centroidIterator, final IndexInput postingListSlice) throws IOException {
        return new IVFVectorsReader.CentroidIterator(){
            IVFVectorsReader.CentroidOffsetAndLength nextOffsetAndLength;
            {
                IVFVectorsReader.CentroidOffsetAndLength centroidOffsetAndLength = this.nextOffsetAndLength = centroidIterator.hasNext() ? centroidIterator.nextPostingListOffsetAndLength() : null;
                if (this.nextOffsetAndLength != null) {
                    this.prefetch(this.nextOffsetAndLength);
                }
            }

            void prefetch(IVFVectorsReader.CentroidOffsetAndLength offsetAndLength) throws IOException {
                postingListSlice.prefetch(offsetAndLength.offset(), offsetAndLength.length());
            }

            @Override
            public boolean hasNext() {
                return this.nextOffsetAndLength != null;
            }

            @Override
            public IVFVectorsReader.CentroidOffsetAndLength nextPostingListOffsetAndLength() throws IOException {
                IVFVectorsReader.CentroidOffsetAndLength offsetAndLength = this.nextOffsetAndLength;
                if (centroidIterator.hasNext()) {
                    this.nextOffsetAndLength = centroidIterator.nextPostingListOffsetAndLength();
                    this.prefetch(this.nextOffsetAndLength);
                } else {
                    this.nextOffsetAndLength = null;
                }
                return offsetAndLength;
            }
        };
    }

    static long directWriterSizeOnDisk(long numValues, int bitsPerValue) {
        long bytes = (numValues * (long)bitsPerValue + 8L - 1L) / 8L;
        int paddingBitsNeeded = bitsPerValue > 32 ? 64 - bitsPerValue : (bitsPerValue > 16 ? 32 - bitsPerValue : (bitsPerValue > 8 ? 16 - bitsPerValue : 0));
        int paddingBytesNeeded = (paddingBitsNeeded + 8 - 1) / 8;
        return bytes + (long)paddingBytesNeeded;
    }

    @Override
    public IVFVectorsReader.CentroidIterator getCentroidIterator(FieldInfo fieldInfo, int numCentroids, IndexInput centroids, float[] targetQuery, IndexInput postingListSlice, AcceptDocs acceptDocs, float approximateCost, FloatVectorValues values, float visitRatio) throws IOException {
        IVFVectorsReader.CentroidIterator centroidIterator;
        FixedBitSet acceptCentroids;
        IVFVectorsReader.FieldEntry fieldEntry = (IVFVectorsReader.FieldEntry)this.fields.get(fieldInfo.number);
        float approximateDocsPerCentroid = approximateCost / (float)numCentroids;
        if ((double)approximateDocsPerCentroid <= 1.25) {
            approximateDocsPerCentroid = (float)acceptDocs.cost() / (float)numCentroids;
        }
        int bitsRequired = DirectWriter.bitsRequired(numCentroids);
        long sizeLookup = ESNextDiskBBQVectorsReader.directWriterSizeOnDisk(values.size(), bitsRequired);
        long fp = centroids.getFilePointer();
        if ((double)approximateDocsPerCentroid > 1.25 || numCentroids == 1) {
            acceptCentroids = null;
        } else {
            acceptCentroids = new FixedBitSet(numCentroids);
            KnnVectorValues.DocIndexIterator docIndexIterator = values.iterator();
            DocIdSetIterator iterator = ConjunctionUtils.intersectIterators(List.of(acceptDocs.iterator(), docIndexIterator));
            LongValues longValues = DirectReader.getInstance(centroids.randomAccessSlice(fp, sizeLookup), bitsRequired);
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                acceptCentroids.set((int)longValues.get(docIndexIterator.index()));
                doc = iterator.nextDoc();
            }
        }
        OptimizedScalarQuantizer scalarQuantizer = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction());
        int[] scratch = new int[targetQuery.length];
        OptimizedScalarQuantizer.QuantizationResult queryParams = scalarQuantizer.scalarQuantize(targetQuery, new float[targetQuery.length], scratch, (byte)7, fieldEntry.globalCentroid());
        byte[] quantized = new byte[targetQuery.length];
        for (int i = 0; i < quantized.length; ++i) {
            quantized[i] = (byte)scratch[i];
        }
        ES92Int7VectorsScorer scorer = ESVectorUtil.getES92Int7VectorsScorer((IndexInput)centroids, (int)fieldInfo.getVectorDimension());
        centroids.seek(fp + sizeLookup);
        int numParents = centroids.readVInt();
        if (numParents > 0) {
            float centroidOversampling = (float)fieldEntry.numCentroids() / (float)(2 * numParents);
            centroidIterator = ESNextDiskBBQVectorsReader.getCentroidIteratorWithParents(fieldInfo, centroids, numParents, numCentroids, scorer, quantized, queryParams, fieldEntry.globalCentroidDp(), visitRatio * centroidOversampling, acceptCentroids);
        } else {
            centroidIterator = ESNextDiskBBQVectorsReader.getCentroidIteratorNoParent(fieldInfo, centroids, numCentroids, scorer, quantized, queryParams, fieldEntry.globalCentroidDp(), acceptCentroids);
        }
        return this.getPostingListPrefetchIterator(centroidIterator, postingListSlice);
    }

    @Override
    protected IVFVectorsReader.FieldEntry doReadField(IndexInput input, String rawVectorFormat, boolean useDirectIOReads, VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, int numCentroids, long centroidOffset, long centroidLength, long postingListOffset, long postingListLength, float[] globalCentroid, float globalCentroidDp) throws IOException {
        ESNextDiskBBQVectorsFormat.QuantEncoding quantEncoding = ESNextDiskBBQVectorsFormat.QuantEncoding.fromId(input.readInt());
        return new NextFieldEntry(rawVectorFormat, useDirectIOReads, similarityFunction, vectorEncoding, numCentroids, centroidOffset, centroidLength, postingListOffset, postingListLength, globalCentroid, globalCentroidDp, quantEncoding);
    }

    private static IVFVectorsReader.CentroidIterator getCentroidIteratorNoParent(FieldInfo fieldInfo, final IndexInput centroids, int numCentroids, ES92Int7VectorsScorer scorer, byte[] quantizeQuery, OptimizedScalarQuantizer.QuantizationResult queryParams, float globalCentroidDp, FixedBitSet acceptCentroids) throws IOException {
        final NeighborQueue neighborQueue = new NeighborQueue(numCentroids, true);
        long centroidQuantizeSize = fieldInfo.getVectorDimension() + 12 + 4;
        ESNextDiskBBQVectorsReader.score(neighborQueue, numCentroids, 0, scorer, centroids, centroidQuantizeSize, quantizeQuery, queryParams, globalCentroidDp, fieldInfo.getVectorSimilarityFunction(), new float[16], acceptCentroids);
        final long offset = centroids.getFilePointer();
        return new IVFVectorsReader.CentroidIterator(){

            @Override
            public boolean hasNext() {
                return neighborQueue.size() > 0;
            }

            @Override
            public IVFVectorsReader.CentroidOffsetAndLength nextPostingListOffsetAndLength() throws IOException {
                int centroidOrdinal = neighborQueue.pop();
                centroids.seek(offset + 16L * (long)centroidOrdinal);
                long postingListOffset = centroids.readLong();
                long postingListLength = centroids.readLong();
                return new IVFVectorsReader.CentroidOffsetAndLength(postingListOffset, postingListLength);
            }
        };
    }

    private static IVFVectorsReader.CentroidIterator getCentroidIteratorWithParents(final FieldInfo fieldInfo, final IndexInput centroids, int numParents, int numCentroids, final ES92Int7VectorsScorer scorer, final byte[] quantizeQuery, final OptimizedScalarQuantizer.QuantizationResult queryParams, final float globalCentroidDp, float centroidRatio, final FixedBitSet acceptCentroids) throws IOException {
        NeighborQueue neighborQueue;
        int numCentroidsFiltered;
        final long centroidQuantizeSize = fieldInfo.getVectorDimension() + 12 + 4;
        final NeighborQueue parentsQueue = new NeighborQueue(numParents, true);
        int maxChildrenSize = centroids.readVInt();
        final NeighborQueue currentParentQueue = new NeighborQueue(maxChildrenSize, true);
        int bufferSize = (int)Math.min(Math.max(centroidRatio * (float)numCentroids, 1.0f), (float)numCentroids);
        int n = numCentroidsFiltered = acceptCentroids == null ? numCentroids : acceptCentroids.cardinality();
        if (numCentroidsFiltered == 0) {
            return new IVFVectorsReader.CentroidIterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public IVFVectorsReader.CentroidOffsetAndLength nextPostingListOffsetAndLength() {
                    return null;
                }
            };
        }
        final float[] scores = new float[16];
        if (acceptCentroids != null && numCentroidsFiltered <= bufferSize) {
            neighborQueue = new NeighborQueue(numCentroidsFiltered, true);
            for (int i = 0; i < numParents; ++i) {
                parentsQueue.add(i, 0.5f);
            }
            centroids.skipBytes(centroidQuantizeSize * (long)numParents);
        } else {
            neighborQueue = new NeighborQueue(bufferSize, true);
            ESNextDiskBBQVectorsReader.score(parentsQueue, numParents, 0, scorer, centroids, centroidQuantizeSize, quantizeQuery, queryParams, globalCentroidDp, fieldInfo.getVectorSimilarityFunction(), scores, null);
        }
        final long offset = centroids.getFilePointer();
        final long childrenOffset = offset + 8L * (long)numParents;
        while (parentsQueue.size() > 0 && neighborQueue.size() < bufferSize) {
            int pop = parentsQueue.pop();
            ESNextDiskBBQVectorsReader.populateOneChildrenGroup(currentParentQueue, centroids, offset + 8L * (long)pop, childrenOffset, centroidQuantizeSize, fieldInfo, scorer, quantizeQuery, queryParams, globalCentroidDp, scores, acceptCentroids);
            while (currentParentQueue.size() > 0 && neighborQueue.size() < bufferSize) {
                float score = currentParentQueue.topScore();
                int children = currentParentQueue.pop();
                neighborQueue.add(children, score);
            }
        }
        final long childrenFileOffsets = childrenOffset + centroidQuantizeSize * (long)numCentroids;
        return new IVFVectorsReader.CentroidIterator(){

            @Override
            public boolean hasNext() {
                return neighborQueue.size() > 0;
            }

            @Override
            public IVFVectorsReader.CentroidOffsetAndLength nextPostingListOffsetAndLength() throws IOException {
                int centroidOrdinal = this.nextCentroid();
                centroids.seek(childrenFileOffsets + 16L * (long)centroidOrdinal);
                long postingListOffset = centroids.readLong();
                long postingListLength = centroids.readLong();
                return new IVFVectorsReader.CentroidOffsetAndLength(postingListOffset, postingListLength);
            }

            private int nextCentroid() throws IOException {
                if (currentParentQueue.size() > 0) {
                    return neighborQueue.popAndAddRaw(currentParentQueue.popRaw());
                }
                if (parentsQueue.size() > 0) {
                    int pop = parentsQueue.pop();
                    ESNextDiskBBQVectorsReader.populateOneChildrenGroup(currentParentQueue, centroids, offset + 8L * (long)pop, childrenOffset, centroidQuantizeSize, fieldInfo, scorer, quantizeQuery, queryParams, globalCentroidDp, scores, acceptCentroids);
                    return this.nextCentroid();
                }
                return neighborQueue.pop();
            }
        };
    }

    private static void populateOneChildrenGroup(NeighborQueue neighborQueue, IndexInput centroids, long parentOffset, long childrenOffset, long centroidQuantizeSize, FieldInfo fieldInfo, ES92Int7VectorsScorer scorer, byte[] quantizeQuery, OptimizedScalarQuantizer.QuantizationResult queryParams, float globalCentroidDp, float[] scores, FixedBitSet acceptCentroids) throws IOException {
        centroids.seek(parentOffset);
        int childrenOrdinal = centroids.readInt();
        int numChildren = centroids.readInt();
        centroids.seek(childrenOffset + centroidQuantizeSize * (long)childrenOrdinal);
        ESNextDiskBBQVectorsReader.score(neighborQueue, numChildren, childrenOrdinal, scorer, centroids, centroidQuantizeSize, quantizeQuery, queryParams, globalCentroidDp, fieldInfo.getVectorSimilarityFunction(), scores, acceptCentroids);
    }

    private static void score(NeighborQueue neighborQueue, int size, int scoresOffset, ES92Int7VectorsScorer scorer, IndexInput centroids, long centroidQuantizeSize, byte[] quantizeQuery, OptimizedScalarQuantizer.QuantizationResult queryCorrections, float centroidDp, VectorSimilarityFunction similarityFunction, float[] scores, FixedBitSet acceptCentroids) throws IOException {
        int i;
        int limit = size - 16 + 1;
        for (i = 0; i < limit; i += 16) {
            if (acceptCentroids == null || acceptCentroids.cardinality(scoresOffset + i, scoresOffset + i + 16) > 0) {
                scorer.scoreBulk(quantizeQuery, queryCorrections.lowerInterval(), queryCorrections.upperInterval(), queryCorrections.quantizedComponentSum(), queryCorrections.additionalCorrection(), similarityFunction, centroidDp, scores);
                for (int j = 0; j < 16; ++j) {
                    int centroidOrd = scoresOffset + i + j;
                    if (acceptCentroids != null && !acceptCentroids.get(centroidOrd)) continue;
                    neighborQueue.add(centroidOrd, scores[j]);
                }
                continue;
            }
            centroids.skipBytes(16L * centroidQuantizeSize);
        }
        while (i < size) {
            int centroidOrd = scoresOffset + i;
            if (acceptCentroids == null || acceptCentroids.get(centroidOrd)) {
                float score = scorer.score(quantizeQuery, queryCorrections.lowerInterval(), queryCorrections.upperInterval(), queryCorrections.quantizedComponentSum(), queryCorrections.additionalCorrection(), similarityFunction, centroidDp);
                neighborQueue.add(centroidOrd, score);
            } else {
                centroids.skipBytes(centroidQuantizeSize);
            }
            ++i;
        }
    }

    @Override
    public IVFVectorsReader.PostingVisitor getPostingVisitor(FieldInfo fieldInfo, IndexInput indexInput, float[] target, Bits acceptDocs) throws IOException {
        IVFVectorsReader.FieldEntry entry = (IVFVectorsReader.FieldEntry)this.fields.get(fieldInfo.number);
        ESNextDiskBBQVectorsFormat.QuantEncoding quantEncoding = ((NextFieldEntry)entry).quantEncoding();
        return new MemorySegmentPostingsVisitor(target, quantEncoding, indexInput, entry, fieldInfo, acceptDocs);
    }

    @Override
    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        return super.getOffHeapByteSize(fieldInfo);
    }

    static class NextFieldEntry
    extends IVFVectorsReader.FieldEntry {
        private final ESNextDiskBBQVectorsFormat.QuantEncoding quantEncoding;

        NextFieldEntry(String rawVectorFormat, boolean doDirectIOReads, VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, int numCentroids, long centroidOffset, long centroidLength, long postingListOffset, long postingListLength, float[] globalCentroid, float globalCentroidDp, ESNextDiskBBQVectorsFormat.QuantEncoding quantEncoding) {
            super(rawVectorFormat, doDirectIOReads, similarityFunction, vectorEncoding, numCentroids, centroidOffset, centroidLength, postingListOffset, postingListLength, globalCentroid, globalCentroidDp);
            this.quantEncoding = quantEncoding;
        }

        public ESNextDiskBBQVectorsFormat.QuantEncoding quantEncoding() {
            return this.quantEncoding;
        }
    }

    private static class MemorySegmentPostingsVisitor
    implements IVFVectorsReader.PostingVisitor {
        final long quantizedByteLength;
        final IndexInput indexInput;
        final float[] target;
        final IVFVectorsReader.FieldEntry entry;
        final FieldInfo fieldInfo;
        final Bits acceptDocs;
        private final ESNextOSQVectorsScorer osqVectorsScorer;
        final float[] scores = new float[16];
        final float[] correctionsLower = new float[16];
        final float[] correctionsUpper = new float[16];
        final int[] correctionsSum = new int[16];
        final float[] correctionsAdd = new float[16];
        final int[] docIdsScratch = new int[16];
        byte docEncoding;
        int docBase = 0;
        int vectors;
        boolean quantized = false;
        float centroidDp;
        final float[] centroid;
        long slicePos;
        OptimizedScalarQuantizer.QuantizationResult queryCorrections;
        final ESNextDiskBBQVectorsFormat.QuantEncoding quantEncoding;
        final float[] scratch;
        final int[] quantizationScratch;
        final byte[] quantizedQueryScratch;
        final OptimizedScalarQuantizer quantizer;
        final DocIdsWriter idsWriter = new DocIdsWriter();
        final float[] correctiveValues = new float[3];
        final long quantizedVectorByteSize;

        MemorySegmentPostingsVisitor(float[] target, ESNextDiskBBQVectorsFormat.QuantEncoding quantEncoding, IndexInput indexInput, IVFVectorsReader.FieldEntry entry, FieldInfo fieldInfo, Bits acceptDocs) throws IOException {
            this.target = target;
            this.quantEncoding = quantEncoding;
            this.indexInput = indexInput;
            this.entry = entry;
            this.fieldInfo = fieldInfo;
            this.acceptDocs = acceptDocs;
            this.centroid = new float[fieldInfo.getVectorDimension()];
            this.scratch = new float[target.length];
            int discretizedDimensions = quantEncoding.discretizedDimensions(fieldInfo.getVectorDimension());
            this.quantizationScratch = new int[discretizedDimensions];
            this.quantizedQueryScratch = new byte[quantEncoding.getQueryPackedLength(fieldInfo.getVectorDimension())];
            this.quantizedVectorByteSize = quantEncoding.getDocPackedLength(fieldInfo.getVectorDimension());
            this.quantizedByteLength = this.quantizedVectorByteSize + 12L + 2L;
            this.quantizer = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction(), 0.1f, 1);
            this.osqVectorsScorer = ESVectorUtil.getESNextOSQVectorsScorer((IndexInput)indexInput, (byte)quantEncoding.queryBits(), (byte)quantEncoding.bits(), (int)fieldInfo.getVectorDimension(), (int)((int)this.quantizedVectorByteSize));
        }

        @Override
        public int resetPostingsScorer(long offset) throws IOException {
            this.quantized = false;
            this.indexInput.seek(offset);
            this.indexInput.readFloats(this.centroid, 0, this.centroid.length);
            this.centroidDp = Float.intBitsToFloat(this.indexInput.readInt());
            this.vectors = this.indexInput.readVInt();
            this.docEncoding = this.indexInput.readByte();
            this.docBase = 0;
            this.slicePos = this.indexInput.getFilePointer();
            return this.vectors;
        }

        private float scoreIndividually() throws IOException {
            int doc;
            int j;
            float maxScore = Float.NEGATIVE_INFINITY;
            for (j = 0; j < 16; ++j) {
                doc = this.docIdsScratch[j];
                if (doc != -1) {
                    float qcDist;
                    this.scores[j] = qcDist = (float)this.osqVectorsScorer.quantizeScore(this.quantizedQueryScratch);
                    continue;
                }
                this.indexInput.skipBytes(this.quantizedVectorByteSize);
            }
            this.indexInput.readFloats(this.correctionsLower, 0, 16);
            this.indexInput.readFloats(this.correctionsUpper, 0, 16);
            for (j = 0; j < 16; ++j) {
                this.correctionsSum[j] = Short.toUnsignedInt(this.indexInput.readShort());
            }
            this.indexInput.readFloats(this.correctionsAdd, 0, 16);
            for (j = 0; j < 16; ++j) {
                doc = this.docIdsScratch[j];
                if (doc == -1) continue;
                this.scores[j] = this.osqVectorsScorer.score(this.queryCorrections.lowerInterval(), this.queryCorrections.upperInterval(), this.queryCorrections.quantizedComponentSum(), this.queryCorrections.additionalCorrection(), this.fieldInfo.getVectorSimilarityFunction(), this.centroidDp, this.correctionsLower[j], this.correctionsUpper[j], this.correctionsSum[j], this.correctionsAdd[j], this.scores[j]);
                if (!(this.scores[j] > maxScore)) continue;
                maxScore = this.scores[j];
            }
            return maxScore;
        }

        private static int docToBulkScore(int[] docIds, Bits acceptDocs) {
            assert (acceptDocs != null) : "acceptDocs must not be null";
            int docToScore = 16;
            for (int i = 0; i < 16; ++i) {
                if (acceptDocs.get(docIds[i])) continue;
                docIds[i] = -1;
                --docToScore;
            }
            return docToScore;
        }

        private void collectBulk(KnnCollector knnCollector, float[] scores) {
            for (int i = 0; i < 16; ++i) {
                int doc = this.docIdsScratch[i];
                if (doc == -1) continue;
                knnCollector.collect(doc, scores[i]);
            }
        }

        private void readDocIds(int count) throws IOException {
            this.idsWriter.readInts(this.indexInput, count, this.docEncoding, this.docIdsScratch);
            for (int j = 0; j < count; ++j) {
                this.docBase += this.docIdsScratch[j];
                this.docIdsScratch[j] = this.docBase;
            }
        }

        @Override
        public int visit(KnnCollector knnCollector) throws IOException {
            int i;
            this.indexInput.seek(this.slicePos);
            int scoredDocs = 0;
            int limit = this.vectors - 16 + 1;
            for (i = 0; i < limit; i += 16) {
                int docsToBulkScore;
                this.readDocIds(16);
                int n = docsToBulkScore = this.acceptDocs == null ? 16 : MemorySegmentPostingsVisitor.docToBulkScore(this.docIdsScratch, this.acceptDocs);
                if (docsToBulkScore == 0) {
                    this.indexInput.skipBytes(this.quantizedByteLength * 16L);
                    continue;
                }
                this.quantizeQueryIfNecessary();
                float maxScore = docsToBulkScore < 8 ? this.scoreIndividually() : this.osqVectorsScorer.scoreBulk(this.quantizedQueryScratch, this.queryCorrections.lowerInterval(), this.queryCorrections.upperInterval(), this.queryCorrections.quantizedComponentSum(), this.queryCorrections.additionalCorrection(), this.fieldInfo.getVectorSimilarityFunction(), this.centroidDp, this.scores);
                if (knnCollector.minCompetitiveSimilarity() < maxScore) {
                    this.collectBulk(knnCollector, this.scores);
                }
                scoredDocs += docsToBulkScore;
            }
            if (i < this.vectors) {
                this.readDocIds(this.vectors - i);
            }
            int count = 0;
            while (i < this.vectors) {
                int doc = this.docIdsScratch[count++];
                if (this.acceptDocs == null || this.acceptDocs.get(doc)) {
                    this.quantizeQueryIfNecessary();
                    float qcDist = this.osqVectorsScorer.quantizeScore(this.quantizedQueryScratch);
                    this.indexInput.readFloats(this.correctiveValues, 0, 3);
                    int quantizedComponentSum = Short.toUnsignedInt(this.indexInput.readShort());
                    float score = this.osqVectorsScorer.score(this.queryCorrections.lowerInterval(), this.queryCorrections.upperInterval(), this.queryCorrections.quantizedComponentSum(), this.queryCorrections.additionalCorrection(), this.fieldInfo.getVectorSimilarityFunction(), this.centroidDp, this.correctiveValues[0], this.correctiveValues[1], quantizedComponentSum, this.correctiveValues[2], qcDist);
                    ++scoredDocs;
                    knnCollector.collect(doc, score);
                } else {
                    this.indexInput.skipBytes(this.quantizedByteLength);
                }
                ++i;
            }
            if (scoredDocs > 0) {
                knnCollector.incVisitedCount(scoredDocs);
            }
            return scoredDocs;
        }

        private void quantizeQueryIfNecessary() {
            if (!this.quantized) {
                assert (this.fieldInfo.getVectorSimilarityFunction() != VectorSimilarityFunction.COSINE || VectorUtil.isUnitVector(this.target));
                this.queryCorrections = this.quantizer.scalarQuantize(this.target, this.scratch, this.quantizationScratch, this.quantEncoding.queryBits(), this.centroid);
                this.quantEncoding.packQuery(this.quantizationScratch, this.quantizedQueryScratch);
                this.quantized = true;
            }
        }
    }
}

