/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.vectors.DirectIOCapableFlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.diskbbq.ES920DiskBBQVectorsReader;
import org.elasticsearch.index.codec.vectors.diskbbq.ES920DiskBBQVectorsWriter;
import org.elasticsearch.index.codec.vectors.es93.DirectIOCapableLucene99FlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.es93.ES93BFloat16FlatVectorsFormat;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class ES920DiskBBQVectorsFormat
extends KnnVectorsFormat {
    public static final String NAME = "ES920DiskBBQVectorsFormat";
    public static final String CENTROID_EXTENSION = "cenivf";
    public static final String CLUSTER_EXTENSION = "clivf";
    static final String IVF_META_EXTENSION = "mivf";
    public static final int VERSION_START = 0;
    public static final int VERSION_DIRECT_IO = 1;
    public static final int VERSION_CURRENT = 1;
    private static final DirectIOCapableFlatVectorsFormat float32VectorFormat = new DirectIOCapableLucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private static final DirectIOCapableFlatVectorsFormat bfloat16VectorFormat = new ES93BFloat16FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private static final Map<String, DirectIOCapableFlatVectorsFormat> supportedFormats = Map.of(float32VectorFormat.getName(), float32VectorFormat, bfloat16VectorFormat.getName(), bfloat16VectorFormat);
    public static final float DYNAMIC_VISIT_RATIO = 0.0f;
    public static final int DEFAULT_VECTORS_PER_CLUSTER = 384;
    public static final int MIN_VECTORS_PER_CLUSTER = 64;
    public static final int MAX_VECTORS_PER_CLUSTER = 65536;
    public static final int DEFAULT_CENTROIDS_PER_PARENT_CLUSTER = 16;
    public static final int MIN_CENTROIDS_PER_PARENT_CLUSTER = 2;
    public static final int MAX_CENTROIDS_PER_PARENT_CLUSTER = 256;
    private final int vectorPerCluster;
    private final int centroidsPerParentCluster;
    private final DirectIOCapableFlatVectorsFormat rawVectorFormat;
    private final boolean useDirectIO;

    public ES920DiskBBQVectorsFormat(int vectorPerCluster, int centroidsPerParentCluster) {
        this(vectorPerCluster, centroidsPerParentCluster, DenseVectorFieldMapper.ElementType.FLOAT, false);
    }

    public ES920DiskBBQVectorsFormat(int vectorPerCluster, int centroidsPerParentCluster, DenseVectorFieldMapper.ElementType elementType, boolean useDirectIO) {
        super(NAME);
        if (vectorPerCluster < 64 || vectorPerCluster > 65536) {
            throw new IllegalArgumentException("vectorsPerCluster must be between 64 and 65536, got: " + vectorPerCluster);
        }
        if (centroidsPerParentCluster < 2 || centroidsPerParentCluster > 256) {
            throw new IllegalArgumentException("centroidsPerParentCluster must be between 2 and 256, got: " + centroidsPerParentCluster);
        }
        this.vectorPerCluster = vectorPerCluster;
        this.centroidsPerParentCluster = centroidsPerParentCluster;
        this.rawVectorFormat = switch (elementType) {
            case DenseVectorFieldMapper.ElementType.FLOAT -> float32VectorFormat;
            case DenseVectorFieldMapper.ElementType.BFLOAT16 -> bfloat16VectorFormat;
            default -> throw new IllegalArgumentException("Unsupported element type " + String.valueOf((Object)elementType));
        };
        this.useDirectIO = useDirectIO;
    }

    public ES920DiskBBQVectorsFormat() {
        this(384, 16);
    }

    @Override
    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES920DiskBBQVectorsWriter(state, this.rawVectorFormat.getName(), this.useDirectIO, this.rawVectorFormat.fieldsWriter(state), this.vectorPerCluster, this.centroidsPerParentCluster);
    }

    KnnVectorsWriter version0FieldsWriter(SegmentWriteState state) throws IOException {
        return new ES920DiskBBQVectorsWriter(state, this.rawVectorFormat.getName(), null, this.rawVectorFormat.fieldsWriter(state), this.vectorPerCluster, this.centroidsPerParentCluster, 0);
    }

    @Override
    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES920DiskBBQVectorsReader(state, (f, dio) -> {
            DirectIOCapableFlatVectorsFormat format = supportedFormats.get(f);
            if (format == null) {
                return null;
            }
            return format.fieldsReader(state, dio);
        });
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return "ES920DiskBBQVectorsFormat(vectorPerCluster=" + this.vectorPerCluster + ")";
    }
}

