/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.hnsw.IntToIntFunction;
import org.elasticsearch.index.codec.vectors.cluster.KMeansIntermediate;
import org.elasticsearch.index.codec.vectors.cluster.KMeansLocal;
import org.elasticsearch.index.codec.vectors.cluster.NeighborHood;

class KMeansLocalConcurrent
extends KMeansLocal {
    final TaskExecutor executor;
    final int numWorkers;

    KMeansLocalConcurrent(TaskExecutor executor, int numWorkers, int sampleSize, int maxIterations) {
        super(sampleSize, maxIterations);
        this.executor = executor;
        this.numWorkers = numWorkers;
    }

    @Override
    protected int numWorkers() {
        return this.numWorkers;
    }

    @Override
    protected boolean stepLloyd(FloatVectorValues vectors, IntToIntFunction translateOrd, float[][] centroids, FixedBitSet[] centroidChangedSlices, int[] assignments, NeighborHood[] neighborHoods) throws IOException {
        assert (this.numWorkers == centroidChangedSlices.length);
        int len = vectors.size() / this.numWorkers;
        ArrayList runners = new ArrayList(this.numWorkers);
        for (int i = 0; i < this.numWorkers; ++i) {
            int start = i * len;
            int end = i == this.numWorkers - 1 ? vectors.size() : (i + 1) * len;
            FixedBitSet centroidChangedSlice = centroidChangedSlices[i];
            runners.add(() -> KMeansLocalConcurrent.stepLloydSlice(vectors.copy(), translateOrd, centroids, centroidChangedSlice, assignments, neighborHoods, start, end));
        }
        List hasChanges = this.executor.invokeAll(runners);
        return hasChanges.stream().anyMatch(Boolean::booleanValue);
    }

    @Override
    protected void assignSpilled(FloatVectorValues vectors, KMeansIntermediate kmeansIntermediate, NeighborHood[] neighborhoods, float soarLambda) throws IOException {
        int len = vectors.size() / this.numWorkers;
        ArrayList runners = new ArrayList(this.numWorkers);
        for (int i = 0; i < this.numWorkers; ++i) {
            int start = i * len;
            int end = i == this.numWorkers - 1 ? vectors.size() : (i + 1) * len;
            runners.add(() -> {
                KMeansLocalConcurrent.assignSpilledSlice(vectors.copy(), kmeansIntermediate, neighborhoods, soarLambda, start, end);
                return null;
            });
        }
        this.executor.invokeAll(runners);
    }

    @Override
    protected NeighborHood[] computeNeighborhoods(float[][] centroids, int clustersPerNeighborhood) throws IOException {
        return NeighborHood.computeNeighborhoods(this.executor, this.numWorkers, centroids, clustersPerNeighborhood);
    }
}

