/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.lucene.index.FloatVectorValues;

class FloatVectorValuesSlice
extends FloatVectorValues {
    private final FloatVectorValues allValues;
    private final int[] slice;

    FloatVectorValuesSlice(FloatVectorValues allValues, int[] slice) {
        assert (slice != null);
        assert (slice.length <= allValues.size());
        this.allValues = allValues;
        this.slice = slice;
    }

    @Override
    public float[] vectorValue(int ord) throws IOException {
        return this.allValues.vectorValue(this.slice[ord]);
    }

    @Override
    public int dimension() {
        return this.allValues.dimension();
    }

    @Override
    public int size() {
        return this.slice.length;
    }

    @Override
    public int ordToDoc(int ord) {
        return this.slice[ord];
    }

    @Override
    public FloatVectorValues copy() throws IOException {
        return new FloatVectorValuesSlice(this.allValues.copy(), this.slice);
    }

    static FloatVectorValues createRandomSlice(FloatVectorValues origin, int k, long seed) {
        if (k >= origin.size()) {
            return origin;
        }
        int[] samples = FloatVectorValuesSlice.reservoirSample(origin.size(), k, seed);
        Arrays.sort(samples);
        return new FloatVectorValuesSlice(origin, samples);
    }

    static int[] reservoirSample(int n, int k, long seed) {
        int i;
        Random rnd = new Random(seed);
        int[] reservoir = new int[k];
        for (i = 0; i < k; ++i) {
            reservoir[i] = i;
        }
        for (i = k; i < n; ++i) {
            int j = rnd.nextInt(i + 1);
            if (j >= k) continue;
            reservoir[j] = i;
        }
        return reservoir;
    }
}

