/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.MergeInfo;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.codec.vectors.AbstractFlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.MergeReaderWrapper;
import org.elasticsearch.index.codec.vectors.es818.DirectIOHint;
import org.elasticsearch.index.store.FsDirectoryFactory;

public abstract class DirectIOCapableFlatVectorsFormat
extends AbstractFlatVectorsFormat {
    protected DirectIOCapableFlatVectorsFormat(String name) {
        super(name);
    }

    protected abstract FlatVectorsReader createReader(SegmentReadState var1) throws IOException;

    protected static boolean canUseDirectIO(SegmentReadState state) {
        return FsDirectoryFactory.isHybridFs(state.directory);
    }

    @Override
    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return this.fieldsReader(state, false);
    }

    public FlatVectorsReader fieldsReader(SegmentReadState state, boolean useDirectIO) throws IOException {
        if (state.context.context() == IOContext.Context.DEFAULT && useDirectIO && DirectIOCapableFlatVectorsFormat.canUseDirectIO(state)) {
            SegmentReadState directIOState = new SegmentReadState(state.directory, state.segmentInfo, state.fieldInfos, new DirectIOContext(state.context.hints()), state.segmentSuffix);
            return new MergeReaderWrapper(this.createReader(directIOState), this.createReader(state));
        }
        return this.createReader(state);
    }

    protected static class DirectIOContext
    implements IOContext {
        final Set<IOContext.FileOpenHint> hints;

        public DirectIOContext(Set<IOContext.FileOpenHint> hints) {
            this.hints = Sets.union(hints, Set.of(DirectIOHint.INSTANCE));
        }

        @Override
        public IOContext.Context context() {
            return IOContext.Context.DEFAULT;
        }

        @Override
        public MergeInfo mergeInfo() {
            return null;
        }

        @Override
        public FlushInfo flushInfo() {
            return null;
        }

        @Override
        public Set<IOContext.FileOpenHint> hints() {
            return this.hints;
        }

        @Override
        public IOContext withHints(IOContext.FileOpenHint ... hints) {
            return new DirectIOContext(Set.of(hints));
        }
    }
}

