/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.elasticsearch.core.SuppressForbidden;

final class OffsetsAccumulator
implements Closeable {
    private final Directory dir;
    private final IOContext context;
    private final ByteBuffersDataOutput addressMetaBuffer;
    private final ByteBuffersIndexOutput addressMetaOutput;
    private final IndexOutput addressDataOutput;
    private final DirectMonotonicWriter addressesWriter;
    private final String addressOffsetsTempFileName;
    private long addr = 0L;

    OffsetsAccumulator(Directory dir, IOContext context, IndexOutput data, long numDocsWithField) throws IOException {
        this.dir = dir;
        this.context = context;
        this.addressMetaBuffer = new ByteBuffersDataOutput();
        this.addressMetaOutput = new ByteBuffersIndexOutput(this.addressMetaBuffer, "meta-temp", "meta-temp");
        this.addressDataOutput = dir.createTempOutput(data.getName(), "address-data", context);
        this.addressOffsetsTempFileName = this.addressDataOutput.getName();
        this.addressesWriter = DirectMonotonicWriter.getInstance(this.addressMetaOutput, this.addressDataOutput, numDocsWithField + 1L, 16);
    }

    public void addDoc(int docValueCount) throws IOException {
        this.addressesWriter.add(this.addr);
        this.addr += (long)docValueCount;
    }

    public void build(IndexOutput meta, IndexOutput data) throws IOException {
        this.addressesWriter.add(this.addr);
        this.addressesWriter.finish();
        long start = data.getFilePointer();
        meta.writeLong(start);
        meta.writeVInt(16);
        this.addressMetaBuffer.copyTo(meta);
        this.addressDataOutput.close();
        try (IndexInput addressDataInput = this.dir.openInput(this.addressOffsetsTempFileName, this.context);){
            data.copyBytes(addressDataInput, addressDataInput.length());
            meta.writeLong(data.getFilePointer() - start);
        }
    }

    @Override
    @SuppressForbidden(reason="require usage of Lucene's IOUtils#deleteFilesIgnoringExceptions(...)")
    public void close() throws IOException {
        IOUtils.close(this.addressMetaOutput, this.addressDataOutput);
        if (this.addressOffsetsTempFileName != null) {
            IOUtils.deleteFilesIgnoringExceptions(this.dir, this.addressOffsetsTempFileName);
        }
    }
}

