/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.env.BuildVersion;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

final class DefaultBuildVersion
extends BuildVersion {
    public static final BuildVersion CURRENT = new DefaultBuildVersion(Version.CURRENT.id());
    final Version version;

    DefaultBuildVersion(int versionId) {
        assert (versionId >= 0) : "Release version IDs must be non-negative integers";
        this.version = Version.fromId(versionId);
    }

    DefaultBuildVersion(String version) {
        this.version = Version.fromString(Objects.requireNonNull(version));
    }

    DefaultBuildVersion(StreamInput in) throws IOException {
        this(in.readVInt());
    }

    @Override
    public boolean canRemoveAssumedFeatures() {
        return this.version.major == Version.CURRENT.major + 1;
    }

    @Override
    public boolean onOrAfterMinimumCompatible() {
        return Version.CURRENT.minimumCompatibilityVersion().onOrBefore(this.version);
    }

    @Override
    public boolean isFutureVersion() {
        return Version.CURRENT.before(this.version);
    }

    @Override
    public String toNodeMetadata() {
        return Integer.toString(this.version.id());
    }

    @Override
    public BuildVersion minimumCompatibilityVersion() {
        return DefaultBuildVersion.fromVersionId(this.version.minimumCompatibilityVersion().id);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.version.id());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.version.id());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBuildVersion that = (DefaultBuildVersion)o;
        return this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version.id());
    }

    public String toString() {
        return this.version.toString();
    }
}

