/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentBuilderExtension;

public class XContentElasticsearchExtension
implements XContentBuilderExtension {
    public static final DateFormatter DEFAULT_FORMATTER = DateFormatter.forPattern("strict_date_optional_time_nanos");
    public static final DateFormatter LOCAL_TIME_FORMATTER = DateFormatter.forPattern("HH:mm:ss.SSS");
    public static final DateFormatter OFFSET_TIME_FORMATTER = DateFormatter.forPattern("HH:mm:ss.SSSZZZZZ");

    @Override
    public Map<Class<?>, XContentBuilder.Writer> getXContentWriters() {
        HashMap writers = new HashMap();
        writers.put(Version.class, (b, v) -> b.value(Objects.toString(v)));
        writers.put(TimeValue.class, (b, v) -> b.value(v.toString()));
        writers.put(ZonedDateTime.class, XContentBuilder::timestampValue);
        writers.put(OffsetDateTime.class, XContentBuilder::timestampValue);
        writers.put(OffsetTime.class, XContentBuilder::timestampValue);
        writers.put(Instant.class, XContentBuilder::timestampValue);
        writers.put(LocalDateTime.class, XContentBuilder::timestampValue);
        writers.put(LocalDate.class, XContentBuilder::timestampValue);
        writers.put(LocalTime.class, XContentBuilder::timestampValue);
        writers.put(DayOfWeek.class, (b, v) -> b.value(v.toString()));
        writers.put(Month.class, (b, v) -> b.value(v.toString()));
        writers.put(MonthDay.class, (b, v) -> b.value(v.toString()));
        writers.put(Year.class, (b, v) -> b.value(v.toString()));
        writers.put(Duration.class, (b, v) -> b.value(v.toString()));
        writers.put(Period.class, (b, v) -> b.value(v.toString()));
        writers.put(BytesReference.class, (b, v) -> {
            if (v == null) {
                b.nullValue();
            } else {
                BytesRef bytes = ((BytesReference)v).toBytesRef();
                b.value(bytes.bytes, bytes.offset, bytes.length);
            }
        });
        writers.put(BytesRef.class, (b, v) -> {
            if (v == null) {
                b.nullValue();
            } else {
                BytesRef bytes = (BytesRef)v;
                b.value(bytes.bytes, bytes.offset, bytes.length);
            }
        });
        return writers;
    }

    @Override
    public Map<Class<?>, XContentBuilder.HumanReadableTransformer> getXContentHumanReadableTransformers() {
        HashMap transformers = new HashMap();
        transformers.put(TimeValue.class, v -> ((TimeValue)v).millis());
        transformers.put(ByteSizeValue.class, v -> ((ByteSizeValue)v).getBytes());
        return transformers;
    }

    @Override
    public Map<Class<?>, Function<Object, Object>> getDateTransformers() {
        HashMap transformers = new HashMap();
        transformers.put(Date.class, d -> DEFAULT_FORMATTER.format(((Date)d).toInstant()));
        transformers.put(Calendar.class, d -> DEFAULT_FORMATTER.format(((Calendar)d).toInstant()));
        transformers.put(GregorianCalendar.class, d -> DEFAULT_FORMATTER.format(((Calendar)d).toInstant()));
        transformers.put(ZonedDateTime.class, d -> DEFAULT_FORMATTER.format((ZonedDateTime)d));
        transformers.put(OffsetDateTime.class, d -> DEFAULT_FORMATTER.format((OffsetDateTime)d));
        transformers.put(OffsetTime.class, d -> OFFSET_TIME_FORMATTER.format((OffsetTime)d));
        transformers.put(LocalDateTime.class, d -> DEFAULT_FORMATTER.format((LocalDateTime)d));
        transformers.put(Instant.class, d -> DEFAULT_FORMATTER.format(ZonedDateTime.ofInstant((Instant)d, ZoneOffset.UTC)));
        transformers.put(LocalDate.class, d -> ((LocalDate)d).toString());
        transformers.put(LocalTime.class, d -> LOCAL_TIME_FORMATTER.format((LocalTime)d));
        return transformers;
    }

    @Override
    public String formatUnixEpochMillis(long unixEpochMillis) {
        return DEFAULT_FORMATTER.format(Instant.ofEpochMilli(unixEpochMillis));
    }
}

