/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.elasticsearch.common.lucene.search.AutomatonQueries;

public class CaseInsensitiveTermQuery
extends AutomatonQuery {
    public CaseInsensitiveTermQuery(Term term) {
        super(term, AutomatonQueries.toCaseInsensitiveString(term.bytes()));
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('{');
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(':');
        }
        buffer.append(this.term.text());
        buffer.append('}');
        return buffer.toString();
    }
}

