/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.IntSupplier;

public class TruncatedOutputStream
extends FilterOutputStream {
    private final IntSupplier currentSizeSupplier;
    private final int maxSize;
    private boolean hasCapacity = true;

    public TruncatedOutputStream(OutputStream out, IntSupplier currentSizeSupplier, int maxSize) {
        super(out);
        this.currentSizeSupplier = currentSizeSupplier;
        this.maxSize = maxSize;
    }

    public boolean hasCapacity() {
        if (this.hasCapacity) {
            this.hasCapacity = this.currentSizeSupplier.getAsInt() < this.maxSize;
        }
        return this.hasCapacity;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.hasCapacity()) {
            this.out.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.hasCapacity()) {
            this.out.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.hasCapacity()) {
            this.out.write(b, off, len);
        }
    }
}

