/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.support;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;

public class BlobContainerUtils {
    public static final int MAX_REGISTER_CONTENT_LENGTH = 32;

    private BlobContainerUtils() {
    }

    public static void ensureValidRegisterContent(BytesReference bytesReference) {
        if (bytesReference.length() > 32) {
            String message = "invalid register content with length [" + bytesReference.length() + "]";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
    }

    public static BytesReference getRegisterUsingConsistentRead(InputStream inputStream, String container, String key) throws IOException {
        int read;
        int len = 32;
        int pos = 0;
        byte[] bytes = new byte[len];
        while (len > 0 && (read = inputStream.read(bytes, pos, len)) != -1) {
            len -= read;
            pos += read;
        }
        if (inputStream.read() != -1) {
            throw new IllegalStateException(Strings.format("[%s] failed reading register [%s] due to unexpected trailing data", container, key));
        }
        return new BytesArray(bytes, 0, pos);
    }
}

