/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoSimulator;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceInput;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.time.TimeProvider;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;

public class DesiredBalanceComputer {
    private static final Logger logger = LogManager.getLogger(DesiredBalanceComputer.class);
    private static final Logger allocationExplainLogger = LogManager.getLogger((String)(DesiredBalanceComputer.class.getCanonicalName() + ".allocation_explain"));
    private final ShardsAllocator delegateAllocator;
    private final TimeProvider timeProvider;
    private final DesiredBalanceShardsAllocator.ShardAllocationExplainer shardAllocationExplainer;
    protected final MeanMetric iterations = new MeanMetric();
    public static final Setting<TimeValue> PROGRESS_LOG_INTERVAL_SETTING = Setting.timeSetting("cluster.routing.allocation.desired_balance.progress_log_interval", TimeValue.timeValueMinutes(1L), TimeValue.ZERO, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> MAX_BALANCE_COMPUTATION_TIME_DURING_INDEX_CREATION_SETTING = Setting.timeSetting("cluster.routing.allocation.desired_balance.max_balance_computation_time_during_index_creation", TimeValue.timeValueSeconds(1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private TimeValue progressLogInterval;
    private long maxBalanceComputationTimeDuringIndexCreationMillis;
    private long numComputeCallsSinceLastConverged;
    private long numIterationsSinceLastConverged;
    private long lastConvergedTimeMillis;
    private long lastNotConvergedLogMessageTimeMillis;
    private long firstComputeStartedSinceConvergedTimeMillis;
    private boolean lastComputeRunConverged;
    private Level convergenceLogMsgLevel;
    private ShardRouting lastTrackedUnassignedShard;

    public DesiredBalanceComputer(ClusterSettings clusterSettings, TimeProvider timeProvider, ShardsAllocator delegateAllocator, DesiredBalanceShardsAllocator.ShardAllocationExplainer shardAllocationExplainer) {
        this.delegateAllocator = delegateAllocator;
        this.timeProvider = timeProvider;
        this.shardAllocationExplainer = shardAllocationExplainer;
        this.numComputeCallsSinceLastConverged = 0L;
        this.numIterationsSinceLastConverged = 0L;
        this.lastNotConvergedLogMessageTimeMillis = this.lastConvergedTimeMillis = timeProvider.relativeTimeInMillis();
        this.firstComputeStartedSinceConvergedTimeMillis = this.lastConvergedTimeMillis;
        this.lastComputeRunConverged = true;
        this.convergenceLogMsgLevel = Level.DEBUG;
        clusterSettings.initializeAndWatch(PROGRESS_LOG_INTERVAL_SETTING, value -> {
            this.progressLogInterval = value;
        });
        clusterSettings.initializeAndWatch(MAX_BALANCE_COMPUTATION_TIME_DURING_INDEX_CREATION_SETTING, value -> {
            this.maxBalanceComputationTimeDuringIndexCreationMillis = value.millis();
        });
    }

    public DesiredBalance compute(DesiredBalance previousDesiredBalance, DesiredBalanceInput desiredBalanceInput, Queue<List<MoveAllocationCommand>> pendingDesiredBalanceMoves, Predicate<DesiredBalanceInput> isFresh) {
        List<MoveAllocationCommand> commands;
        ++this.numComputeCallsSinceLastConverged;
        if (logger.isTraceEnabled()) {
            logger.trace("Recomputing desired balance for [{}]: {}, {}, {}, {}", (Object)desiredBalanceInput.index(), (Object)previousDesiredBalance, (Object)desiredBalanceInput.routingAllocation().routingNodes().toString(), (Object)desiredBalanceInput.routingAllocation().clusterInfo().toString(), (Object)desiredBalanceInput.routingAllocation().snapshotShardSizeInfo().toString());
        } else {
            logger.debug("Recomputing desired balance for [{}]", (Object)desiredBalanceInput.index());
        }
        RoutingAllocation routingAllocation = desiredBalanceInput.routingAllocation().mutableCloneForSimulation();
        RoutingNodes routingNodes = routingAllocation.routingNodes();
        Set<String> knownNodeIds = routingNodes.getAllNodeIds();
        RoutingChangesObserver changes = routingAllocation.changes();
        Set<ShardRouting> ignoredShards = DesiredBalanceComputer.getIgnoredShardsWithDiscardedAllocationStatus(desiredBalanceInput.ignoredShards());
        ClusterInfoSimulator clusterInfoSimulator = new ClusterInfoSimulator(routingAllocation);
        DesiredBalance.ComputationFinishReason finishReason = DesiredBalance.ComputationFinishReason.CONVERGED;
        if (routingNodes.size() == 0) {
            return new DesiredBalance(desiredBalanceInput.index(), Map.of(), Map.of(), finishReason);
        }
        DesiredBalanceComputer.maybeSimulateAlreadyStartedShards(desiredBalanceInput.routingAllocation().clusterInfo(), routingNodes, clusterInfoSimulator);
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shardRouting : routingNode) {
                if (!shardRouting.initializing()) continue;
                clusterInfoSimulator.simulateShardStarted(shardRouting);
                routingNodes.startShard(shardRouting, changes, 0L);
            }
        }
        HashSet<ShardId> unassignedPrimaries = new HashSet<ShardId>();
        HashMap<ShardId, ShardRoutings> shardRoutings = new HashMap<ShardId, ShardRoutings>();
        for (Object primary2 : (Iterator<Map.Entry<ShardId, List<ShardRouting>>>)new boolean[]{true, false}) {
            RoutingNodes.UnassignedShards unassigned = routingNodes.unassigned();
            RoutingNodes.UnassignedShards.UnassignedIterator iterator = unassigned.iterator();
            while (iterator.hasNext()) {
                ShardRouting shardRouting = iterator.next();
                if (shardRouting.primary() != primary2) continue;
                String lastAllocatedNodeId = shardRouting.unassignedInfo().lastAllocatedNodeId();
                if (knownNodeIds.contains(lastAllocatedNodeId) || !ignoredShards.contains(DesiredBalanceComputer.discardAllocationStatus(shardRouting))) {
                    shardRoutings.computeIfAbsent(shardRouting.shardId(), ShardRoutings::new).unassigned().add(shardRouting);
                    continue;
                }
                iterator.removeAndIgnore(UnassignedInfo.AllocationStatus.NO_ATTEMPT, changes);
                if (!shardRouting.primary()) continue;
                unassignedPrimaries.add(shardRouting.shardId());
            }
        }
        for (Map.Entry<ShardId, List<ShardRouting>> assigned : routingNodes.getAssignedShards().entrySet()) {
            shardRoutings.computeIfAbsent(assigned.getKey(), ShardRoutings::new).assigned().addAll((Collection<ShardRouting>)assigned.getValue());
        }
        HashMap<ShardRouting, LinkedList> unassignedShardsToInitialize = new HashMap<ShardRouting, LinkedList>();
        block7: for (Map.Entry entry : shardRoutings.entrySet()) {
            Object shardRouting2;
            ShardId shardId = (ShardId)entry.getKey();
            ShardRoutings routings = (ShardRoutings)entry.getValue();
            TreeMap<String, Iterator<ShardRouting>> shardsToRelocate = new TreeMap<String, Iterator<ShardRouting>>();
            ShardAssignment assignment = previousDesiredBalance.getAssignment(shardId);
            TreeSet<String> targetNodes = assignment != null ? new TreeSet<String>(assignment.nodeIds()) : new TreeSet();
            targetNodes.retainAll(knownNodeIds);
            for (Object shardRouting2 : routings.unassigned()) {
                String lastAllocatedNodeId = ((ShardRouting)shardRouting2).unassignedInfo().lastAllocatedNodeId();
                if (!knownNodeIds.contains(lastAllocatedNodeId)) continue;
                targetNodes.add(lastAllocatedNodeId);
            }
            for (Object shardRouting2 : routings.assigned()) {
                assert (((ShardRouting)shardRouting2).started());
                if (targetNodes.remove(((ShardRouting)shardRouting2).currentNodeId())) continue;
                ShardRouting previousShard = (ShardRouting)((Object)shardsToRelocate.put(((ShardRouting)shardRouting2).currentNodeId(), (Iterator<ShardRouting>)shardRouting2));
                assert (previousShard == null) : "duplicate shards to relocate: " + String.valueOf(shardRouting2) + " vs " + String.valueOf(previousShard);
            }
            Iterator<String> targetNodesIterator = targetNodes.iterator();
            block10: for (ShardRouting shardRouting3 : shardsToRelocate.values()) {
                assert (shardRouting3.started());
                while (targetNodesIterator.hasNext()) {
                    String targetNodeId = targetNodesIterator.next();
                    RoutingNode targetNode = routingNodes.node(targetNodeId);
                    if (targetNode == null || routingAllocation.deciders().canAllocate(shardRouting3, targetNode, routingAllocation).type() == Decision.Type.NO) continue;
                    ShardRouting shardToRelocate = routingNodes.relocateShard(shardRouting3, targetNodeId, 0L, "computation", changes).v2();
                    clusterInfoSimulator.simulateShardStarted(shardToRelocate);
                    routingNodes.startShard(shardToRelocate, changes, 0L);
                    continue block10;
                }
            }
            shardRouting2 = routings.unassigned().iterator();
            while (shardRouting2.hasNext()) {
                ShardRouting shardRouting3;
                shardRouting3 = shardRouting2.next();
                assert (shardRouting3.unassigned());
                if (!targetNodesIterator.hasNext()) continue block7;
                unassignedShardsToInitialize.computeIfAbsent(shardRouting3, ignored -> new LinkedList()).add(targetNodesIterator.next());
            }
        }
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedPrimaryIterator = routingNodes.unassigned().iterator();
        while (unassignedPrimaryIterator.hasNext()) {
            String nodeId;
            RoutingNode routingNode;
            LinkedList nodeIds;
            ShardRouting shardRouting = unassignedPrimaryIterator.next();
            if (!shardRouting.primary() || (nodeIds = (LinkedList)unassignedShardsToInitialize.get(shardRouting)) == null || nodeIds.isEmpty() || (routingNode = routingNodes.node(nodeId = (String)nodeIds.removeFirst())) == null || routingAllocation.deciders().canAllocate(shardRouting, routingNode, routingAllocation).type() == Decision.Type.NO) continue;
            ShardRouting shardToInitialize = unassignedPrimaryIterator.initialize(nodeId, null, 0L, changes);
            clusterInfoSimulator.simulateShardStarted(shardToInitialize);
            routingNodes.startShard(shardToInitialize, changes, 0L);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedReplicaIterator = routingNodes.unassigned().iterator();
        while (unassignedReplicaIterator.hasNext()) {
            String nodeId;
            RoutingNode routingNode;
            Object nodeIds;
            ShardRouting shardRouting = unassignedReplicaIterator.next();
            if (unassignedPrimaries.contains(shardRouting.shardId()) || (nodeIds = (LinkedList)unassignedShardsToInitialize.get(shardRouting)) == null || ((AbstractCollection)nodeIds).isEmpty() || (routingNode = routingNodes.node(nodeId = (String)((LinkedList)nodeIds).removeFirst())) == null || routingAllocation.deciders().canAllocate(shardRouting, routingNode, routingAllocation).type() == Decision.Type.NO) continue;
            ShardRouting shardToInitialize = unassignedReplicaIterator.initialize(nodeId, null, 0L, changes);
            clusterInfoSimulator.simulateShardStarted(shardToInitialize);
            routingNodes.startShard(shardToInitialize, changes, 0L);
        }
        while ((commands = pendingDesiredBalanceMoves.poll()) != null) {
            for (MoveAllocationCommand command : commands) {
                try {
                    RerouteExplanation rerouteExplanation = command.execute(routingAllocation, false);
                    assert (rerouteExplanation.decisions().type() != Decision.Type.NO) : "should have thrown for NO decision";
                    if (rerouteExplanation.decisions().type() == Decision.Type.NO) continue;
                    Iterator<ShardRouting> initializingShardsIterator = routingNodes.node(routingAllocation.nodes().resolveNode(command.toNode()).getId()).initializing().iterator();
                    assert (initializingShardsIterator.hasNext());
                    ShardRouting initializingShard = initializingShardsIterator.next();
                    assert (!initializingShardsIterator.hasNext()) : "expect exactly one relocating shard, but got: " + String.valueOf(Iterators.toList(Iterators.concat(Iterators.single(initializingShard), initializingShardsIterator)));
                    assert (routingAllocation.nodes().resolveNode(command.fromNode()).getId().equals(initializingShard.relocatingNodeId())) : String.valueOf(initializingShard) + " has unexpected relocation source node, expect node " + String.valueOf(routingAllocation.nodes().resolveNode(command.fromNode()));
                    clusterInfoSimulator.simulateShardStarted(initializingShard);
                    routingNodes.startShard(initializingShard, changes, 0L);
                }
                catch (RuntimeException e) {
                    logger.debug(() -> "move shard [" + command.index() + ":" + command.shardId() + "] command failed during applying it to the desired balance", (Throwable)e);
                }
            }
        }
        int iterationCountReportInterval = DesiredBalanceComputer.computeIterationCountReportInterval(routingAllocation);
        long timeWarningInterval = this.progressLogInterval.millis();
        long computationStartedTime = this.timeProvider.relativeTimeInMillis();
        if (this.lastComputeRunConverged) {
            this.firstComputeStartedSinceConvergedTimeMillis = computationStartedTime;
            this.lastComputeRunConverged = false;
        }
        long nextReportTime = Math.max(this.lastNotConvergedLogMessageTimeMillis, this.firstComputeStartedSinceConvergedTimeMillis) + timeWarningInterval;
        int i = 0;
        boolean hasChanges = false;
        boolean assignedNewlyCreatedPrimaryShards = false;
        while (true) {
            Level logLevel;
            boolean reportByIterationCount;
            if (hasChanges) {
                routingNodes.unassigned().resetIgnored();
                Iterator<ShardRouting> iterator = routingNodes.unassigned().iterator();
                while (((RoutingNodes.UnassignedShards.UnassignedIterator)iterator).hasNext()) {
                    ShardRouting shardRouting = ((RoutingNodes.UnassignedShards.UnassignedIterator)iterator).next();
                    if (!ignoredShards.contains(DesiredBalanceComputer.discardAllocationStatus(shardRouting))) continue;
                    ((RoutingNodes.UnassignedShards.UnassignedIterator)iterator).removeAndIgnore(UnassignedInfo.AllocationStatus.NO_ATTEMPT, changes);
                }
            }
            routingAllocation.setSimulatedClusterInfo(clusterInfoSimulator.getClusterInfo());
            logger.trace("running delegate allocator");
            this.delegateAllocator.allocate(routingAllocation);
            assert (routingNodes.unassigned().isEmpty());
            hasChanges = false;
            for (RoutingNode routingNode : routingNodes) {
                for (ShardRouting shardRouting : routingNode) {
                    if (!shardRouting.initializing()) continue;
                    hasChanges = true;
                    if (shardRouting.primary() && shardRouting.unassignedInfo() != null && shardRouting.unassignedInfo().reason() == UnassignedInfo.Reason.INDEX_CREATED) {
                        assignedNewlyCreatedPrimaryShards = true;
                    }
                    clusterInfoSimulator.simulateShardStarted(shardRouting);
                    routingNodes.startShard(shardRouting, changes, 0L);
                }
            }
            ++this.numIterationsSinceLastConverged;
            int iterations = ++i;
            long currentTime = this.timeProvider.relativeTimeInMillis();
            boolean reportByTime = nextReportTime <= currentTime;
            boolean bl = reportByIterationCount = this.numIterationsSinceLastConverged % (long)iterationCountReportInterval == 0L;
            if (reportByTime || reportByIterationCount) {
                nextReportTime = currentTime + timeWarningInterval;
            }
            if (!hasChanges && this.hasEnoughIterations(i)) {
                if (this.numComputeCallsSinceLastConverged > 1L) {
                    logger.log(this.convergenceLogMsgLevel, () -> Strings.format("Desired balance computation for [%d] converged after [%s] and [%d] iterations, resumed computation [%d] times with [%d] iterations since the last resumption [%s] ago", desiredBalanceInput.index(), TimeValue.timeValueMillis(currentTime - this.firstComputeStartedSinceConvergedTimeMillis).toString(), this.numIterationsSinceLastConverged, this.numComputeCallsSinceLastConverged, iterations, TimeValue.timeValueMillis(currentTime - computationStartedTime).toString()));
                } else {
                    logger.log(this.convergenceLogMsgLevel, () -> Strings.format("Desired balance computation for [%d] converged after [%s] and [%d] iterations", desiredBalanceInput.index(), TimeValue.timeValueMillis(currentTime - this.firstComputeStartedSinceConvergedTimeMillis).toString(), this.numIterationsSinceLastConverged));
                }
                this.numComputeCallsSinceLastConverged = 0L;
                this.numIterationsSinceLastConverged = 0L;
                this.lastConvergedTimeMillis = currentTime;
                this.lastComputeRunConverged = true;
                break;
            }
            if (!isFresh.test(desiredBalanceInput)) {
                logger.debug("Desired balance computation for [{}] interrupted after [{}] and [{}] iterations as newer cluster state received. Publishing intermediate desired balance and restarting computation", (Object)desiredBalanceInput.index(), (Object)TimeValue.timeValueMillis(currentTime - computationStartedTime).toString(), (Object)i);
                finishReason = DesiredBalance.ComputationFinishReason.YIELD_TO_NEW_INPUT;
                break;
            }
            if (assignedNewlyCreatedPrimaryShards && currentTime - computationStartedTime >= this.maxBalanceComputationTimeDuringIndexCreationMillis) {
                logger.info("Desired balance computation for [{}] interrupted after [{}] and [{}] iterations in order to not delay assignment of newly created index shards for more than [{}]. Publishing intermediate desired balance and restarting computation", (Object)desiredBalanceInput.index(), (Object)TimeValue.timeValueMillis(currentTime - computationStartedTime).toString(), (Object)i, (Object)TimeValue.timeValueMillis(this.maxBalanceComputationTimeDuringIndexCreationMillis).toString());
                finishReason = DesiredBalance.ComputationFinishReason.STOP_EARLY;
                break;
            }
            Level level = reportByIterationCount || reportByTime ? Level.INFO : (logLevel = i % 100 == 0 ? Level.DEBUG : Level.TRACE);
            if (this.numComputeCallsSinceLastConverged > 1L) {
                logger.log(logLevel, () -> Strings.format("Desired balance computation for [%d] is still not converged after [%s] and [%d] iterations, resumed computation [%d] times with [%d] iterations since the last resumption [%s] ago", desiredBalanceInput.index(), TimeValue.timeValueMillis(currentTime - this.firstComputeStartedSinceConvergedTimeMillis).toString(), this.numIterationsSinceLastConverged, this.numComputeCallsSinceLastConverged, iterations, TimeValue.timeValueMillis(currentTime - computationStartedTime).toString()));
            } else {
                logger.log(logLevel, () -> Strings.format("Desired balance computation for [%d] is still not converged after [%s] and [%d] iterations", desiredBalanceInput.index(), TimeValue.timeValueMillis(currentTime - this.firstComputeStartedSinceConvergedTimeMillis).toString(), this.numIterationsSinceLastConverged));
            }
            if (!reportByIterationCount && !reportByTime) continue;
            this.lastNotConvergedLogMessageTimeMillis = currentTime;
        }
        this.iterations.inc(i);
        Map<ShardId, ShardAssignment> assignments = DesiredBalanceComputer.collectShardAssignments(routingNodes);
        for (ShardRouting shard : routingNodes.unassigned().ignored()) {
            UnassignedInfo info = shard.unassignedInfo();
            assert (info != null && (info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO || info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.NO_ATTEMPT || info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED)) : "Unexpected stats in: " + String.valueOf(info);
            if (!hasChanges && info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED) {
                assert (ignoredShards.contains(DesiredBalanceComputer.discardAllocationStatus(shard)) || ignoredShards.stream().filter(ShardRouting::primary).anyMatch(primary -> primary.shardId().equals(shard.shardId()))) : "ignored shard " + String.valueOf(shard) + " unexpectedly has THROTTLE status and no counterpart in the provided ignoredShards set " + String.valueOf(ignoredShards);
                hasChanges = true;
            }
            int ignored2 = shard.unassignedInfo().lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO ? 0 : 1;
            assignments.compute(shard.shardId(), (key, oldValue) -> oldValue == null ? new ShardAssignment(Set.of(), 1, 1, ignored2) : new ShardAssignment(oldValue.nodeIds(), oldValue.total() + 1, oldValue.unassigned() + 1, oldValue.ignored() + ignored2));
        }
        this.maybeLogAllocationExplainForUnassigned(finishReason, routingNodes, routingAllocation, desiredBalanceInput.index());
        long lastConvergedIndex = hasChanges ? previousDesiredBalance.lastConvergedIndex() : desiredBalanceInput.index();
        return new DesiredBalance(lastConvergedIndex, assignments, routingNodes.getBalanceWeightStatsPerNode(), finishReason);
    }

    static void maybeSimulateAlreadyStartedShards(ClusterInfo clusterInfo, RoutingNodes routingNodes, ClusterInfoSimulator clusterInfoSimulator) {
        ArrayList<ShardRouting> startedShards = new ArrayList<ShardRouting>();
        for (RoutingNode routingNode2 : routingNodes) {
            for (ShardRouting shardRouting : routingNode2.started()) {
                if (!clusterInfo.hasShardMoved(shardRouting)) continue;
                startedShards.add(shardRouting);
            }
        }
        if (startedShards.isEmpty()) {
            return;
        }
        logger.debug("Found [{}] started shards not accounted in ClusterInfo. The first one is {}", (Object)startedShards.size(), startedShards.getFirst());
        HashMap<ShardId, Set> alreadySeenSourceNodes = new HashMap<ShardId, Set>();
        for (ShardRouting startedShard : startedShards) {
            String sourceNodeId = clusterInfo.getNodeIdsForShard(startedShard.shardId()).stream().filter(nodeId -> !alreadySeenSourceNodes.getOrDefault(startedShard.shardId(), Set.of()).contains(nodeId)).map(routingNodes::node).filter(routingNode -> routingNode != null && routingNode.getByShardId(startedShard.shardId()) == null).map(RoutingNode::node).filter(node -> {
                boolean bl;
                block8: {
                    block7: {
                        if (node == null) break block7;
                        switch (startedShard.role()) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case DEFAULT: {
                                if (node.canContainData()) {
                                    break;
                                }
                                break block7;
                            }
                            case INDEX_ONLY: {
                                if (node.getRoles().contains(DiscoveryNodeRole.INDEX_ROLE)) {
                                    break;
                                }
                                break block7;
                            }
                            case SEARCH_ONLY: {
                                if (!node.getRoles().contains(DiscoveryNodeRole.SEARCH_ROLE)) break block7;
                            }
                        }
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                return bl;
            }).map(DiscoveryNode::getId).findFirst().orElse(null);
            if (sourceNodeId != null) {
                alreadySeenSourceNodes.computeIfAbsent(startedShard.shardId(), k -> new HashSet()).add(sourceNodeId);
            }
            clusterInfoSimulator.simulateAlreadyStartedShard(startedShard, sourceNodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLogAllocationExplainForUnassigned(DesiredBalance.ComputationFinishReason finishReason, RoutingNodes routingNodes, RoutingAllocation routingAllocation, long inputIndex) {
        if (allocationExplainLogger.isDebugEnabled()) {
            ClusterState clusterState = routingAllocation.getClusterState();
            if (clusterState.metadata().nodeShutdowns().contains(clusterState.nodes().getLocalNodeId())) {
                return;
            }
            if (this.lastTrackedUnassignedShard != null) {
                if (Stream.concat(routingNodes.unassigned().stream(), routingNodes.unassigned().ignored().stream()).noneMatch(shardRouting -> shardRouting.equals(this.lastTrackedUnassignedShard))) {
                    allocationExplainLogger.debug("computation for input index [{}] assigned previously tracked unassigned shard [{}]", (Object)inputIndex, (Object)this.lastTrackedUnassignedShard);
                    this.lastTrackedUnassignedShard = null;
                } else {
                    return;
                }
            }
            assert (this.lastTrackedUnassignedShard == null) : "unexpected non-null lastTrackedUnassignedShard " + String.valueOf(this.lastTrackedUnassignedShard);
            if (routingNodes.hasUnassignedShards() && finishReason == DesiredBalance.ComputationFinishReason.CONVERGED) {
                ShardAllocationDecision shardAllocationDecision;
                Predicate<ShardRouting> predicate = routingNodes.hasUnassignedPrimaries() ? ShardRouting::primary : shard -> true;
                this.lastTrackedUnassignedShard = Stream.concat(routingNodes.unassigned().stream(), routingNodes.unassigned().ignored().stream()).filter(predicate).findFirst().orElseThrow();
                RoutingAllocation.DebugMode originalDebugMode = routingAllocation.getDebugMode();
                routingAllocation.setDebugMode(RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
                try {
                    shardAllocationDecision = this.shardAllocationExplainer.explain(this.lastTrackedUnassignedShard, routingAllocation);
                }
                finally {
                    routingAllocation.setDebugMode(originalDebugMode);
                }
                allocationExplainLogger.debug("computation converged for input index [{}] with unassigned shard [{}] due to allocation decision {}", (Object)inputIndex, (Object)this.lastTrackedUnassignedShard, (Object)org.elasticsearch.common.Strings.toString(p -> ChunkedToXContentHelper.object("node_allocation_decision", shardAllocationDecision.toXContentChunked(p))));
            }
        } else if (this.lastTrackedUnassignedShard != null) {
            this.lastTrackedUnassignedShard = null;
        }
    }

    boolean hasEnoughIterations(int currentIteration) {
        return true;
    }

    private static Map<ShardId, ShardAssignment> collectShardAssignments(RoutingNodes routingNodes) {
        Set<Map.Entry<ShardId, List<ShardRouting>>> allAssignedShards = routingNodes.getAssignedShards().entrySet();
        assert (allAssignedShards.stream().flatMap(t -> ((List)t.getValue()).stream()).allMatch(ShardRouting::started)) : routingNodes;
        Map<ShardId, ShardAssignment> res = Maps.newHashMapWithExpectedSize(allAssignedShards.size());
        for (Map.Entry<ShardId, List<ShardRouting>> shardIdAndShardRoutings : allAssignedShards) {
            res.put(shardIdAndShardRoutings.getKey(), ShardAssignment.createFromAssignedShardRoutingsList(shardIdAndShardRoutings.getValue()));
        }
        return res;
    }

    private static Set<ShardRouting> getIgnoredShardsWithDiscardedAllocationStatus(List<ShardRouting> ignoredShards) {
        return ignoredShards.stream().map(DesiredBalanceComputer::discardAllocationStatus).collect(Collectors.toUnmodifiableSet());
    }

    private static ShardRouting discardAllocationStatus(ShardRouting shardRouting) {
        return shardRouting.updateUnassigned(DesiredBalanceComputer.discardAllocationStatus(shardRouting.unassignedInfo()), shardRouting.recoverySource());
    }

    private static UnassignedInfo discardAllocationStatus(UnassignedInfo info) {
        if (info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.NO_ATTEMPT) {
            return info;
        }
        return new UnassignedInfo(info.reason(), info.message(), info.failure(), info.failedAllocations(), info.unassignedTimeNanos(), info.unassignedTimeMillis(), info.delayed(), UnassignedInfo.AllocationStatus.NO_ATTEMPT, info.failedNodeIds(), info.lastAllocatedNodeId());
    }

    private static int computeIterationCountReportInterval(RoutingAllocation allocation) {
        int iterations;
        int relativeSize = allocation.metadata().getTotalNumberOfShards();
        for (iterations = 1000; iterations < relativeSize && iterations < 1000000000; iterations *= 10) {
        }
        return iterations;
    }

    long getNumComputeCallsSinceLastConverged() {
        return this.numComputeCallsSinceLastConverged;
    }

    long getNumIterationsSinceLastConverged() {
        return this.numIterationsSinceLastConverged;
    }

    long getLastConvergedTimeMillis() {
        return this.lastConvergedTimeMillis;
    }

    void setConvergenceLogMsgLevel(Level level) {
        this.convergenceLogMsgLevel = level;
    }

    private record ShardRoutings(List<ShardRouting> unassigned, List<ShardRouting> assigned) {
        private ShardRoutings(ShardId ignored) {
            this(new ArrayList<ShardRouting>(), new ArrayList<ShardRouting>());
        }
    }
}

