/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;

public class IndexBalanceConstraintSettings {
    private static final String SETTING_PREFIX = "cluster.routing.allocation.index_balance_decider.";
    public static final Setting<Boolean> INDEX_BALANCE_DECIDER_ENABLED_SETTING = Setting.boolSetting("cluster.routing.allocation.index_balance_decider.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDEX_BALANCE_DECIDER_EXCESS_SHARDS = Setting.intSetting("cluster.routing.allocation.index_balance_decider.excess_shards", 0, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean deciderEnabled;
    private volatile int excessShards;

    public IndexBalanceConstraintSettings(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(INDEX_BALANCE_DECIDER_ENABLED_SETTING, enabled -> {
            this.deciderEnabled = enabled;
        });
        clusterSettings.initializeAndWatch(INDEX_BALANCE_DECIDER_EXCESS_SHARDS, value -> {
            this.excessShards = value;
        });
    }

    public boolean isDeciderEnabled() {
        return this.deciderEnabled;
    }

    public int getExcessShards() {
        return this.excessShards;
    }
}

