/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentString;

public class RoutingHashBuilder {
    private final List<NameAndHash> hashes = new ArrayList<NameAndHash>();
    private final Predicate<String> isRoutingPath;

    public RoutingHashBuilder(Predicate<String> isRoutingPath) {
        this.isRoutingPath = isRoutingPath;
    }

    public void addMatching(String fieldName, BytesRef string) {
        if (this.isRoutingPath.test(fieldName)) {
            this.addHash(fieldName, string);
        }
    }

    public String createId(byte[] suffix, IntSupplier onEmpty) {
        byte[] idBytes = new byte[4 + suffix.length];
        ByteUtils.writeIntLE(this.buildHash(onEmpty), idBytes, 0);
        System.arraycopy(suffix, 0, idBytes, 4, suffix.length);
        return Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(idBytes);
    }

    void extractObject(@Nullable String path, XContentParser source) throws IOException {
        while (source.currentToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, source.currentToken(), source);
            String fieldName = source.currentName();
            String subPath = path == null ? fieldName : path + "." + fieldName;
            source.nextToken();
            this.extractItem(subPath, source);
        }
    }

    private void extractArray(@Nullable String path, XContentParser source) throws IOException {
        while (source.currentToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.expectValueToken(source.currentToken(), source);
            this.extractItem(path, source);
        }
    }

    private void extractItem(String path, XContentParser source) throws IOException {
        switch (source.currentToken()) {
            case START_OBJECT: {
                source.nextToken();
                this.extractObject(path, source);
                source.nextToken();
                break;
            }
            case VALUE_STRING: 
            case VALUE_NUMBER: 
            case VALUE_BOOLEAN: {
                XContentString.UTF8Bytes utf8Bytes = source.optimizedText().bytes();
                this.addHash(path, new BytesRef(utf8Bytes.bytes(), utf8Bytes.offset(), utf8Bytes.length()));
                source.nextToken();
                break;
            }
            case START_ARRAY: {
                source.nextToken();
                this.extractArray(path, source);
                source.nextToken();
                break;
            }
            case VALUE_NULL: {
                source.nextToken();
                break;
            }
            default: {
                throw new ParsingException(source.getTokenLocation(), "Cannot extract routing path due to unexpected token [{}]", new Object[]{source.currentToken()});
            }
        }
    }

    private void addHash(String path, BytesRef value) {
        this.hashes.add(new NameAndHash(new BytesRef(path), IndexRouting.ExtractFromSource.hash(value), this.hashes.size()));
    }

    int buildHash(IntSupplier onEmpty) {
        if (this.hashes.isEmpty()) {
            return onEmpty.getAsInt();
        }
        Collections.sort(this.hashes);
        int hash = 0;
        for (NameAndHash nah : this.hashes) {
            hash = 31 * hash + (IndexRouting.ExtractFromSource.hash(nah.name) ^ nah.hash);
        }
        return hash;
    }

    private record NameAndHash(BytesRef name, int hash, int order) implements Comparable<NameAndHash>
    {
        @Override
        public int compareTo(NameAndHash o) {
            int i = this.name.compareTo(o.name);
            if (i != 0) {
                return i;
            }
            return Integer.compare(this.order, o.order);
        }
    }
}

