/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.View;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public final class ViewMetadata
extends AbstractNamedDiffable<Metadata.ProjectCustom>
implements Metadata.ProjectCustom {
    public static final String TYPE = "esql_view";
    public static final List<NamedWriteableRegistry.Entry> ENTRIES = List.of(new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "esql_view", ViewMetadata::readFromStream), new NamedWriteableRegistry.Entry(NamedDiff.class, "esql_view", in -> ViewMetadata.readDiffFrom(Metadata.ProjectCustom.class, TYPE, in)));
    public static final ViewMetadata EMPTY = new ViewMetadata(Collections.emptyMap());
    private static final TransportVersion ESQL_VIEWS = TransportVersion.fromName("esql_views");
    private static final ParseField VIEWS = new ParseField("views", new String[0]);
    private final Map<String, View> views;
    private static final ConstructingObjectParser<ViewMetadata, Void> PARSER = new ConstructingObjectParser<ViewMetadata, Void>("view_metadata", true, (args, ctx) -> new ViewMetadata((Map)args[0]));

    public static ViewMetadata fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public static ViewMetadata readFromStream(StreamInput in) throws IOException {
        return new ViewMetadata(in.readMap(View::new));
    }

    public ViewMetadata(Map<String, View> views) {
        this.views = Collections.unmodifiableMap(views);
    }

    public Map<String, View> views() {
        return this.views;
    }

    @Nullable
    public View getView(String name) {
        return this.views.get(name);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return ESQL_VIEWS;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.views, StreamOutput::writeWriteable);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return ChunkedToXContentHelper.xContentObjectFields(VIEWS.getPreferredName(), this.views);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewMetadata that = (ViewMetadata)o;
        return this.views.equals(that.views);
    }

    public int hashCode() {
        return Objects.hash(this.views);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, View> views = new HashMap<String, View>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String name = p.currentName();
                views.put(name, View.fromXContent(p));
            }
            return views;
        }, VIEWS);
    }
}

