/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class IndexWriteLoad
implements Writeable,
ToXContentFragment {
    public static final ParseField SHARDS_WRITE_LOAD_FIELD = new ParseField("loads", new String[0]);
    public static final ParseField SHARDS_UPTIME_IN_MILLIS = new ParseField("uptimes", new String[0]);
    public static final ParseField SHARDS_RECENT_WRITE_LOAD_FIELD = new ParseField("recent_loads", new String[0]);
    public static final ParseField SHARDS_PEAK_WRITE_LOAD_FIELD = new ParseField("peak_loads", new String[0]);
    private static final Double UNKNOWN_LOAD = -1.0;
    private static final long UNKNOWN_UPTIME = -1L;
    private static final ConstructingObjectParser<IndexWriteLoad, Void> PARSER = new ConstructingObjectParser<IndexWriteLoad, Void>("index_write_load_parser", false, (args, unused) -> IndexWriteLoad.create((List)args[0], (List)args[1], (List)args[2], (List)args[3]));
    private static final TransportVersion INDEX_METADATA_INCLUDES_RECENT_WRITE_LOAD;
    private static final TransportVersion INDEX_STATS_AND_METADATA_INCLUDE_PEAK_WRITE_LOAD;
    private final double[] shardWriteLoad;
    private final long[] shardUptimeInMillis;
    private final double[] shardRecentWriteLoad;
    private final double[] shardPeakWriteLoad;

    private static IndexWriteLoad create(List<Double> shardsWriteLoad, List<Long> shardsUptimeInMillis, @Nullable List<Double> shardsRecentWriteLoad, @Nullable List<Double> shardsPeakWriteLoad) {
        if (shardsWriteLoad.size() != shardsUptimeInMillis.size()) {
            assert (false) : "IndexWriteLoad.create() was called with non-matched lengths for shardWriteLoad and shardUptimeInMillis";
            throw new IllegalArgumentException("The same number of shard write loads and shard uptimes should be provided, but " + String.valueOf(shardsWriteLoad) + " " + String.valueOf(shardsUptimeInMillis) + " were provided");
        }
        if (shardsWriteLoad.isEmpty()) {
            assert (false) : "IndexWriteLoad.create() was called with empty shardsRecentWriteLoad";
            throw new IllegalArgumentException("At least one shard write load and uptime should be provided, but none was provided");
        }
        if (shardsRecentWriteLoad != null && shardsRecentWriteLoad.size() != shardsUptimeInMillis.size()) {
            assert (false) : "IndexWriteLoad.create() was called with non-matched lengths for shardsRecentWriteLoad and shardUptimeInMillis";
            throw new IllegalArgumentException("The same number of shard recent write loads and shard uptimes should be provided, but " + String.valueOf(shardsRecentWriteLoad) + " " + String.valueOf(shardsUptimeInMillis) + " were provided");
        }
        if (shardsPeakWriteLoad != null && shardsPeakWriteLoad.size() != shardsUptimeInMillis.size()) {
            assert (false) : "IndexWriteLoad.create() was called with non-matched lengths for shardsPeakWriteLoad and shardUptimeInMillis";
            throw new IllegalArgumentException("The same number of shard peak write loads and shard uptimes should be provided, but " + String.valueOf(shardsPeakWriteLoad) + " " + String.valueOf(shardsUptimeInMillis) + " were provided");
        }
        return new IndexWriteLoad(shardsWriteLoad.stream().mapToDouble(shardLoad -> shardLoad).toArray(), shardsUptimeInMillis.stream().mapToLong(shardUptime -> shardUptime).toArray(), shardsRecentWriteLoad != null ? shardsRecentWriteLoad.stream().mapToDouble(shardLoad -> shardLoad).toArray() : null, shardsPeakWriteLoad != null ? shardsPeakWriteLoad.stream().mapToDouble(shardLoad -> shardLoad).toArray() : null);
    }

    private IndexWriteLoad(double[] shardWriteLoad, long[] shardUptimeInMillis, @Nullable double[] shardRecentWriteLoad, @Nullable double[] shardPeakWriteLoad) {
        assert (shardWriteLoad.length == shardUptimeInMillis.length) : "IndexWriteLoad constructor was called with non-matched lengths for shardWriteLoad and shardUptimeInMillis";
        this.shardWriteLoad = shardWriteLoad;
        this.shardUptimeInMillis = shardUptimeInMillis;
        if (shardRecentWriteLoad != null) {
            assert (shardRecentWriteLoad.length == shardUptimeInMillis.length) : "IndexWriteLoad constructor was called with non-matched lengths for shardRecentWriteLoad and shardUptimeInMillis";
            this.shardRecentWriteLoad = shardRecentWriteLoad;
        } else {
            this.shardRecentWriteLoad = new double[shardUptimeInMillis.length];
            Arrays.fill(this.shardRecentWriteLoad, UNKNOWN_LOAD);
        }
        if (shardPeakWriteLoad != null) {
            assert (shardPeakWriteLoad.length == shardUptimeInMillis.length) : "IndexWriteLoad constructor was called with non-matched lengths for shardPeakWriteLoad and shardUptimeInMillis";
            this.shardPeakWriteLoad = shardPeakWriteLoad;
        } else {
            this.shardPeakWriteLoad = new double[shardUptimeInMillis.length];
            Arrays.fill(this.shardPeakWriteLoad, UNKNOWN_LOAD);
        }
    }

    public IndexWriteLoad(StreamInput in) throws IOException {
        this(in.readDoubleArray(), in.readLongArray(), in.getTransportVersion().supports(INDEX_METADATA_INCLUDES_RECENT_WRITE_LOAD) ? in.readDoubleArray() : null, in.getTransportVersion().supports(INDEX_STATS_AND_METADATA_INCLUDE_PEAK_WRITE_LOAD) ? in.readDoubleArray() : null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.shardWriteLoad);
        out.writeLongArray(this.shardUptimeInMillis);
        if (out.getTransportVersion().supports(INDEX_METADATA_INCLUDES_RECENT_WRITE_LOAD)) {
            out.writeDoubleArray(this.shardRecentWriteLoad);
        }
        if (out.getTransportVersion().supports(INDEX_STATS_AND_METADATA_INCLUDE_PEAK_WRITE_LOAD)) {
            out.writeDoubleArray(this.shardPeakWriteLoad);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHARDS_WRITE_LOAD_FIELD.getPreferredName(), this.shardWriteLoad);
        builder.field(SHARDS_UPTIME_IN_MILLIS.getPreferredName(), this.shardUptimeInMillis);
        builder.field(SHARDS_RECENT_WRITE_LOAD_FIELD.getPreferredName(), this.shardRecentWriteLoad);
        builder.field(SHARDS_PEAK_WRITE_LOAD_FIELD.getPreferredName(), this.shardPeakWriteLoad);
        return builder;
    }

    public static IndexWriteLoad fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public OptionalDouble getWriteLoadForShard(int shardId) {
        this.assertShardInBounds(shardId);
        double load = this.shardWriteLoad[shardId];
        return load != UNKNOWN_LOAD ? OptionalDouble.of(load) : OptionalDouble.empty();
    }

    public OptionalDouble getRecentWriteLoadForShard(int shardId) {
        this.assertShardInBounds(shardId);
        double load = this.shardRecentWriteLoad[shardId];
        return load != UNKNOWN_LOAD ? OptionalDouble.of(load) : OptionalDouble.empty();
    }

    public OptionalDouble getPeakWriteLoadForShard(int shardId) {
        this.assertShardInBounds(shardId);
        double load = this.shardPeakWriteLoad[shardId];
        return load != UNKNOWN_LOAD ? OptionalDouble.of(load) : OptionalDouble.empty();
    }

    public OptionalLong getUptimeInMillisForShard(int shardId) {
        this.assertShardInBounds(shardId);
        long uptime = this.shardUptimeInMillis[shardId];
        return uptime != -1L ? OptionalLong.of(uptime) : OptionalLong.empty();
    }

    public int numberOfShards() {
        return this.shardWriteLoad.length;
    }

    private void assertShardInBounds(int shardId) {
        assert (shardId >= 0) : "Unexpected shard id " + shardId;
        assert (shardId < this.shardWriteLoad.length) : "Unexpected shard id " + shardId + ", expected < " + this.shardWriteLoad.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexWriteLoad that = (IndexWriteLoad)o;
        return Arrays.equals(this.shardWriteLoad, that.shardWriteLoad) && Arrays.equals(this.shardUptimeInMillis, that.shardUptimeInMillis) && Arrays.equals(this.shardRecentWriteLoad, that.shardRecentWriteLoad) && Arrays.equals(this.shardPeakWriteLoad, that.shardPeakWriteLoad);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.shardWriteLoad);
        result = 31 * result + Arrays.hashCode(this.shardUptimeInMillis);
        result = 31 * result + Arrays.hashCode(this.shardRecentWriteLoad);
        result = 31 * result + Arrays.hashCode(this.shardPeakWriteLoad);
        return result;
    }

    public static Builder builder(int numShards) {
        assert (numShards > 0) : "A positive number of shards should be provided";
        return new Builder(numShards);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), SHARDS_WRITE_LOAD_FIELD);
        PARSER.declareLongArray(ConstructingObjectParser.constructorArg(), SHARDS_UPTIME_IN_MILLIS);
        PARSER.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), SHARDS_RECENT_WRITE_LOAD_FIELD);
        PARSER.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), SHARDS_PEAK_WRITE_LOAD_FIELD);
        INDEX_METADATA_INCLUDES_RECENT_WRITE_LOAD = TransportVersion.fromName("index_metadata_includes_recent_write_load");
        INDEX_STATS_AND_METADATA_INCLUDE_PEAK_WRITE_LOAD = TransportVersion.fromName("index_stats_and_metadata_include_peak_write_load");
    }

    public static class Builder {
        private final double[] shardWriteLoad;
        private final long[] uptimeInMillis;
        private final double[] shardRecentWriteLoad;
        private final double[] shardPeakWriteLoad;

        private Builder(int numShards) {
            this.shardWriteLoad = new double[numShards];
            this.uptimeInMillis = new long[numShards];
            this.shardRecentWriteLoad = new double[numShards];
            this.shardPeakWriteLoad = new double[numShards];
            Arrays.fill(this.shardWriteLoad, UNKNOWN_LOAD);
            Arrays.fill(this.uptimeInMillis, -1L);
            Arrays.fill(this.shardRecentWriteLoad, UNKNOWN_LOAD);
            Arrays.fill(this.shardPeakWriteLoad, UNKNOWN_LOAD);
        }

        public Builder withShardWriteLoad(int shardId, double load, double recentLoad, double peakLoad, long uptimeInMillis) {
            if (shardId >= this.shardWriteLoad.length) {
                throw new IllegalArgumentException();
            }
            this.shardWriteLoad[shardId] = load;
            this.uptimeInMillis[shardId] = uptimeInMillis;
            this.shardRecentWriteLoad[shardId] = recentLoad;
            this.shardPeakWriteLoad[shardId] = peakLoad;
            return this;
        }

        public IndexWriteLoad build() {
            return new IndexWriteLoad(this.shardWriteLoad, this.uptimeInMillis, this.shardRecentWriteLoad, this.shardPeakWriteLoad);
        }
    }
}

