/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class DesiredNode
implements Writeable,
ToXContentObject,
Comparable<DesiredNode> {
    private static final TransportVersion REMOVE_DESIRED_NODE_VERSION = TransportVersion.fromName("remove_desired_node_version");
    private static final ParseField SETTINGS_FIELD = new ParseField("settings", new String[0]);
    private static final ParseField PROCESSORS_FIELD = new ParseField("processors", new String[0]);
    private static final ParseField PROCESSORS_RANGE_FIELD = new ParseField("processors_range", new String[0]);
    private static final ParseField MEMORY_FIELD = new ParseField("memory", new String[0]);
    private static final ParseField STORAGE_FIELD = new ParseField("storage", new String[0]);
    public static final ConstructingObjectParser<DesiredNode, Void> PARSER = new ConstructingObjectParser<DesiredNode, Void>("desired_node", false, (args, name) -> new DesiredNode((Settings)args[0], (Processors)args[1], (ProcessorsRange)args[2], (ByteSizeValue)args[3], (ByteSizeValue)args[4]));
    private final Settings settings;
    private final Processors processors;
    private final ProcessorsRange processorsRange;
    private final ByteSizeValue memory;
    private final ByteSizeValue storage;
    private final String externalId;
    private final Set<DiscoveryNodeRole> roles;

    static <T> void configureParser(ConstructingObjectParser<T, Void> parser) {
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), SETTINGS_FIELD);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Processors.fromXContent(p), PROCESSORS_FIELD, ObjectParser.ValueType.DOUBLE);
        parser.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ProcessorsRange.fromXContent(p), null, PROCESSORS_RANGE_FIELD);
        parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MEMORY_FIELD.getPreferredName()), MEMORY_FIELD, ObjectParser.ValueType.STRING);
        parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), STORAGE_FIELD.getPreferredName()), STORAGE_FIELD, ObjectParser.ValueType.STRING);
    }

    public DesiredNode(Settings settings, ProcessorsRange processorsRange, ByteSizeValue memory, ByteSizeValue storage) {
        this(settings, null, processorsRange, memory, storage);
    }

    public DesiredNode(Settings settings, double processors, ByteSizeValue memory, ByteSizeValue storage) {
        this(settings, Processors.of(processors), null, memory, storage);
    }

    DesiredNode(Settings settings, Processors processors, ProcessorsRange processorsRange, ByteSizeValue memory, ByteSizeValue storage) {
        assert (settings != null);
        assert (memory != null);
        assert (storage != null);
        if (processors == null && processorsRange == null) {
            throw new IllegalArgumentException(PROCESSORS_FIELD.getPreferredName() + " or " + PROCESSORS_RANGE_FIELD.getPreferredName() + " should be specified and none was specified");
        }
        if (processors != null && processorsRange != null) {
            throw new IllegalArgumentException(PROCESSORS_FIELD.getPreferredName() + " and " + PROCESSORS_RANGE_FIELD.getPreferredName() + " were specified, but only one should be specified");
        }
        if (Node.NODE_EXTERNAL_ID_SETTING.get(settings).isBlank()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] or [%s] is missing or empty", Node.NODE_NAME_SETTING.getKey(), Node.NODE_EXTERNAL_ID_SETTING.getKey()));
        }
        this.settings = settings;
        this.processors = processors;
        this.processorsRange = processorsRange;
        this.memory = memory;
        this.storage = storage;
        this.externalId = Node.NODE_EXTERNAL_ID_SETTING.get(settings);
        this.roles = Collections.unmodifiableSortedSet(new TreeSet<DiscoveryNodeRole>(DiscoveryNode.getRolesFromSettings(settings)));
    }

    public static DesiredNode readFrom(StreamInput in) throws IOException {
        Settings settings = Settings.readSettingsFromStream(in);
        Processors processors = in.readOptionalWriteable(Processors::readFrom);
        ProcessorsRange processorsRange = in.readOptionalWriteable(ProcessorsRange::readFrom);
        ByteSizeValue memory = ByteSizeValue.readFrom(in);
        ByteSizeValue storage = ByteSizeValue.readFrom(in);
        if (!in.getTransportVersion().supports(REMOVE_DESIRED_NODE_VERSION)) {
            in.readOptionalString();
        }
        return new DesiredNode(settings, processors, processorsRange, memory, storage);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.settings.writeTo(out);
        out.writeOptionalWriteable(this.processors);
        out.writeOptionalWriteable(this.processorsRange);
        this.memory.writeTo(out);
        this.storage.writeTo(out);
        if (!out.getTransportVersion().supports(REMOVE_DESIRED_NODE_VERSION)) {
            out.writeOptionalString(null);
        }
    }

    public static DesiredNode fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SETTINGS_FIELD.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        if (this.processors != null) {
            builder.field(PROCESSORS_FIELD.getPreferredName(), this.processors);
        }
        if (this.processorsRange != null) {
            builder.field(PROCESSORS_RANGE_FIELD.getPreferredName(), this.processorsRange);
        }
        builder.field(MEMORY_FIELD.getPreferredName(), this.memory);
        builder.field(STORAGE_FIELD.getPreferredName(), this.storage);
    }

    public boolean hasMasterRole() {
        return NodeRoleSettings.NODE_ROLES_SETTING.get(this.settings).contains(DiscoveryNodeRole.MASTER_ROLE);
    }

    public Settings settings() {
        return this.settings;
    }

    public Processors minProcessors() {
        if (this.processors != null) {
            return this.processors;
        }
        return this.processorsRange.min();
    }

    public int roundedDownMinProcessors() {
        return this.minProcessors().roundDown();
    }

    @Nullable
    public Processors maxProcessors() {
        if (this.processors != null) {
            return this.processors;
        }
        return this.processorsRange.max();
    }

    public Integer roundedUpMaxProcessors() {
        Processors maxProcessors = this.maxProcessors();
        if (maxProcessors == null) {
            return null;
        }
        return maxProcessors.roundUp();
    }

    @Nullable
    Processors processors() {
        return this.processors;
    }

    @Nullable
    ProcessorsRange processorsRange() {
        return this.processorsRange;
    }

    public ByteSizeValue memory() {
        return this.memory;
    }

    public ByteSizeValue storage() {
        return this.storage;
    }

    public String externalId() {
        return this.externalId;
    }

    public Set<DiscoveryNodeRole> getRoles() {
        return this.roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesiredNode that = (DesiredNode)o;
        return this.equalsWithoutProcessorsSpecification(that) && Objects.equals(this.processorsRange, that.processorsRange) && Objects.equals(this.processors, that.processors);
    }

    private boolean equalsWithoutProcessorsSpecification(DesiredNode that) {
        return Objects.equals(this.settings, that.settings) && Objects.equals(this.memory, that.memory) && Objects.equals(this.storage, that.storage) && Objects.equals(this.externalId, that.externalId) && Objects.equals(this.roles, that.roles);
    }

    public boolean equalsWithProcessorsCloseTo(DesiredNode that) {
        return this.equalsWithoutProcessorsSpecification(that) && Processors.equalsOrCloseTo(this.processors, that.processors) && ProcessorsRange.equalsOrCloseTo(this.processorsRange, that.processorsRange);
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.processors, this.processorsRange, this.memory, this.storage, this.externalId, this.roles);
    }

    @Override
    public int compareTo(DesiredNode o) {
        return this.externalId.compareTo(o.externalId);
    }

    public String toString() {
        return "DesiredNode{settings=" + String.valueOf(this.settings) + ", processors=" + String.valueOf(this.processors) + ", processorsRange=" + String.valueOf(this.processorsRange) + ", memory=" + String.valueOf(this.memory) + ", storage=" + String.valueOf(this.storage) + ", externalId='" + this.externalId + "', roles=" + String.valueOf(this.roles) + "}";
    }

    static {
        DesiredNode.configureParser(PARSER);
    }

    public record ProcessorsRange(Processors min, @Nullable Processors max) implements Writeable,
    ToXContentObject
    {
        private static final ParseField MIN_FIELD = new ParseField("min", new String[0]);
        private static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
        public static final ConstructingObjectParser<ProcessorsRange, String> PROCESSORS_RANGE_PARSER = new ConstructingObjectParser<ProcessorsRange, String>("processors_range", false, (args, name) -> new ProcessorsRange((Processors)args[0], (Processors)args[1]));

        public ProcessorsRange(double min, Double max) {
            this(Processors.of(min), Processors.of(max));
        }

        public ProcessorsRange {
            if (max != null && min.compareTo(max) > 0) {
                throw new IllegalArgumentException("min processors must be less than or equal to max processors and it was: min: " + String.valueOf(min) + " max: " + String.valueOf(max));
            }
        }

        static ProcessorsRange fromXContent(XContentParser parser) throws IOException {
            return PROCESSORS_RANGE_PARSER.parse(parser, null);
        }

        private static ProcessorsRange readFrom(StreamInput in) throws IOException {
            return new ProcessorsRange(Processors.readFrom(in), in.readOptionalWriteable(Processors::readFrom));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.min.writeTo(out);
            out.writeOptionalWriteable(this.max);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MIN_FIELD.getPreferredName(), this.min);
            if (this.max != null) {
                builder.field(MAX_FIELD.getPreferredName(), this.max);
            }
            builder.endObject();
            return builder;
        }

        static boolean equalsOrCloseTo(ProcessorsRange a, ProcessorsRange b) {
            return a == b || a != null && a.equalsOrCloseTo(b);
        }

        boolean equalsOrCloseTo(ProcessorsRange that) {
            return that != null && (this.equals(that) || Processors.equalsOrCloseTo(this.min, that.min) && Processors.equalsOrCloseTo(this.max, that.max));
        }

        static {
            PROCESSORS_RANGE_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> Processors.fromXContent(p), MIN_FIELD, ObjectParser.ValueType.DOUBLE);
            PROCESSORS_RANGE_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Processors.fromXContent(p), MAX_FIELD, ObjectParser.ValueType.DOUBLE);
        }
    }
}

