/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexSource;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequestBuilder;
import org.elasticsearch.action.update.TransportUpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.Requests;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.script.Script;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class UpdateRequestBuilder
extends InstanceShardOperationRequestBuilder<UpdateRequest, UpdateResponse, UpdateRequestBuilder>
implements WriteRequestBuilder<UpdateRequestBuilder> {
    private String id;
    private String routing;
    private Script script;
    private String fetchSourceInclude;
    private String fetchSourceExclude;
    private String[] fetchSourceIncludeArray;
    private String[] fetchSourceExcludeArray;
    private Boolean fetchSource;
    private Integer retryOnConflict;
    private Long version;
    private VersionType versionType;
    private Long ifSeqNo;
    private Long ifPrimaryTerm;
    private ActiveShardCount waitForActiveShards;
    private IndexRequest doc;
    private BytesReference docSourceBytesReference;
    private XContentType docSourceXContentType;
    private IndexRequest upsert;
    private BytesReference upsertSourceBytesReference;
    private XContentType upsertSourceXContentType;
    private Boolean docAsUpsert;
    private Boolean detectNoop;
    private Boolean scriptedUpsert;
    private Boolean requireAlias;
    private WriteRequest.RefreshPolicy refreshPolicy;

    public UpdateRequestBuilder(ElasticsearchClient client) {
        this(client, null, null);
    }

    public UpdateRequestBuilder(ElasticsearchClient client, String index, String id) {
        super(client, TransportUpdateAction.TYPE);
        this.setIndex(index);
        this.setId(id);
    }

    public UpdateRequestBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public UpdateRequestBuilder setRouting(String routing) {
        this.routing = routing;
        return this;
    }

    public UpdateRequestBuilder setScript(Script script) {
        this.script = script;
        return this;
    }

    public UpdateRequestBuilder setFetchSource(@Nullable String include, @Nullable String exclude) {
        this.fetchSourceInclude = include;
        this.fetchSourceExclude = exclude;
        return this;
    }

    public UpdateRequestBuilder setFetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        this.fetchSourceIncludeArray = includes;
        this.fetchSourceExcludeArray = excludes;
        return this;
    }

    public UpdateRequestBuilder setFetchSource(boolean fetchSource) {
        this.fetchSource = fetchSource;
        return this;
    }

    public UpdateRequestBuilder setRetryOnConflict(int retryOnConflict) {
        this.retryOnConflict = retryOnConflict;
        return this;
    }

    public UpdateRequestBuilder setVersion(long version) {
        this.version = version;
        return this;
    }

    public UpdateRequestBuilder setVersionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public UpdateRequestBuilder setIfSeqNo(long seqNo) {
        this.ifSeqNo = seqNo;
        return this;
    }

    public UpdateRequestBuilder setIfPrimaryTerm(long term) {
        this.ifPrimaryTerm = term;
        return this;
    }

    public UpdateRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public UpdateRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public UpdateRequestBuilder setDoc(IndexRequest indexRequest) {
        this.doc = indexRequest;
        return this;
    }

    public UpdateRequestBuilder setDoc(XContentBuilder source) {
        this.docSourceBytesReference = BytesReference.bytes(source);
        this.docSourceXContentType = source.contentType();
        return this;
    }

    public UpdateRequestBuilder setDoc(Map<String, Object> source) {
        return this.setDoc(source, Requests.INDEX_CONTENT_TYPE);
    }

    public UpdateRequestBuilder setDoc(Map<String, Object> source, XContentType contentType) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.setDoc(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public UpdateRequestBuilder setDoc(String source, XContentType xContentType) {
        this.docSourceBytesReference = new BytesArray(source);
        this.docSourceXContentType = xContentType;
        return this;
    }

    public UpdateRequestBuilder setDoc(byte[] source, XContentType xContentType) {
        return this.setDoc(source, 0, source.length, xContentType);
    }

    public UpdateRequestBuilder setDoc(byte[] source, int offset, int length, XContentType xContentType) {
        this.docSourceBytesReference = new BytesArray(source, offset, length);
        this.docSourceXContentType = xContentType;
        return this;
    }

    public UpdateRequestBuilder setDoc(Object ... source) {
        return this.setDoc(Requests.INDEX_CONTENT_TYPE, source);
    }

    public UpdateRequestBuilder setDoc(XContentType xContentType, Object ... source) {
        return this.setDoc(IndexSource.getXContentBuilder(xContentType, source));
    }

    public UpdateRequestBuilder setUpsert(IndexRequest indexRequest) {
        this.upsert = indexRequest;
        return this;
    }

    public UpdateRequestBuilder setUpsert(XContentBuilder source) {
        this.upsertSourceBytesReference = BytesReference.bytes(source);
        this.upsertSourceXContentType = source.contentType();
        return this;
    }

    public UpdateRequestBuilder setUpsert(Map<String, Object> source) {
        return this.setUpsert(source, Requests.INDEX_CONTENT_TYPE);
    }

    public UpdateRequestBuilder setUpsert(Map<String, Object> source, XContentType contentType) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.setUpsert(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public UpdateRequestBuilder setUpsert(String source, XContentType xContentType) {
        this.upsertSourceBytesReference = new BytesArray(source);
        this.upsertSourceXContentType = xContentType;
        return this;
    }

    public UpdateRequestBuilder setUpsert(byte[] source, XContentType xContentType) {
        return this.setUpsert(source, 0, source.length, xContentType);
    }

    public UpdateRequestBuilder setUpsert(byte[] source, int offset, int length, XContentType xContentType) {
        this.upsertSourceBytesReference = new BytesArray(source, offset, length);
        this.upsertSourceXContentType = xContentType;
        return this;
    }

    public UpdateRequestBuilder setUpsert(Object ... source) {
        return this.setUpsert(Requests.INDEX_CONTENT_TYPE, source);
    }

    public UpdateRequestBuilder setUpsert(XContentType xContentType, Object ... source) {
        return this.setUpsert(IndexSource.getXContentBuilder(xContentType, source));
    }

    public UpdateRequestBuilder setDocAsUpsert(boolean shouldUpsertDoc) {
        this.docAsUpsert = shouldUpsertDoc;
        return this;
    }

    public UpdateRequestBuilder setDetectNoop(boolean detectNoop) {
        this.detectNoop = detectNoop;
        return this;
    }

    public UpdateRequestBuilder setScriptedUpsert(boolean scriptedUpsert) {
        this.scriptedUpsert = scriptedUpsert;
        return this;
    }

    public UpdateRequestBuilder setRequireAlias(boolean requireAlias) {
        this.requireAlias = requireAlias;
        return this;
    }

    @Override
    public UpdateRequestBuilder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public UpdateRequestBuilder setRefreshPolicy(String refreshPolicy) {
        this.refreshPolicy = WriteRequest.RefreshPolicy.parse(refreshPolicy);
        return this;
    }

    @Override
    public UpdateRequest request() {
        this.validate();
        UpdateRequest request = new UpdateRequest();
        super.apply(request);
        if (this.id != null) {
            request.id(this.id);
        }
        if (this.routing != null) {
            request.routing(this.routing);
        }
        if (this.script != null) {
            request.script(this.script);
        }
        if (this.fetchSourceInclude != null || this.fetchSourceExclude != null) {
            request.fetchSource(this.fetchSourceInclude, this.fetchSourceExclude);
        }
        if (this.fetchSourceIncludeArray != null || this.fetchSourceExcludeArray != null) {
            request.fetchSource(this.fetchSourceIncludeArray, this.fetchSourceExcludeArray);
        }
        if (this.fetchSource != null) {
            request.fetchSource(this.fetchSource);
        }
        if (this.retryOnConflict != null) {
            request.retryOnConflict(this.retryOnConflict);
        }
        if (this.version != null) {
            request.version(this.version);
        }
        if (this.versionType != null) {
            request.versionType(this.versionType);
        }
        if (this.ifSeqNo != null) {
            request.setIfSeqNo(this.ifSeqNo);
        }
        if (this.ifPrimaryTerm != null) {
            request.setIfPrimaryTerm(this.ifPrimaryTerm);
        }
        if (this.waitForActiveShards != null) {
            request.waitForActiveShards(this.waitForActiveShards);
        }
        if (this.doc != null) {
            request.doc(this.doc);
        }
        if (this.docSourceBytesReference != null && this.docSourceXContentType != null) {
            request.doc(this.docSourceBytesReference, this.docSourceXContentType);
        }
        if (this.upsert != null) {
            request.upsert(this.upsert);
        }
        if (this.upsertSourceBytesReference != null && this.upsertSourceXContentType != null) {
            request.upsert(this.upsertSourceBytesReference, this.upsertSourceXContentType);
        }
        if (this.docAsUpsert != null) {
            request.docAsUpsert(this.docAsUpsert);
        }
        if (this.detectNoop != null) {
            request.detectNoop(this.detectNoop);
        }
        if (this.scriptedUpsert != null) {
            request.scriptedUpsert(this.scriptedUpsert);
        }
        if (this.requireAlias != null) {
            request.setRequireAlias(this.requireAlias);
        }
        if (this.refreshPolicy != null) {
            request.setRefreshPolicy(this.refreshPolicy);
        }
        return request;
    }

    protected void validate() throws IllegalStateException {
        boolean fetchSourceNotNull;
        boolean fetchIncludeExcludeNotNull = this.fetchSourceInclude != null || this.fetchSourceExclude != null;
        boolean fetchIncludeExcludeArrayNotNull = this.fetchSourceIncludeArray != null || this.fetchSourceExcludeArray != null;
        boolean bl = fetchSourceNotNull = this.fetchSource != null;
        if (fetchIncludeExcludeNotNull && fetchIncludeExcludeArrayNotNull || fetchIncludeExcludeNotNull && fetchSourceNotNull || fetchIncludeExcludeArrayNotNull && fetchSourceNotNull) {
            throw new IllegalStateException("Only one fetchSource() method may be called");
        }
        int docSourceFieldsSet = this.countDocSourceFieldsSet();
        if (docSourceFieldsSet > 1) {
            throw new IllegalStateException("Only one setDoc() method may be called, but " + docSourceFieldsSet + " have been");
        }
        int upsertSourceFieldsSet = this.countUpsertSourceFieldsSet();
        if (upsertSourceFieldsSet > 1) {
            throw new IllegalStateException("Only one setUpsert() method may be called, but " + upsertSourceFieldsSet + " have been");
        }
    }

    private int countDocSourceFieldsSet() {
        return this.countNonNullObjects(this.doc, this.docSourceBytesReference);
    }

    private int countUpsertSourceFieldsSet() {
        return this.countNonNullObjects(this.upsert, this.upsertSourceBytesReference);
    }

    private int countNonNullObjects(Object ... objects) {
        int sum = 0;
        for (Object object : objects) {
            if (object == null) continue;
            ++sum;
        }
        return sum;
    }
}

