/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportSingleShardAction<Request extends SingleShardRequest<Request>, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final ProjectResolver projectResolver;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    private final String transportShardAction;
    private final Executor executor;

    protected TransportSingleShardAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request, Executor executor) {
        super(actionName, actionFilters, transportService.getTaskManager(), EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.projectResolver = projectResolver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.transportShardAction = actionName + "[s]";
        this.executor = executor;
        if (!this.isSubAction()) {
            transportService.registerRequestHandler(actionName, EsExecutors.DIRECT_EXECUTOR_SERVICE, request, new TransportHandler());
        }
        transportService.registerRequestHandler(this.transportShardAction, EsExecutors.DIRECT_EXECUTOR_SERVICE, request, new ShardTransportHandler());
    }

    protected boolean isSubAction() {
        return false;
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, request, listener).start();
    }

    protected abstract Response shardOperation(Request var1, ShardId var2) throws IOException;

    protected void asyncShardOperation(Request request, ShardId shardId, ActionListener<Response> listener) throws IOException {
        this.getExecutor(shardId).execute(ActionRunnable.supplyAndDecRef(listener, () -> this.shardOperation(request, shardId)));
    }

    protected abstract Writeable.Reader<Response> getResponseReader();

    protected abstract boolean resolveIndex(Request var1);

    protected static ClusterBlockException checkGlobalBlock(ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.READ);
    }

    protected ClusterBlockException checkRequestBlock(ProjectState state, InternalRequest request) {
        return state.blocks().indexBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.READ, request.concreteIndex());
    }

    protected void resolveRequest(ProjectState state, InternalRequest request) {
    }

    protected ProjectState getProjectState() {
        return this.projectResolver.getProjectState(this.clusterService.state());
    }

    @Nullable
    protected abstract ShardsIterator shards(ProjectState var1, InternalRequest var2);

    protected Executor getExecutor(ShardId shardId) {
        return this.executor;
    }

    private class TransportHandler
    implements TransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel, Task task) throws Exception {
            TransportSingleShardAction.this.executeDirect(task, request, new ChannelActionListener(channel));
        }
    }

    private class ShardTransportHandler
    implements TransportRequestHandler<Request> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel, Task task) throws Exception {
            if (TransportSingleShardAction.this.logger.isTraceEnabled()) {
                TransportSingleShardAction.this.logger.trace("executing [{}] on shard [{}]", request, (Object)((SingleShardRequest)request).internalShardId);
            }
            TransportSingleShardAction.this.asyncShardOperation(request, ((SingleShardRequest)request).internalShardId, new ChannelActionListener(channel));
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final ShardsIterator shardIt;
        private final InternalRequest internalRequest;
        private final DiscoveryNodes nodes;
        private volatile Exception lastFailure;
        final /* synthetic */ TransportSingleShardAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.listener = listener;
            ProjectState project = this$0.getProjectState();
            if (((TransportSingleShardAction)this$0).logger.isTraceEnabled()) {
                ((TransportSingleShardAction)this$0).logger.trace("executing [{}] in [{}] based on cluster state version [{}]", request, (Object)project.projectId(), (Object)project.cluster().version());
            }
            this.nodes = project.cluster().nodes();
            ClusterBlockException blockException = TransportSingleShardAction.checkGlobalBlock(project);
            if (blockException != null) {
                throw blockException;
            }
            String concreteSingleIndex = this$0.resolveIndex(request) ? this$0.indexNameExpressionResolver.concreteSingleIndex(project.metadata(), (IndicesRequest)request).getName() : ((SingleShardRequest)request).index();
            this.internalRequest = new InternalRequest((TransportSingleShardAction)this$0, request, concreteSingleIndex);
            this$0.resolveRequest(project, this.internalRequest);
            blockException = this$0.checkRequestBlock(project, this.internalRequest);
            if (blockException != null) {
                throw blockException;
            }
            this.shardIt = this$0.shards(project, this.internalRequest);
        }

        public void start() {
            if (this.shardIt == null) {
                Writeable.Reader reader = this.this$0.getResponseReader();
                this.this$0.transportService.sendRequest(this.this$0.clusterService.localNode(), this.this$0.transportShardAction, (TransportRequest)this.internalRequest.request(), new ActionListenerResponseHandler(this.listener, reader, this.this$0.executor));
            } else {
                this.perform(null);
            }
        }

        private void onFailure(ShardRouting shardRouting, Exception e) {
            if (e != null) {
                this.this$0.logger.trace(() -> Strings.format("%s: failed to execute [%s]", shardRouting, this.internalRequest.request()), (Throwable)e);
            }
            this.perform(e);
        }

        private void perform(@Nullable Exception currentFailure) {
            ShardRouting shardRouting;
            Exception lastFailure = this.lastFailure;
            if (lastFailure == null || TransportActions.isReadOverrideException(currentFailure)) {
                lastFailure = currentFailure;
                this.lastFailure = currentFailure;
            }
            if ((shardRouting = this.shardIt.nextOrNull()) == null) {
                Exception failure = lastFailure;
                if (failure == null || TransportActions.isShardNotAvailableException(failure)) {
                    failure = new NoShardAvailableActionException(null, LoggerMessageFormat.format("No shard available for [{}]", this.internalRequest.request()), failure);
                } else {
                    this.this$0.logger.debug(() -> Strings.format("%s: failed to execute [%s]", null, this.internalRequest.request()), (Throwable)failure);
                }
                this.listener.onFailure(failure);
                return;
            }
            DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
            if (node == null) {
                this.onFailure(shardRouting, new NoShardAvailableActionException(shardRouting.shardId()));
            } else {
                ((SingleShardRequest)this.internalRequest.request()).internalShardId = shardRouting.shardId();
                if (this.this$0.logger.isTraceEnabled()) {
                    this.this$0.logger.trace("sending request [{}] to shard [{}] on node [{}]", this.internalRequest.request(), (Object)((SingleShardRequest)this.internalRequest.request()).internalShardId, (Object)node);
                }
                Writeable.Reader reader = this.this$0.getResponseReader();
                this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, (TransportRequest)this.internalRequest.request(), new ActionListenerResponseHandler<Response>(this.listener, reader, this.this$0.executor){

                    @Override
                    public void handleException(TransportException exp) {
                        AsyncSingleAction.this.onFailure(shardRouting, exp);
                    }
                });
            }
        }
    }

    protected class InternalRequest {
        final Request request;
        final String concreteIndex;

        /*
         * WARNING - Possible parameter corruption
         */
        InternalRequest(Request request, String concreteIndex) {
            this.request = request;
            this.concreteIndex = concreteIndex;
        }

        public Request request() {
            return this.request;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }
}

