/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class MultiSearchRequest
extends LegacyActionRequest
implements CompositeIndicesRequest,
IndicesRequest.CrossProjectCandidate {
    public static final int MAX_CONCURRENT_SEARCH_REQUESTS_DEFAULT = 0;
    private int maxConcurrentSearchRequests = 0;
    private final List<SearchRequest> requests = new ArrayList<SearchRequest>();
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();
    @Nullable
    private String projectRouting;
    private static final TransportVersion MSEARCH_PROJECT_ROUTING = TransportVersion.fromName("msearch_project_routing");

    public MultiSearchRequest() {
    }

    public MultiSearchRequest add(SearchRequestBuilder request) {
        this.requests.add((SearchRequest)request.request());
        return this;
    }

    public MultiSearchRequest add(SearchRequest request) {
        this.requests.add(request);
        return this;
    }

    public int maxConcurrentSearchRequests() {
        return this.maxConcurrentSearchRequests;
    }

    public MultiSearchRequest maxConcurrentSearchRequests(int maxConcurrentSearchRequests) {
        if (maxConcurrentSearchRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentSearchRequests must be positive");
        }
        this.maxConcurrentSearchRequests = maxConcurrentSearchRequests;
        return this;
    }

    public List<SearchRequest> requests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiSearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public MultiSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.maxConcurrentSearchRequests = in.readVInt();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            SearchRequest request = new SearchRequest(in);
            this.requests.add(request);
        }
        this.projectRouting = in.getTransportVersion().supports(MSEARCH_PROJECT_ROUTING) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.maxConcurrentSearchRequests);
        out.writeCollection(this.requests);
        if (out.getTransportVersion().supports(MSEARCH_PROJECT_ROUTING)) {
            out.writeOptionalString(this.projectRouting);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSearchRequest that = (MultiSearchRequest)o;
        return this.maxConcurrentSearchRequests == that.maxConcurrentSearchRequests && Objects.equals(this.requests, that.requests) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.maxConcurrentSearchRequests, this.requests, this.indicesOptions);
    }

    public static void readMultiLineFormat(XContent xContent, XContentParserConfiguration parserConfig, BytesReference data, CheckedBiConsumer<SearchRequest, XContentParser, IOException> consumer, String[] indices, IndicesOptions indicesOptions, String routing, String searchType, Boolean ccsMinimizeRoundtrips, boolean allowExplicitIndex, Optional<Boolean> crossProjectEnabled, @Nullable String projectRouting) throws IOException {
        MultiSearchRequest.readMultiLineFormat(xContent, parserConfig, data, consumer, indices, indicesOptions, routing, searchType, ccsMinimizeRoundtrips, allowExplicitIndex, (s, o, r) -> false, crossProjectEnabled, projectRouting);
    }

    public static void readMultiLineFormat(XContent xContent, XContentParserConfiguration parserConfig, BytesReference data, CheckedBiConsumer<SearchRequest, XContentParser, IOException> consumer, String[] indices, IndicesOptions indicesOptions, String routing, String searchType, Boolean ccsMinimizeRoundtrips, boolean allowExplicitIndex, TriFunction<String, Object, SearchRequest, Boolean> extraParamParser, Optional<Boolean> crossProjectEnabled, @Nullable String projectRouting) throws IOException {
        int nextMarker;
        int from = 0;
        byte marker = xContent.bulkSeparator();
        boolean warnedMrtForCps = false;
        while ((nextMarker = MultiSearchRequest.findNextMarker(marker, from, data)) != -1) {
            XContentParser parser;
            SearchRequest searchRequest = new SearchRequest();
            if (indices != null) {
                searchRequest.indices(indices);
            }
            if (indicesOptions != null) {
                searchRequest.indicesOptions(indicesOptions);
            }
            if (routing != null) {
                searchRequest.routing(routing);
            }
            if (searchType != null) {
                searchRequest.searchType(searchType);
            }
            if (ccsMinimizeRoundtrips != null) {
                searchRequest.setCcsMinimizeRoundtrips(ccsMinimizeRoundtrips);
            }
            IndicesOptions defaultOptions = searchRequest.indicesOptions();
            if (nextMarker - from > 0) {
                parser = XContentHelper.createParserNotCompressed(parserConfig, data.slice(from, nextMarker - from), xContent.type());
                try {
                    Map<String, Object> source = parser.map();
                    if (parser.nextToken() != null) {
                        throw new XContentParseException(parser.getTokenLocation(), "Unexpected token after end of object");
                    }
                    Object expandWildcards = null;
                    Object ignoreUnavailable = null;
                    Object ignoreThrottled = null;
                    Object allowNoIndices = null;
                    for (Map.Entry<String, Object> entry : source.entrySet()) {
                        Object value = entry.getValue();
                        if (crossProjectEnabled.orElse(false).booleanValue() && ("project_routing".equals(entry.getKey()) || "projectRouting".equals(entry.getKey()))) {
                            searchRequest.setProjectRouting(XContentMapValues.nodeStringValue(value));
                            continue;
                        }
                        if ("index".equals(entry.getKey()) || "indices".equals(entry.getKey())) {
                            if (!allowExplicitIndex) {
                                throw new IllegalArgumentException("explicit index in multi search is not allowed");
                            }
                            searchRequest.indices(XContentMapValues.nodeStringArrayValue(value));
                            continue;
                        }
                        if ("search_type".equals(entry.getKey()) || "searchType".equals(entry.getKey())) {
                            searchRequest.searchType(XContentMapValues.nodeStringValue(value, null));
                            continue;
                        }
                        if ("ccs_minimize_roundtrips".equals(entry.getKey()) || "ccsMinimizeRoundtrips".equals(entry.getKey())) {
                            searchRequest.setCcsMinimizeRoundtrips(crossProjectEnabled.orElse(false) != false || XContentMapValues.nodeBooleanValue(value));
                            if (!crossProjectEnabled.orElse(false).booleanValue() || warnedMrtForCps) continue;
                            HeaderWarning.addWarning("ccs_minimize_roundtrips always defaults to true in Cross Project Search context. Setting it explicitly has no effect irrespective of the value specified and is ignored. It will soon be deprecated and made unavailable for Cross project Search.", new Object[0]);
                            warnedMrtForCps = true;
                            continue;
                        }
                        if ("request_cache".equals(entry.getKey()) || "requestCache".equals(entry.getKey())) {
                            searchRequest.requestCache(XContentMapValues.nodeBooleanValue(value, entry.getKey()));
                            continue;
                        }
                        if ("preference".equals(entry.getKey())) {
                            searchRequest.preference(XContentMapValues.nodeStringValue(value, null));
                            continue;
                        }
                        if ("routing".equals(entry.getKey())) {
                            searchRequest.routing(XContentMapValues.nodeStringValue(value, null));
                            continue;
                        }
                        if ("allow_partial_search_results".equals(entry.getKey())) {
                            searchRequest.allowPartialSearchResults(XContentMapValues.nodeBooleanValue(value, null));
                            continue;
                        }
                        if ("expand_wildcards".equals(entry.getKey()) || "expandWildcards".equals(entry.getKey())) {
                            expandWildcards = value;
                            continue;
                        }
                        if ("ignore_unavailable".equals(entry.getKey()) || "ignoreUnavailable".equals(entry.getKey())) {
                            ignoreUnavailable = value;
                            continue;
                        }
                        if ("allow_no_indices".equals(entry.getKey()) || "allowNoIndices".equals(entry.getKey())) {
                            allowNoIndices = value;
                            continue;
                        }
                        if ("ignore_throttled".equals(entry.getKey()) || "ignoreThrottled".equals(entry.getKey())) {
                            ignoreThrottled = value;
                            continue;
                        }
                        if (extraParamParser.apply(entry.getKey(), value, searchRequest).booleanValue()) continue;
                        throw new IllegalArgumentException("key [" + entry.getKey() + "] is not supported in the metadata section");
                    }
                    defaultOptions = IndicesOptions.fromParameters(expandWildcards, ignoreUnavailable, allowNoIndices, ignoreThrottled, defaultOptions);
                }
                finally {
                    if (parser != null) {
                        parser.close();
                    }
                }
            }
            searchRequest.indicesOptions(defaultOptions);
            if (crossProjectEnabled.orElse(false).booleanValue() && searchRequest.getProjectRouting() == null && projectRouting != null) {
                searchRequest.setProjectRouting(projectRouting);
            }
            if ((nextMarker = MultiSearchRequest.findNextMarker(marker, from = nextMarker + 1, data)) == -1) break;
            parser = XContentHelper.createParserNotCompressed(parserConfig, data.slice(from, nextMarker - from), xContent.type());
            try {
                consumer.accept(searchRequest, parser);
                if (parser.nextToken() != null) {
                    throw new XContentParseException(parser.getTokenLocation(), "Unexpected token after end of object");
                }
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
            from = nextMarker + 1;
        }
    }

    private static int findNextMarker(byte marker, int from, BytesReference data) {
        int res = data.indexOf(marker, from);
        if (res != -1) {
            assert (res >= 0);
            return res;
        }
        if (from != data.length()) {
            throw new IllegalArgumentException("The msearch request must be terminated by a newline [\n]");
        }
        return -1;
    }

    public static byte[] writeMultiLineFormat(MultiSearchRequest multiSearchRequest, XContent xContent) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (SearchRequest request : multiSearchRequest.requests()) {
            try (XContentBuilder xContentBuilder = XContentBuilder.builder(xContent);){
                MultiSearchRequest.writeSearchRequestParams(request, xContentBuilder);
                BytesReference.bytes(xContentBuilder).writeTo(output);
            }
            output.write(xContent.bulkSeparator());
            xContentBuilder = XContentBuilder.builder(xContent);
            try {
                if (request.source() != null) {
                    request.source().toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                } else {
                    xContentBuilder.startObject();
                    xContentBuilder.endObject();
                }
                BytesReference.bytes(xContentBuilder).writeTo(output);
            }
            finally {
                if (xContentBuilder != null) {
                    xContentBuilder.close();
                }
            }
            output.write(xContent.bulkSeparator());
        }
        return output.toByteArray();
    }

    public static void writeSearchRequestParams(SearchRequest request, XContentBuilder xContentBuilder) throws IOException {
        xContentBuilder.startObject();
        if (request.indices() != null) {
            xContentBuilder.field("index", request.indices());
        }
        if (!request.indicesOptions().equals(SearchRequest.DEFAULT_INDICES_OPTIONS)) {
            request.indicesOptions().wildcardOptions().toXContent(xContentBuilder, true);
            request.indicesOptions().concreteTargetOptions().toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
        }
        if (request.searchType() != null) {
            xContentBuilder.field("search_type", request.searchType().name().toLowerCase(Locale.ROOT));
        }
        xContentBuilder.field("ccs_minimize_roundtrips", request.isCcsMinimizeRoundtrips());
        if (request.requestCache() != null) {
            xContentBuilder.field("request_cache", request.requestCache());
        }
        if (request.preference() != null) {
            xContentBuilder.field("preference", request.preference());
        }
        if (request.routing() != null) {
            xContentBuilder.field("routing", request.routing());
        }
        if (request.allowPartialSearchResults() != null) {
            xContentBuilder.field("allow_partial_search_results", request.allowPartialSearchResults());
        }
        xContentBuilder.endObject();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return "requests[" + MultiSearchRequest.this.requests.size() + "]: " + MultiSearchRequest.this.requests.stream().map(SearchRequest::buildDescription).collect(Collectors.joining(" | "));
            }
        };
    }

    @Override
    public boolean allowsCrossProject() {
        return true;
    }

    public void setProjectRouting(String projectRouting) {
        if (this.projectRouting != null) {
            throw new IllegalArgumentException("project_routing is already set to [" + this.projectRouting + "]");
        }
        this.projectRouting = projectRouting;
    }

    public String getProjectRouting() {
        return this.projectRouting;
    }
}

