/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ingest.SimulateDocumentBaseResult;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.SimulateDocumentVerboseResult;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SimulatePipelineResponse
extends ActionResponse
implements ToXContentObject {
    private final String pipelineId;
    private boolean verbose;
    private final List<SimulateDocumentResult> results;

    public SimulatePipelineResponse(StreamInput in) throws IOException {
        this.pipelineId = in.readOptionalString();
        boolean verbose = in.readBoolean();
        int responsesLength = in.readVInt();
        this.results = new ArrayList<SimulateDocumentResult>();
        for (int i = 0; i < responsesLength; ++i) {
            SimulateDocumentResult simulateDocumentResult = verbose ? new SimulateDocumentVerboseResult(in) : new SimulateDocumentBaseResult(in);
            this.results.add(simulateDocumentResult);
        }
    }

    public SimulatePipelineResponse(String pipelineId, boolean verbose, List<SimulateDocumentResult> responses) {
        this.pipelineId = pipelineId;
        this.verbose = verbose;
        this.results = Collections.unmodifiableList(responses);
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public List<SimulateDocumentResult> getResults() {
        return this.results;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.pipelineId);
        out.writeBoolean(this.verbose);
        out.writeCollection(this.results);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("docs");
        for (SimulateDocumentResult response : this.results) {
            response.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String DOCUMENTS = "docs";

        Fields() {
        }
    }
}

