/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.reservedstate.ReservedProjectStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class ReservedPipelineAction
implements ReservedProjectStateHandler<List<PutPipelineRequest>> {
    public static final String NAME = "ingest_pipelines";

    @Override
    public String name() {
        return NAME;
    }

    private Collection<PutPipelineRequest> prepare(List<PutPipelineRequest> requests) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (PutPipelineRequest pipeline : requests) {
            try {
                this.validate(pipeline);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error processing ingest pipelines");
            exceptions.forEach(illegalArgumentException::addSuppressed);
            throw illegalArgumentException;
        }
        return requests;
    }

    private static ProjectMetadata wrapIngestTaskExecute(IngestService.PipelineClusterStateUpdateTask task, ProjectMetadata metadata) {
        Collection<IndexMetadata> allIndexMetadata = metadata.indices().values();
        IngestMetadata currentIndexMetadata = (IngestMetadata)metadata.custom("ingest");
        IngestMetadata updatedIngestMetadata = task.execute(currentIndexMetadata, allIndexMetadata);
        return ProjectMetadata.builder(metadata).putCustom("ingest", updatedIngestMetadata).build();
    }

    @Override
    public TransformState transform(ProjectId projectId, List<PutPipelineRequest> source, TransformState prevState) throws Exception {
        Collection<PutPipelineRequest> requests = this.prepare(source);
        ClusterState clusterState = prevState.state();
        ProjectMetadata projectMetadata = clusterState.metadata().getProject(projectId);
        for (PutPipelineRequest request : requests) {
            boolean nopUpdate = IngestService.isNoOpPipelineUpdate(projectMetadata, request);
            if (nopUpdate) continue;
            IngestService.PutPipelineClusterStateUpdateTask task = new IngestService.PutPipelineClusterStateUpdateTask(projectMetadata.id(), request);
            projectMetadata = ReservedPipelineAction.wrapIngestTaskExecute(task, projectMetadata);
        }
        Set<String> entities = requests.stream().map(PutPipelineRequest::getId).collect(Collectors.toSet());
        HashSet<String> toDelete = new HashSet<String>(prevState.keys());
        toDelete.removeAll(entities);
        for (String pipelineToDelete : toDelete) {
            IngestService.DeletePipelineClusterStateUpdateTask task = new IngestService.DeletePipelineClusterStateUpdateTask(projectMetadata.id(), null, new DeletePipelineRequest(RESERVED_CLUSTER_STATE_HANDLER_IGNORED_TIMEOUT, RESERVED_CLUSTER_STATE_HANDLER_IGNORED_TIMEOUT, pipelineToDelete));
            projectMetadata = ReservedPipelineAction.wrapIngestTaskExecute(task, projectMetadata);
        }
        return new TransformState(ClusterState.builder(clusterState).putProjectMetadata(projectMetadata).build(), entities);
    }

    @Override
    public ClusterState remove(ProjectId projectId, TransformState prevState) throws Exception {
        return this.transform(projectId, List.of(), prevState).state();
    }

    @Override
    public List<PutPipelineRequest> fromXContent(XContentParser parser) throws IOException {
        ArrayList<PutPipelineRequest> result = new ArrayList<PutPipelineRequest>();
        Map<String, Object> source = parser.map();
        for (String id : source.keySet()) {
            Map content = (Map)source.get(id);
            try {
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
                try {
                    builder.map(content);
                    result.add(new PutPipelineRequest(RESERVED_CLUSTER_STATE_HANDLER_IGNORED_TIMEOUT, RESERVED_CLUSTER_STATE_HANDLER_IGNORED_TIMEOUT, id, BytesReference.bytes(builder), XContentType.JSON));
                }
                finally {
                    if (builder == null) continue;
                    builder.close();
                }
            }
            catch (Exception e) {
                throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
            }
        }
        return result;
    }
}

