/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MultiGetShardRequest
extends SingleShardRequest<MultiGetShardRequest> {
    private int shardId;
    private String preference;
    private boolean realtime;
    private boolean refresh;
    List<Integer> locations;
    List<MultiGetRequest.Item> items;
    private boolean forceSyntheticSource;

    MultiGetShardRequest(MultiGetRequest multiGetRequest, String index, int shardId) {
        super(index);
        this.shardId = shardId;
        this.locations = new ArrayList<Integer>();
        this.items = new ArrayList<MultiGetRequest.Item>();
        this.preference = multiGetRequest.preference;
        this.realtime = multiGetRequest.realtime;
        this.refresh = multiGetRequest.refresh;
        this.forceSyntheticSource = multiGetRequest.isForceSyntheticSource();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiGetShardRequest)) {
            return false;
        }
        MultiGetShardRequest other = (MultiGetShardRequest)o;
        return this.shardId == other.shardId && this.realtime == other.realtime && this.refresh == other.refresh && this.forceSyntheticSource == other.forceSyntheticSource && Objects.equals(this.preference, other.preference) && Objects.equals(this.index, other.index) && Objects.equals(this.locations, other.locations) && Objects.equals(this.items, other.items);
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.preference, this.realtime, this.refresh, this.index, this.locations, this.items, this.forceSyntheticSource);
    }

    MultiGetShardRequest(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.locations = new ArrayList<Integer>(size);
        this.items = new ArrayList<MultiGetRequest.Item>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            this.items.add(new MultiGetRequest.Item(in));
        }
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        this.realtime = in.readBoolean();
        this.forceSyntheticSource = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            this.items.get(i).writeTo(out);
        }
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        out.writeBoolean(this.realtime);
        out.writeBoolean(this.forceSyntheticSource);
    }

    @Override
    public ActionRequestValidationException validate() {
        return super.validateNonNullIndex();
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiGetShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public MultiGetShardRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetShardRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean isForceSyntheticSource() {
        return this.forceSyntheticSource;
    }

    public MultiGetShardRequest setForceSyntheticSource(boolean forceSyntheticSource) {
        this.forceSyntheticSource = forceSyntheticSource;
        return this;
    }

    void add(int location, MultiGetRequest.Item item) {
        this.locations.add(location);
        this.items.add(item);
    }

    @Override
    public String[] indices() {
        String[] indices = new String[this.items.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.items.get(i).index();
        }
        return indices;
    }
}

