/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public class FieldCapabilitiesResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private static final TransportVersion MIN_TRANSPORT_VERSION = TransportVersion.fromName("min_transport_version");
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField FAILED_INDICES_FIELD = new ParseField("failed_indices", new String[0]);
    public static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    private final String[] indices;
    private final ResolvedIndexExpressions resolvedLocally;
    private final transient Map<String, ResolvedIndexExpressions> resolvedRemotely;
    private final Map<String, Map<String, FieldCapabilities>> fields;
    private final List<FieldCapabilitiesFailure> failures;
    private final List<FieldCapabilitiesIndexResponse> indexResponses;
    private final TransportVersion minTransportVersion;

    public FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> fields, List<FieldCapabilitiesFailure> failures) {
        this(indices, null, Collections.emptyMap(), fields, Collections.emptyList(), failures, null);
    }

    public FieldCapabilitiesResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> fields) {
        this(indices, null, Collections.emptyMap(), fields, Collections.emptyList(), Collections.emptyList(), null);
    }

    public static FieldCapabilitiesResponse empty() {
        return new FieldCapabilitiesResponse(Strings.EMPTY_ARRAY, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), null);
    }

    public FieldCapabilitiesResponse(List<FieldCapabilitiesIndexResponse> indexResponses, List<FieldCapabilitiesFailure> failures) {
        this(Strings.EMPTY_ARRAY, null, Collections.emptyMap(), Collections.emptyMap(), indexResponses, failures, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    private FieldCapabilitiesResponse(String[] indices, ResolvedIndexExpressions resolvedLocally, Map<String, ResolvedIndexExpressions> resolvedRemotely, Map<String, Map<String, FieldCapabilities>> fields, List<FieldCapabilitiesIndexResponse> indexResponses, List<FieldCapabilitiesFailure> failures, TransportVersion minTransportVersion) {
        this.fields = Objects.requireNonNull(fields);
        this.resolvedLocally = resolvedLocally;
        this.resolvedRemotely = Objects.requireNonNull(resolvedRemotely);
        this.indexResponses = Objects.requireNonNull(indexResponses);
        this.indices = indices;
        this.failures = failures;
        this.minTransportVersion = minTransportVersion;
    }

    public FieldCapabilitiesResponse(StreamInput in) throws IOException {
        this.indices = in.readStringArray();
        this.fields = in.readMap(FieldCapabilitiesResponse::readField);
        this.indexResponses = FieldCapabilitiesIndexResponse.readList(in);
        this.failures = in.readCollectionAsList(FieldCapabilitiesFailure::new);
        this.minTransportVersion = in.getTransportVersion().supports(MIN_TRANSPORT_VERSION) ? in.readOptional(TransportVersion::readVersion) : null;
        this.resolvedLocally = in.getTransportVersion().supports(FieldCapabilitiesRequest.RESOLVED_FIELDS_CAPS) ? in.readOptionalWriteable(ResolvedIndexExpressions::new) : null;
        this.resolvedRemotely = Collections.emptyMap();
    }

    public String[] getIndices() {
        return this.indices;
    }

    public int getFailedIndicesCount() {
        int count = 0;
        for (FieldCapabilitiesFailure fieldCapabilitiesFailure : this.failures) {
            int length = fieldCapabilitiesFailure.getIndices().length;
            count += length;
        }
        return count;
    }

    public Map<String, Map<String, FieldCapabilities>> get() {
        return this.fields;
    }

    public List<FieldCapabilitiesFailure> getFailures() {
        return this.failures;
    }

    public List<FieldCapabilitiesIndexResponse> getIndexResponses() {
        return this.indexResponses;
    }

    public ResolvedIndexExpressions getResolvedLocally() {
        return this.resolvedLocally;
    }

    public Map<String, ResolvedIndexExpressions> getResolvedRemotely() {
        return this.resolvedRemotely;
    }

    public Map<String, FieldCapabilities> getField(String field) {
        return this.fields.get(field);
    }

    @Nullable
    public TransportVersion minTransportVersion() {
        return this.minTransportVersion;
    }

    public FieldCapabilitiesResponse withMinTransportVersion(TransportVersion newMin) {
        return new FieldCapabilitiesResponse(this.indices, this.resolvedLocally, this.resolvedRemotely, this.fields, this.indexResponses, this.failures, newMin);
    }

    public boolean isMetadataField(String field) {
        Map<String, FieldCapabilities> caps = this.getField(field);
        if (caps == null) {
            return false;
        }
        return caps.values().stream().anyMatch(FieldCapabilities::isMetadataField);
    }

    private static Map<String, FieldCapabilities> readField(StreamInput in) throws IOException {
        return in.readMap(FieldCapabilities::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        out.writeMap(this.fields, FieldCapabilitiesResponse::writeField);
        FieldCapabilitiesIndexResponse.writeList(out, this.indexResponses);
        out.writeCollection(this.failures);
        if (out.getTransportVersion().supports(MIN_TRANSPORT_VERSION)) {
            out.writeOptional((o, v) -> TransportVersion.writeVersion(v, o), this.minTransportVersion);
        }
        if (out.getTransportVersion().supports(FieldCapabilitiesRequest.RESOLVED_FIELDS_CAPS)) {
            out.writeOptionalWriteable(this.resolvedLocally);
        }
    }

    private static void writeField(StreamOutput out, Map<String, FieldCapabilities> map) throws IOException {
        out.writeMap(map, StreamOutput::writeWriteable);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        if (this.indexResponses.size() > 0) {
            throw new IllegalStateException("cannot serialize non-merged response");
        }
        return Iterators.concat(Iterators.single((b, p) -> b.startObject().array(INDICES_FIELD.getPreferredName(), this.indices).startObject(FIELDS_FIELD.getPreferredName())), Iterators.map(this.fields.entrySet().iterator(), r -> (b, p) -> b.xContentValuesMap((String)r.getKey(), (Map)r.getValue())), this.failures.size() > 0 ? Iterators.concat(Iterators.single((b, p) -> b.endObject().field(FAILED_INDICES_FIELD.getPreferredName(), this.getFailedIndicesCount()).field(FAILURES_FIELD.getPreferredName()).startArray()), this.failures.iterator(), Iterators.single((b, p) -> b.endArray().endObject())) : Iterators.single((b, p) -> b.endObject().endObject()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesResponse that = (FieldCapabilitiesResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.resolvedLocally, that.resolvedLocally) && Objects.equals(this.resolvedRemotely, that.resolvedRemotely) && Objects.equals(this.fields, that.fields) && Objects.equals(this.indexResponses, that.indexResponses) && Objects.equals(this.failures, that.failures) && Objects.equals(this.minTransportVersion, that.minTransportVersion);
    }

    public int hashCode() {
        int result = Objects.hash(this.resolvedLocally, this.resolvedRemotely, this.fields, this.indexResponses, this.failures, this.minTransportVersion);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }

    public String toString() {
        return this.indexResponses.isEmpty() ? Strings.toString(this) : "FieldCapabilitiesResponse{unmerged}";
    }

    public static class Builder {
        private String[] indices = Strings.EMPTY_ARRAY;
        private ResolvedIndexExpressions resolvedLocally;
        private Map<String, ResolvedIndexExpressions> resolvedRemotely = Collections.emptyMap();
        private Map<String, Map<String, FieldCapabilities>> fields = Collections.emptyMap();
        private List<FieldCapabilitiesIndexResponse> indexResponses = Collections.emptyList();
        private List<FieldCapabilitiesFailure> failures = Collections.emptyList();
        private TransportVersion minTransportVersion = null;

        private Builder() {
        }

        public Builder withIndices(String[] indices) {
            this.indices = indices;
            return this;
        }

        public Builder withResolved(ResolvedIndexExpressions resolvedLocally, Map<String, ResolvedIndexExpressions> resolvedRemotely) {
            this.resolvedLocally = resolvedLocally;
            this.resolvedRemotely = resolvedRemotely;
            return this;
        }

        public Builder withResolvedRemotelyBuilder(Map<String, ResolvedIndexExpressions.Builder> resolvedRemotelyBuilder) {
            this.resolvedRemotely = resolvedRemotelyBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResolvedIndexExpressions.Builder)e.getValue()).build()));
            return this;
        }

        public Builder withResolvedRemotely(Map<String, ResolvedIndexExpressions> resolvedRemotely) {
            this.resolvedRemotely = resolvedRemotely;
            return this;
        }

        public Builder withResolvedLocally(ResolvedIndexExpressions resolvedLocally) {
            this.resolvedLocally = resolvedLocally;
            return this;
        }

        public Builder withFields(Map<String, Map<String, FieldCapabilities>> fields) {
            this.fields = fields;
            return this;
        }

        public Builder withIndexResponses(List<FieldCapabilitiesIndexResponse> indexResponses) {
            this.indexResponses = indexResponses;
            return this;
        }

        public Builder withFailures(List<FieldCapabilitiesFailure> failures) {
            this.failures = failures;
            return this;
        }

        public Builder withMinTransportVersion(TransportVersion minTransportVersion) {
            this.minTransportVersion = minTransportVersion;
            return this;
        }

        public FieldCapabilitiesResponse build() {
            return new FieldCapabilitiesResponse(this.indices, this.resolvedLocally, this.resolvedRemotely, this.fields, this.indexResponses, this.failures, this.minTransportVersion);
        }
    }
}

