/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestModifier;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.IngestActionForwarder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.streams.StreamType;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.SamplingService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportAbstractBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAbstractBulkAction.class);
    public static final Set<String> STREAMS_ALLOWED_PARAMS = new HashSet<String>(){
        {
            this.add("error_trace");
            this.add("filter_path");
            this.add("id");
            this.add("index");
            this.add("op_type");
            this.add("pretty");
            this.add("refresh");
            this.add("require_data_stream");
            this.add("timeout");
            this.addAll(RestRequest.INTERNAL_MARKER_REQUEST_PARAMETERS);
        }
    };
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final IndexingPressure indexingPressure;
    protected final SystemIndices systemIndices;
    protected final ProjectResolver projectResolver;
    private final IngestService ingestService;
    private final IngestActionForwarder ingestForwarder;
    protected final LongSupplier relativeTimeNanosProvider;
    protected final Executor coordinationExecutor;
    protected final Executor systemCoordinationExecutor;
    private final ActionType<BulkResponse> bulkAction;
    protected final FeatureService featureService;
    protected final SamplingService samplingService;

    public TransportAbstractBulkAction(ActionType<BulkResponse> action, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<BulkRequest> requestReader, ThreadPool threadPool, ClusterService clusterService, IngestService ingestService, IndexingPressure indexingPressure, SystemIndices systemIndices, ProjectResolver projectResolver, LongSupplier relativeTimeNanosProvider, FeatureService featureService, SamplingService samplingService) {
        super(action.name(), transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.ingestService = ingestService;
        this.indexingPressure = indexingPressure;
        this.systemIndices = systemIndices;
        this.projectResolver = projectResolver;
        this.coordinationExecutor = threadPool.executor("write_coordination");
        this.systemCoordinationExecutor = threadPool.executor("system_write_coordination");
        this.ingestForwarder = new IngestActionForwarder(transportService);
        this.featureService = featureService;
        clusterService.addStateApplier(this.ingestForwarder);
        this.relativeTimeNanosProvider = relativeTimeNanosProvider;
        this.bulkAction = action;
        this.samplingService = samplingService;
    }

    @Override
    protected void doExecute(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        int indexingOps = bulkRequest.numberOfActions();
        long indexingBytes = bulkRequest.ramBytesUsed();
        boolean isOnlySystem = TransportBulkAction.isOnlySystem(bulkRequest, this.projectResolver.getProjectMetadata(this.clusterService.state()).getIndicesLookup(), this.systemIndices);
        Releasable releasable = bulkRequest.incrementalState().indexingPressureAccounted() ? () -> {} : this.indexingPressure.markCoordinatingOperationStarted(indexingOps, indexingBytes, isOnlySystem);
        ActionListener<BulkResponse> releasingListener = ActionListener.runBefore(listener, releasable::close);
        Executor executor = isOnlySystem ? this.systemCoordinationExecutor : this.coordinationExecutor;
        this.ensureClusterStateThenForkAndExecute(task, bulkRequest, executor, releasingListener);
    }

    private void ensureClusterStateThenForkAndExecute(final Task task, final BulkRequest bulkRequest, final Executor executor, final ActionListener<BulkResponse> releasingListener) {
        ClusterState initialState = this.clusterService.state();
        ProjectId projectId = this.projectResolver.getProjectId();
        final ClusterBlockException blockException = initialState.blocks().globalBlockedException(projectId, ClusterBlockLevel.WRITE);
        if (blockException != null) {
            if (!blockException.retryable()) {
                releasingListener.onFailure(blockException);
                return;
            }
            logger.trace("cluster is blocked, waiting for it to recover", (Throwable)blockException);
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(initialState, this.clusterService, bulkRequest.timeout(), logger, this.threadPool.getThreadContext());
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    TransportAbstractBulkAction.this.forkAndExecute(task, bulkRequest, executor, releasingListener);
                }

                @Override
                public void onClusterServiceClose() {
                    releasingListener.onFailure(new NodeClosedException(TransportAbstractBulkAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    releasingListener.onFailure(blockException);
                }
            }, newState -> false == newState.blocks().hasGlobalBlockWithLevel(projectId, ClusterBlockLevel.WRITE));
        } else {
            this.forkAndExecute(task, bulkRequest, executor, releasingListener);
        }
    }

    private void forkAndExecute(final Task task, final BulkRequest bulkRequest, final Executor executor, final ActionListener<BulkResponse> releasingListener) {
        executor.execute(new ActionRunnable<BulkResponse>(releasingListener){

            @Override
            protected void doRun() throws IOException {
                TransportAbstractBulkAction.this.applyPipelinesAndDoInternalExecute(task, bulkRequest, executor, releasingListener, false);
            }
        });
    }

    private boolean applyPipelines(Task task, BulkRequest bulkRequest, Executor executor, ActionListener<BulkResponse> listener, boolean haveRunIngestService) throws IOException {
        ProjectMetadata project;
        boolean hasIndexRequestsWithPipelines = false;
        ClusterState state = this.clusterService.state();
        ProjectId projectId = this.projectResolver.getProjectId();
        Map<String, ComponentTemplate> componentTemplateSubstitutions = bulkRequest.getComponentTemplateSubstitutions();
        Map<String, ComposableIndexTemplate> indexTemplateSubstitutions = bulkRequest.getIndexTemplateSubstitutions();
        if (!(!bulkRequest.isSimulated() || componentTemplateSubstitutions.isEmpty() && indexTemplateSubstitutions.isEmpty())) {
            ProjectMetadata originalProject = state.metadata().getProject(projectId);
            ProjectMetadata.Builder simulatedMetadataBuilder = ProjectMetadata.builder(originalProject);
            if (!componentTemplateSubstitutions.isEmpty()) {
                HashMap<String, ComponentTemplate> updatedComponentTemplates = new HashMap<String, ComponentTemplate>();
                updatedComponentTemplates.putAll(originalProject.componentTemplates());
                updatedComponentTemplates.putAll(componentTemplateSubstitutions);
                simulatedMetadataBuilder.componentTemplates(updatedComponentTemplates);
            }
            if (!indexTemplateSubstitutions.isEmpty()) {
                HashMap updatedIndexTemplates = new HashMap();
                updatedIndexTemplates.putAll(originalProject.templatesV2());
                updatedIndexTemplates.putAll(indexTemplateSubstitutions);
                simulatedMetadataBuilder.indexTemplates(updatedIndexTemplates);
            }
            for (DocWriteRequest docWriteRequest : bulkRequest.requests) {
                IndexRequest indexRequest;
                String indexName;
                assert (docWriteRequest != null) : "Requests cannot be null in simulate mode";
                assert (docWriteRequest instanceof IndexRequest) : "Only IndexRequests are supported in simulate mode, but got " + String.valueOf(docWriteRequest.getClass());
                if (docWriteRequest == null || (indexName = (indexRequest = (IndexRequest)docWriteRequest).index()) == null) continue;
                simulatedMetadataBuilder.remove(indexName);
                simulatedMetadataBuilder.removeDataStream(indexName);
            }
            project = simulatedMetadataBuilder.build();
        } else {
            project = state.metadata().getProject(projectId);
        }
        HashMap<String, IngestService.Pipelines> resolvedPipelineCache = new HashMap<String, IngestService.Pipelines>();
        for (DocWriteRequest<?> actionRequest : bulkRequest.requests) {
            IndexRequest ir;
            IndexRequest indexRequest = TransportAbstractBulkAction.getIndexWriteRequest(actionRequest);
            if (indexRequest != null) {
                if (!indexRequest.isPipelineResolved()) {
                    IngestService.Pipelines pipeline = resolvedPipelineCache.computeIfAbsent(indexRequest.index(), index -> IngestService.resolvePipelines(actionRequest, indexRequest, project, System.currentTimeMillis()));
                    IngestService.setPipelineOnRequest(indexRequest, pipeline);
                }
                hasIndexRequestsWithPipelines |= IngestService.hasPipeline(indexRequest);
            }
            if (!(actionRequest instanceof IndexRequest) || (ir = (IndexRequest)actionRequest).getAutoGeneratedTimestamp() == -1L) continue;
            throw new IllegalArgumentException("autoGeneratedTimestamp should not be set externally");
        }
        if (hasIndexRequestsWithPipelines) {
            ActionListener.run(listener, l -> {
                if (Assertions.ENABLED) {
                    boolean arePipelinesResolved = bulkRequest.requests().stream().map(TransportAbstractBulkAction::getIndexWriteRequest).filter(Objects::nonNull).allMatch(IndexRequest::isPipelineResolved);
                    assert (arePipelinesResolved) : bulkRequest;
                }
                if (this.clusterService.localNode().isIngestNode()) {
                    this.processBulkIndexIngestRequest(task, bulkRequest, executor, project, (ActionListener<BulkResponse>)l);
                } else {
                    this.ingestForwarder.forwardIngestRequest(this.bulkAction, bulkRequest, (ActionListener<?>)l);
                }
            });
            return true;
        }
        if (!haveRunIngestService && this.samplingService != null && this.samplingService.atLeastOneSampleConfigured(project)) {
            for (DocWriteRequest<?> actionRequest : bulkRequest.requests) {
                if (!(actionRequest instanceof IndexRequest)) continue;
                IndexRequest indexRequest = (IndexRequest)actionRequest;
                this.samplingService.maybeSample(project, indexRequest);
            }
        }
        return false;
    }

    private void processBulkIndexIngestRequest(final Task task, BulkRequest original, final Executor executor, ProjectMetadata metadata, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = this.relativeTimeNanos();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        Thread originalThread = Thread.currentThread();
        this.getIngestService(original).executeBulkRequest(metadata.id(), original.numberOfActions(), () -> bulkRequestModifier, bulkRequestModifier::markItemAsDropped, indexName -> this.resolveFailureStore((String)indexName, metadata, this.threadPool.absoluteTimeInMillis()), bulkRequestModifier::markItemForFailureStore, bulkRequestModifier::markItemAsFailed, listener.delegateFailureAndWrap((l, unused) -> {
            long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeNanos() - ingestStartTimeInNanos);
            final BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
            final ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, (ActionListener<BulkResponse>)l);
            if (bulkRequest.requests().isEmpty()) {
                actionListener.onResponse(new BulkResponse(new BulkItemResponse[0], 0L));
            } else {
                ActionRunnable<BulkResponse> runnable = new ActionRunnable<BulkResponse>(actionListener){

                    @Override
                    protected void doRun() throws IOException {
                        TransportAbstractBulkAction.this.applyPipelinesAndDoInternalExecute(task, bulkRequest, executor, actionListener, true);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return true;
                    }
                };
                if (originalThread == Thread.currentThread()) {
                    runnable.run();
                } else {
                    executor.execute(runnable);
                }
            }
        }));
    }

    protected abstract Boolean resolveFailureStore(String var1, ProjectMetadata var2, long var3);

    public static IndexRequest getIndexWriteRequest(DocWriteRequest<?> docWriteRequest) {
        IndexRequest indexRequest = null;
        if (docWriteRequest instanceof IndexRequest) {
            indexRequest = (IndexRequest)docWriteRequest;
        } else if (docWriteRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
            indexRequest = updateRequest.docAsUpsert() ? updateRequest.doc() : updateRequest.upsertRequest();
        }
        return indexRequest;
    }

    protected IngestService getIngestService(BulkRequest request) {
        return this.ingestService;
    }

    protected long relativeTimeNanos() {
        return this.relativeTimeNanosProvider.getAsLong();
    }

    protected long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTimeNanos() - startTimeNanos);
    }

    private void applyPipelinesAndDoInternalExecute(Task task, BulkRequest bulkRequest, Executor executor, ActionListener<BulkResponse> listener, boolean haveRunIngestService) throws IOException {
        long relativeStartTimeNanos = this.relativeTimeNanos();
        ProjectMetadata projectMetadata = this.projectResolver.getProjectMetadata(this.clusterService.state());
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(bulkRequest);
        int i = -1;
        while (bulkRequestModifier.hasNext()) {
            Object req = bulkRequestModifier.next();
            this.doStreamsChecks(bulkRequest, projectMetadata, (DocWriteRequest<?>)req, bulkRequestModifier, ++i);
        }
        ActionListener<BulkResponse> wrappedListener = bulkRequestModifier.wrapActionListenerIfNeeded(listener);
        if (!this.applyPipelines(task, bulkRequestModifier.getBulkRequest(), executor, wrappedListener, haveRunIngestService)) {
            this.doInternalExecute(task, bulkRequestModifier.getBulkRequest(), executor, wrappedListener, relativeStartTimeNanos);
        }
    }

    private void doStreamsChecks(BulkRequest bulkRequest, ProjectMetadata projectMetadata, DocWriteRequest<?> req, BulkRequestModifier bulkRequestModifier, int i) {
        for (StreamType streamType : StreamType.getEnabledStreamTypesForProject(projectMetadata)) {
            IndexRequest ir;
            if (!(req instanceof IndexRequest) || (ir = (IndexRequest)req).isPipelineResolved()) continue;
            IllegalArgumentException e = null;
            if (streamType.matchesStreamPrefix(req.index())) {
                e = new IllegalArgumentException("Direct writes to child streams are prohibited. Index directly into the [" + streamType.getStreamName() + "] stream instead");
            }
            if (e == null && streamType.getStreamName().equals(ir.index()) && ir.getPipeline() != null) {
                e = new IllegalArgumentException("Cannot provide a pipeline when writing to a stream however the [" + ir.getPipeline() + "] pipeline was provided when writing to the [" + streamType.getStreamName() + "] stream");
            }
            if (e == null && this.streamsRestrictedParamsUsed(bulkRequest) && req.index().equals(streamType.getStreamName())) {
                e = new IllegalArgumentException("When writing to a stream, only the following parameters are allowed: [" + String.join((CharSequence)", ", STREAMS_ALLOWED_PARAMS) + "] however the following were used: " + String.valueOf(bulkRequest.requestParamsUsed()));
            }
            if (e == null) continue;
            Boolean failureStoreEnabled = this.resolveFailureStore(req.index(), projectMetadata, this.threadPool.absoluteTimeInMillis());
            if (this.featureService.clusterHasFeature(this.clusterService.state(), DataStream.DATA_STREAM_FAILURE_STORE_FEATURE)) {
                if (Boolean.TRUE.equals(failureStoreEnabled)) {
                    bulkRequestModifier.markItemForFailureStore(i, req.index(), e);
                    break;
                }
                if (Boolean.FALSE.equals(failureStoreEnabled)) {
                    bulkRequestModifier.markItemAsFailed(i, e, IndexDocFailureStoreStatus.NOT_ENABLED);
                    break;
                }
                bulkRequestModifier.markItemAsFailed(i, e, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
                break;
            }
            bulkRequestModifier.markItemAsFailed(i, e, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
            break;
        }
    }

    private boolean streamsRestrictedParamsUsed(BulkRequest bulkRequest) {
        return !Sets.difference(bulkRequest.requestParamsUsed(), STREAMS_ALLOWED_PARAMS).isEmpty();
    }

    protected abstract void doInternalExecute(Task var1, BulkRequest var2, Executor var3, ActionListener<BulkResponse> var4, long var5) throws IOException;
}

