/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record SamplingConfiguration(double rate, Integer maxSamples, ByteSizeValue maxSize, TimeValue timeToLive, String condition, Long creationTime) implements ToXContentObject,
SimpleDiffable<SamplingConfiguration>
{
    public static final String TYPE = "sampling_configuration";
    private static final String RATE_FIELD_NAME = "rate";
    private static final String MAX_SAMPLES_FIELD_NAME = "max_samples";
    private static final String MAX_SIZE_IN_BYTES_FIELD_NAME = "max_size_in_bytes";
    private static final String MAX_SIZE_FIELD_NAME = "max_size";
    private static final String TIME_TO_LIVE_IN_MILLIS_FIELD_NAME = "time_to_live_in_millis";
    private static final String TIME_TO_LIVE_FIELD_NAME = "time_to_live";
    private static final String CONDITION_FIELD_NAME = "if";
    private static final String CREATION_TIME_IN_MILLIS_FIELD_NAME = "creation_time_in_millis";
    private static final String CREATION_TIME_FIELD_NAME = "creation_time";
    private static final String IS_USER_DATA_CONTEXT_KEY = "is_user_data";
    public static final int MAX_SAMPLES_LIMIT = 10000;
    public static final double DEFAULT_MAX_SIZE_HEAP_PERCENTAGE = 0.01;
    public static final double MAX_SIZE_HEAP_PERCENTAGE_LIMIT = 0.05;
    public static final ByteSizeValue DEFAULT_MAX_SIZE_FLOOR = ByteSizeValue.ofKb(100L);
    public static final long MAX_TIME_TO_LIVE_DAYS = 30L;
    public static final int DEFAULT_MAX_SAMPLES = 100;
    public static final long DEFAULT_TIME_TO_LIVE_DAYS = 10L;
    public static final String INVALID_RATE_MESSAGE = "rate must be greater than 0 and less than or equal to 1";
    public static final String INVALID_MAX_SAMPLES_MIN_MESSAGE = "maxSamples must be greater than 0";
    public static final String INVALID_MAX_SAMPLES_MAX_MESSAGE = "maxSamples must be less than or equal to 10000";
    public static final String INVALID_MAX_SIZE_MIN_MESSAGE = "maxSize must be greater than 0";
    public static final String INVALID_MAX_SIZE_MAX_MESSAGE = "maxSize must be less than or equal to 5% of heap size (" + SamplingConfiguration.calculateMaxSizeLimit().toString() + ")";
    public static final String INVALID_TIME_TO_LIVE_MIN_MESSAGE = "timeToLive must be greater than 0";
    public static final String INVALID_TIME_TO_LIVE_MAX_MESSAGE = "timeToLive must be less than or equal to 30 days";
    public static final String INVALID_CONDITION_MESSAGE = "condition script, if provided, must not be empty";
    private static final ConstructingObjectParser<SamplingConfiguration, Map<String, Boolean>> PARSER = new ConstructingObjectParser<SamplingConfiguration, Map>("sampling_configuration", false, (args, context) -> {
        Double rate = (Double)args[0];
        Integer maxSamples = (Integer)args[1];
        ByteSizeValue humanReadableMaxSize = (ByteSizeValue)args[2];
        ByteSizeValue rawMaxSize = (ByteSizeValue)args[3];
        TimeValue humanReadableTimeToLive = (TimeValue)args[4];
        TimeValue rawTimeToLive = (TimeValue)args[5];
        String condition = (String)args[6];
        Long rawCreationTime = (Long)args[8];
        if (((Boolean)context.get(IS_USER_DATA_CONTEXT_KEY)).booleanValue()) {
            SamplingConfiguration.validateInputs(rate, maxSamples, SamplingConfiguration.determineValue(humanReadableMaxSize, rawMaxSize), SamplingConfiguration.determineValue(humanReadableTimeToLive, rawTimeToLive), condition);
        }
        return new SamplingConfiguration(rate, maxSamples, SamplingConfiguration.determineValue(humanReadableMaxSize, rawMaxSize), SamplingConfiguration.determineValue(humanReadableTimeToLive, rawTimeToLive), condition, rawCreationTime);
    });

    public SamplingConfiguration(double rate, Integer maxSamples, ByteSizeValue maxSize, TimeValue timeToLive, String condition, Long creationTime) {
        this.rate = rate;
        this.maxSamples = maxSamples == null ? 100 : maxSamples;
        this.maxSize = maxSize == null ? SamplingConfiguration.calculateDefaultMaxSize() : maxSize;
        this.timeToLive = timeToLive == null ? TimeValue.timeValueDays(10L) : timeToLive;
        this.condition = condition;
        this.creationTime = creationTime == null ? Instant.now().toEpochMilli() : creationTime.longValue();
    }

    public SamplingConfiguration(double rate, Integer maxSamples, ByteSizeValue maxSize, TimeValue timeToLive, String condition) {
        this(rate, maxSamples, maxSize, timeToLive, condition, null);
    }

    public SamplingConfiguration(StreamInput in) throws IOException {
        this(in.readDouble(), in.readInt(), ByteSizeValue.readFrom(in), in.readTimeValue(), in.readOptionalString(), in.readLong());
    }

    private static ByteSizeValue calculateDefaultMaxSize() {
        long heapBasedSize = (long)(0.01 * (double)JvmInfo.jvmInfo().getConfiguredMaxHeapSize());
        return ByteSizeValue.ofBytes(Math.max(heapBasedSize, DEFAULT_MAX_SIZE_FLOOR.getBytes()));
    }

    public static ByteSizeValue calculateMaxSizeLimit() {
        return ByteSizeValue.ofBytes((long)(0.05 * (double)JvmInfo.jvmInfo().getConfiguredMaxHeapSize()));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.rate);
        out.writeInt(this.maxSamples);
        out.writeWriteable(this.maxSize);
        out.writeTimeValue(this.timeToLive);
        out.writeOptionalString(this.condition);
        out.writeLong(this.creationTime);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RATE_FIELD_NAME, this.rate);
        builder.field(MAX_SAMPLES_FIELD_NAME, this.maxSamples);
        builder.humanReadableField(MAX_SIZE_IN_BYTES_FIELD_NAME, MAX_SIZE_FIELD_NAME, this.maxSize);
        builder.humanReadableField(TIME_TO_LIVE_IN_MILLIS_FIELD_NAME, TIME_TO_LIVE_FIELD_NAME, this.timeToLive);
        if (this.condition != null) {
            builder.field(CONDITION_FIELD_NAME, this.condition);
        }
        builder.timestampFieldsFromUnixEpochMillis(CREATION_TIME_IN_MILLIS_FIELD_NAME, CREATION_TIME_FIELD_NAME, this.creationTime);
        builder.endObject();
        return builder;
    }

    public static SamplingConfiguration fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        context.put(IS_USER_DATA_CONTEXT_KEY, false);
        return PARSER.parse(parser, context);
    }

    public static SamplingConfiguration fromXContentUserData(XContentParser parser) throws IOException {
        return PARSER.parse(parser, Map.of(IS_USER_DATA_CONTEXT_KEY, true));
    }

    public static Diff<SamplingConfiguration> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(SamplingConfiguration::new, in);
    }

    private static void validateInputs(double rate, Integer maxSamples, ByteSizeValue maxSize, TimeValue timeToLive, String condition) {
        Comparable<ByteSizeValue> maxLimit;
        if (rate <= 0.0 || rate > 1.0) {
            throw new IllegalArgumentException(INVALID_RATE_MESSAGE);
        }
        if (maxSamples != null) {
            if (maxSamples <= 0) {
                throw new IllegalArgumentException(INVALID_MAX_SAMPLES_MIN_MESSAGE);
            }
            if (maxSamples > 10000) {
                throw new IllegalArgumentException(INVALID_MAX_SAMPLES_MAX_MESSAGE);
            }
        }
        if (maxSize != null) {
            if (maxSize.compareTo(ByteSizeValue.ZERO) <= 0) {
                throw new IllegalArgumentException(INVALID_MAX_SIZE_MIN_MESSAGE);
            }
            maxLimit = SamplingConfiguration.calculateMaxSizeLimit();
            if (maxSize.compareTo((ByteSizeValue)maxLimit) > 0) {
                throw new IllegalArgumentException(INVALID_MAX_SIZE_MAX_MESSAGE);
            }
        }
        if (timeToLive != null) {
            if (timeToLive.compareTo(TimeValue.ZERO) <= 0) {
                throw new IllegalArgumentException(INVALID_TIME_TO_LIVE_MIN_MESSAGE);
            }
            maxLimit = TimeValue.timeValueDays(30L);
            if (timeToLive.compareTo((TimeValue)maxLimit) > 0) {
                throw new IllegalArgumentException(INVALID_TIME_TO_LIVE_MAX_MESSAGE);
            }
        }
        if (condition != null && condition.isEmpty()) {
            throw new IllegalArgumentException(INVALID_CONDITION_MESSAGE);
        }
    }

    private static <T> T determineValue(T humanReadableValue, T rawValue) {
        if (humanReadableValue == null && rawValue == null) {
            return null;
        }
        return humanReadableValue != null ? humanReadableValue : rawValue;
    }

    private static void validateUserDataContext(Map<String, Boolean> context, String fieldName) {
        if (context.get(IS_USER_DATA_CONTEXT_KEY) == Boolean.TRUE) {
            throw new IllegalArgumentException("Creation time cannot be set by user (field: " + fieldName + ")");
        }
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), new ParseField(RATE_FIELD_NAME, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(MAX_SAMPLES_FIELD_NAME, new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MAX_SIZE_FIELD_NAME), new ParseField(MAX_SIZE_FIELD_NAME, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.ofBytes(p.longValue()), new ParseField(MAX_SIZE_IN_BYTES_FIELD_NAME, new String[0]), ObjectParser.ValueType.LONG);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.text(), TIME_TO_LIVE_FIELD_NAME), new ParseField(TIME_TO_LIVE_FIELD_NAME, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.timeValueMillis(p.longValue()), new ParseField(TIME_TO_LIVE_IN_MILLIS_FIELD_NAME, new String[0]), ObjectParser.ValueType.LONG);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(CONDITION_FIELD_NAME, new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            SamplingConfiguration.validateUserDataContext(c, CREATION_TIME_FIELD_NAME);
            return Instant.parse(p.text()).toEpochMilli();
        }, new ParseField(CREATION_TIME_FIELD_NAME, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            SamplingConfiguration.validateUserDataContext(c, CREATION_TIME_IN_MILLIS_FIELD_NAME);
            return p.longValue();
        }, new ParseField(CREATION_TIME_IN_MILLIS_FIELD_NAME, new String[0]), ObjectParser.ValueType.LONG);
    }
}

