/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndicesAliasesResponse
extends AcknowledgedResponse {
    public static final IndicesAliasesResponse NOT_ACKNOWLEDGED = new IndicesAliasesResponse(false, false, List.of());
    public static final IndicesAliasesResponse ACKNOWLEDGED_NO_ERRORS = new IndicesAliasesResponse(true, false, List.of());
    private static final String ACTION_RESULTS_FIELD = "action_results";
    private static final String ERRORS_FIELD = "errors";
    private final List<AliasActionResult> actionResults;
    private final boolean errors;

    protected IndicesAliasesResponse(StreamInput in) throws IOException {
        super(in);
        this.errors = in.readBoolean();
        this.actionResults = in.readCollectionAsImmutableList(AliasActionResult::new);
    }

    IndicesAliasesResponse(boolean acknowledged, boolean errors, List<AliasActionResult> actionResults) {
        super(acknowledged);
        this.errors = errors;
        this.actionResults = actionResults;
    }

    public List<AliasActionResult> getActionResults() {
        return this.actionResults;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public List<ElasticsearchException> getErrors() {
        if (!this.errors) {
            return List.of();
        }
        return this.actionResults.stream().filter(a -> a.getError() != null).map(AliasActionResult::getError).toList();
    }

    public static IndicesAliasesResponse build(List<AliasActionResult> actionResults) {
        assert (!actionResults.isEmpty()) : "IndicesAliasesResponse must be instantiated with at least one action result.";
        boolean errors = actionResults.stream().anyMatch(a -> a.error != null);
        return new IndicesAliasesResponse(true, errors, actionResults);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.errors);
        out.writeCollection(this.actionResults);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ERRORS_FIELD, this.errors);
        if (this.errors) {
            builder.field(ACTION_RESULTS_FIELD, (Iterable<?>)this.actionResults);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndicesAliasesResponse response = (IndicesAliasesResponse)o;
        return this.errors == response.errors && Objects.equals(this.actionResults, response.actionResults);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.actionResults, this.errors);
    }

    public static class AliasActionResult
    implements Writeable,
    ToXContentObject {
        private final List<String> indices;
        private final IndicesAliasesRequest.AliasActions action;
        private final ElasticsearchException error;
        public static final String ACTION_FIELD = "action";
        public static final String ACTION_TYPE_FIELD = "type";
        public static final String ACTION_INDICES_FIELD = "indices";
        public static final String ACTION_ALIASES_FIELD = "aliases";
        public static final String STATUS_FIELD = "status";
        public static final String ERROR_FIELD = "error";

        public static AliasActionResult build(List<String> indices, IndicesAliasesRequest.AliasActions action, int numAliasesRemoved) {
            if (action.actionType() == IndicesAliasesRequest.AliasActions.Type.REMOVE && numAliasesRemoved == 0) {
                return AliasActionResult.buildRemoveError(indices, action);
            }
            return AliasActionResult.buildSuccess(indices, action);
        }

        private static AliasActionResult buildRemoveError(List<String> indices, IndicesAliasesRequest.AliasActions action) {
            return new AliasActionResult(indices, action, new AliasesNotFoundException(action.getOriginalAliases()));
        }

        public static AliasActionResult buildSuccess(List<String> indices, IndicesAliasesRequest.AliasActions action) {
            return new AliasActionResult(indices, action, null);
        }

        public ElasticsearchException getError() {
            return this.error;
        }

        private int getStatus() {
            return this.error == null ? 200 : this.error.status().getStatus();
        }

        private AliasActionResult(List<String> indices, IndicesAliasesRequest.AliasActions action, ElasticsearchException error) {
            assert (!indices.isEmpty()) : "Alias action result must be instantiated with at least one index";
            this.indices = indices;
            this.action = action;
            this.error = error;
        }

        private AliasActionResult(StreamInput in) throws IOException {
            this.indices = in.readStringCollectionAsList();
            this.action = new IndicesAliasesRequest.AliasActions(in);
            this.error = (ElasticsearchException)in.readException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.indices);
            this.action.writeTo(out);
            out.writeException(this.error);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ACTION_FIELD);
            builder.startObject();
            builder.field(ACTION_TYPE_FIELD, this.action.actionType().getFieldName());
            builder.field(ACTION_INDICES_FIELD, this.indices.stream().sorted().collect(Collectors.toList()));
            builder.array(ACTION_ALIASES_FIELD, this.action.getOriginalAliases());
            builder.endObject();
            builder.field(STATUS_FIELD, this.getStatus());
            if (this.error != null) {
                builder.startObject(ERROR_FIELD);
                this.error.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AliasActionResult that = (AliasActionResult)o;
            return Objects.equals(this.indices, that.indices) && Objects.equals(this.action, that.action) && Objects.equals(this.error == null ? null : this.error.getMessage(), that.error == null ? null : that.error.getMessage()) && Objects.equals(this.error == null ? null : this.error.getClass(), that.error == null ? null : that.error.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.action, this.error == null ? null : this.error.getMessage(), this.error == null ? null : this.error.getClass());
        }
    }
}

