/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.util.Map;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class ClusterStatsRequest
extends BaseNodesRequest {
    private final boolean doRemotes;
    private final boolean remoteStats;
    private final boolean isCPS;

    public ClusterStatsRequest(String ... nodesIds) {
        this(false, false, nodesIds);
    }

    public ClusterStatsRequest(boolean doRemotes, String ... nodesIds) {
        this(doRemotes, false, nodesIds);
    }

    public ClusterStatsRequest(boolean doRemotes, boolean isCPS, String ... nodesIds) {
        super(nodesIds);
        this.doRemotes = doRemotes;
        this.remoteStats = false;
        this.isCPS = isCPS;
    }

    public static ClusterStatsRequest newServerlessRequest(String[] nodeIds) {
        return new ClusterStatsRequest(false, true, nodeIds);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }

    public static ClusterStatsRequest newRemoteClusterStatsRequest() {
        return new ClusterStatsRequest(false, false, new String[0]);
    }

    public boolean doRemotes() {
        return this.doRemotes;
    }

    public boolean isRemoteStats() {
        return this.remoteStats;
    }

    public boolean isCPS() {
        return this.isCPS;
    }
}

