/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.CCSTelemetrySnapshot;
import org.elasticsearch.action.admin.cluster.stats.RepositoryUsageStats;
import org.elasticsearch.action.admin.cluster.stats.SearchUsageStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public class ClusterStatsNodeResponse
extends BaseNodeResponse {
    private final NodeInfo nodeInfo;
    private final NodeStats nodeStats;
    private final ShardStats[] shardsStats;
    private final ClusterHealthStatus clusterStatus;
    private final SearchUsageStats searchUsageStats;
    private final RepositoryUsageStats repositoryUsageStats;
    private final CCSTelemetrySnapshot searchCcsMetrics;
    private final CCSTelemetrySnapshot esqlCcsMetrics;

    public ClusterStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterStatus = in.readOptionalWriteable(ClusterHealthStatus::readFrom);
        this.nodeInfo = new NodeInfo(in);
        this.nodeStats = new NodeStats(in);
        this.shardsStats = in.readArray(ShardStats::new, ShardStats[]::new);
        this.searchUsageStats = new SearchUsageStats(in);
        this.repositoryUsageStats = RepositoryUsageStats.readFrom(in);
        this.searchCcsMetrics = new CCSTelemetrySnapshot(in);
        this.esqlCcsMetrics = new CCSTelemetrySnapshot(in);
    }

    public ClusterStatsNodeResponse(DiscoveryNode node, @Nullable ClusterHealthStatus clusterStatus, NodeInfo nodeInfo, NodeStats nodeStats, ShardStats[] shardsStats, SearchUsageStats searchUsageStats, RepositoryUsageStats repositoryUsageStats, CCSTelemetrySnapshot ccsTelemetrySnapshot, CCSTelemetrySnapshot esqlTelemetrySnapshot) {
        super(node);
        this.nodeInfo = nodeInfo;
        this.nodeStats = nodeStats;
        this.shardsStats = shardsStats;
        this.clusterStatus = clusterStatus;
        this.searchUsageStats = Objects.requireNonNull(searchUsageStats);
        this.repositoryUsageStats = Objects.requireNonNull(repositoryUsageStats);
        this.searchCcsMetrics = ccsTelemetrySnapshot;
        this.esqlCcsMetrics = esqlTelemetrySnapshot;
    }

    public NodeInfo nodeInfo() {
        return this.nodeInfo;
    }

    public NodeStats nodeStats() {
        return this.nodeStats;
    }

    @Nullable
    public ClusterHealthStatus clusterStatus() {
        return this.clusterStatus;
    }

    public ShardStats[] shardsStats() {
        return this.shardsStats;
    }

    public SearchUsageStats searchUsageStats() {
        return this.searchUsageStats;
    }

    public RepositoryUsageStats repositoryUsageStats() {
        return this.repositoryUsageStats;
    }

    public CCSTelemetrySnapshot getSearchCcsMetrics() {
        return this.searchCcsMetrics;
    }

    public CCSTelemetrySnapshot getEsqlCcsMetrics() {
        return this.esqlCcsMetrics;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.clusterStatus);
        this.nodeInfo.writeTo(out);
        this.nodeStats.writeTo(out);
        out.writeArray(this.shardsStats);
        this.searchUsageStats.writeTo(out);
        this.repositoryUsageStats.writeTo(out);
        this.searchCcsMetrics.writeTo(out);
        this.esqlCcsMetrics.writeTo(out);
    }
}

