/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.state.RemoteClusterStateRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRemoteClusterStateAction
extends HandledTransportAction<RemoteClusterStateRequest, ClusterStateResponse> {
    private final Client client;

    @Inject
    public TransportRemoteClusterStateAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:monitor/state", transportService, actionFilters, RemoteClusterStateRequest::new, threadPool.executor("management"));
        this.client = client;
    }

    @Override
    protected void doExecute(Task task, RemoteClusterStateRequest request, ActionListener<ClusterStateResponse> listener) {
        ClusterStateRequest localRequest = new ClusterStateRequest(request.masterNodeTimeout());
        localRequest.routingTable(request.routingTable());
        localRequest.nodes(request.nodes());
        localRequest.metadata(request.metadata());
        localRequest.blocks(request.blocks());
        localRequest.customs(request.customs());
        if (request.waitForMetadataVersion() != null) {
            localRequest.waitForMetadataVersion(request.waitForMetadataVersion());
        }
        localRequest.waitForTimeout(request.waitForTimeout());
        localRequest.indices(request.indices());
        localRequest.indicesOptions(request.indicesOptions());
        this.client.execute(ClusterStateAction.INSTANCE, localRequest, listener);
    }
}

