/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotShardsStats;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.xcontent.ToXContent;

public class SnapshotStatus
implements ChunkedToXContentObject,
Writeable {
    private final Snapshot snapshot;
    private final SnapshotsInProgress.State state;
    private final List<SnapshotIndexShardStatus> shards;
    private Map<String, SnapshotIndexStatus> indicesStatus;
    private SnapshotShardsStats shardsStats;
    private SnapshotStats stats;
    @Nullable
    private final Boolean includeGlobalState;
    static final String SNAPSHOT = "snapshot";
    static final String REPOSITORY = "repository";
    static final String UUID = "uuid";
    static final String STATE = "state";
    static final String INDICES = "indices";
    static final String INCLUDE_GLOBAL_STATE = "include_global_state";

    SnapshotStatus(StreamInput in) throws IOException {
        this.snapshot = new Snapshot(in);
        this.state = SnapshotsInProgress.State.fromValue(in.readByte());
        this.shards = in.readCollectionAsImmutableList(SnapshotIndexShardStatus::new);
        this.includeGlobalState = in.readOptionalBoolean();
        long startTime = in.readLong();
        long time = in.readLong();
        this.updateShardStats(startTime, time);
    }

    SnapshotStatus(Snapshot snapshot, SnapshotsInProgress.State state, List<SnapshotIndexShardStatus> shards, Boolean includeGlobalState, long startTime, long time) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.state = Objects.requireNonNull(state);
        this.shards = Objects.requireNonNull(shards);
        this.includeGlobalState = includeGlobalState;
        this.shardsStats = new SnapshotShardsStats(shards);
        assert (time >= 0L) : "time must be >= 0 but received [" + time + "]";
        this.updateShardStats(startTime, time);
    }

    SnapshotStatus(Snapshot snapshot, SnapshotsInProgress.State state, List<SnapshotIndexShardStatus> shards, Map<String, SnapshotIndexStatus> indicesStatus, SnapshotShardsStats shardsStats, SnapshotStats stats, Boolean includeGlobalState) {
        this.snapshot = snapshot;
        this.state = state;
        this.shards = shards;
        this.indicesStatus = indicesStatus;
        this.shardsStats = shardsStats;
        this.stats = stats;
        this.includeGlobalState = includeGlobalState;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public SnapshotsInProgress.State getState() {
        return this.state;
    }

    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<SnapshotIndexShardStatus> getShards() {
        return this.shards;
    }

    public SnapshotShardsStats getShardsStats() {
        return this.shardsStats;
    }

    public Map<String, SnapshotIndexStatus> getIndices() {
        Map<String, SnapshotIndexStatus> res = this.indicesStatus;
        if (res != null) {
            return res;
        }
        HashMap<String, List> indices = new HashMap<String, List>();
        for (SnapshotIndexShardStatus shard : this.shards) {
            indices.computeIfAbsent(shard.getIndex(), k -> new ArrayList()).add(shard);
        }
        Map<String, SnapshotIndexStatus> indicesStatus = Maps.newMapWithExpectedSize(indices.size());
        for (Map.Entry entry : indices.entrySet()) {
            indicesStatus.put((String)entry.getKey(), new SnapshotIndexStatus((String)entry.getKey(), (Collection)entry.getValue()));
        }
        this.indicesStatus = res = Collections.unmodifiableMap(indicesStatus);
        return res;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshot.writeTo(out);
        out.writeByte(this.state.value());
        out.writeCollection(this.shards);
        out.writeOptionalBoolean(this.includeGlobalState);
        out.writeLong(this.stats.getStartTime());
        out.writeLong(this.stats.getTime());
    }

    public String toString() {
        return Strings.toString(this, true, false);
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((b, p) -> {
            b.startObject().field(SNAPSHOT, this.snapshot.getSnapshotId().getName()).field(REPOSITORY, this.snapshot.getRepository()).field(UUID, this.snapshot.getSnapshotId().getUUID()).field(STATE, this.state.name());
            if (this.includeGlobalState != null) {
                b.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
            }
            return b.field("shards_stats", this.shardsStats, p).field("stats", this.stats, p).startObject(INDICES);
        }), this.getIndices().values().iterator(), Iterators.single((b, p) -> b.endObject().endObject()));
    }

    private void updateShardStats(long startTime, long time) {
        this.stats = new SnapshotStats(startTime, time, 0, 0, 0, 0L, 0L, 0L);
        this.shardsStats = new SnapshotShardsStats(this.shards);
        for (SnapshotIndexShardStatus shard : this.shards) {
            this.stats.add(shard.getStats(), startTime == 0L);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotStatus that = (SnapshotStatus)o;
        return Objects.equals(this.snapshot, that.snapshot) && this.state == that.state && Objects.equals(this.indicesStatus, that.indicesStatus) && Objects.equals(this.shardsStats, that.shardsStats) && Objects.equals(this.stats, that.stats) && Objects.equals(this.includeGlobalState, that.includeGlobalState);
    }

    public int hashCode() {
        int result = this.snapshot != null ? this.snapshot.hashCode() : 0;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.indicesStatus != null ? this.indicesStatus.hashCode() : 0);
        result = 31 * result + (this.shardsStats != null ? this.shardsStats.hashCode() : 0);
        result = 31 * result + (this.stats != null ? this.stats.hashCode() : 0);
        result = 31 * result + (this.includeGlobalState != null ? this.includeGlobalState.hashCode() : 0);
        return result;
    }
}

