/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.delete;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteSnapshotAction
extends AcknowledgedTransportMasterNodeAction<DeleteSnapshotRequest> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("cluster:admin/snapshot/delete");
    private final SnapshotsService snapshotsService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportDeleteSnapshotAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, DeleteSnapshotRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.snapshotsService = snapshotsService;
        this.projectResolver = projectResolver;
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteSnapshotRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void doExecute(Task task, DeleteSnapshotRequest request, ActionListener<AcknowledgedResponse> listener) {
        super.doExecute(task, request, listener);
    }

    @Override
    protected void masterOperation(Task task, DeleteSnapshotRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.snapshotsService.deleteSnapshots(this.projectResolver.getProjectId(), request, listener.map(v -> AcknowledgedResponse.TRUE));
    }
}

