/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.delete;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class DeleteSnapshotRequest
extends MasterNodeRequest<DeleteSnapshotRequest> {
    private String repository;
    private String[] snapshots;
    private boolean waitForCompletion = true;

    public DeleteSnapshotRequest(TimeValue masterNodeTimeout, String repository, String ... snapshots) {
        super(masterNodeTimeout);
        this.repository = repository;
        this.snapshots = snapshots;
    }

    public DeleteSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.snapshots = in.readStringArray();
        this.waitForCompletion = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeStringArray(this.snapshots);
        out.writeBoolean(this.waitForCompletion);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.snapshots == null || this.snapshots.length == 0) {
            validationException = ValidateActions.addValidationError("snapshots are missing", validationException);
        }
        return validationException;
    }

    public DeleteSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String[] snapshots() {
        return this.snapshots;
    }

    public DeleteSnapshotRequest snapshots(String ... snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    @Override
    public String getDescription() {
        return Strings.format("[%s]%s", this.repository, Arrays.toString(this.snapshots));
    }

    public DeleteSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }
}

